/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.sowcerext.model;

import cn.zbx1425.sowcer.math.Vector3f;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;

public class Vertex {
    public Vector3f position;
    public Vector3f normal;
    public float u;
    public float v;
    public int color;
    public int light;

    public Vertex() {
    }

    public Vertex(Vector3f position) {
        this.position = position;
        this.normal = new Vector3f(0.0f, 0.0f, 0.0f);
    }

    public Vertex(Vector3f position, Vector3f normal) {
        this.position = position;
        this.normal = normal;
    }

    public Vertex(DataInputStream dis) throws IOException {
        this.position = new Vector3f(dis.readFloat(), dis.readFloat(), dis.readFloat());
        this.normal = new Vector3f(dis.readFloat(), dis.readFloat(), dis.readFloat());
        this.u = dis.readFloat();
        this.v = dis.readFloat();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vertex vertex = (Vertex)o;
        return Float.compare(vertex.u, this.u) == 0 && Float.compare(vertex.v, this.v) == 0 && this.position.equals(vertex.position) && this.normal.equals(vertex.normal);
    }

    public int hashCode() {
        return Objects.hash(this.position, this.normal, Float.valueOf(this.u), Float.valueOf(this.v));
    }

    public Vertex copy() {
        Vertex clone = new Vertex(this.position.copy(), this.normal.copy());
        clone.u = this.u;
        clone.v = this.v;
        clone.color = this.color;
        clone.light = this.light;
        return clone;
    }

    public void serializeTo(DataOutputStream dos) throws IOException {
        dos.writeFloat(this.position.x());
        dos.writeFloat(this.position.y());
        dos.writeFloat(this.position.z());
        dos.writeFloat(this.normal.x());
        dos.writeFloat(this.normal.y());
        dos.writeFloat(this.normal.z());
        dos.writeFloat(this.u);
        dos.writeFloat(this.v);
    }
}

