/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.sowcerext.model.loader;

import cn.zbx1425.sowcer.batch.MaterialProp;
import cn.zbx1425.sowcer.math.Vector3f;
import cn.zbx1425.sowcerext.model.Face;
import cn.zbx1425.sowcerext.model.RawMesh;
import cn.zbx1425.sowcerext.model.RawModel;
import cn.zbx1425.sowcerext.model.Vertex;
import cn.zbx1425.sowcerext.reuse.AtlasManager;
import cn.zbx1425.sowcerext.util.ResourceUtil;
import de.javagl.obj.FloatTuple;
import de.javagl.obj.Mtl;
import de.javagl.obj.MtlReader;
import de.javagl.obj.Obj;
import de.javagl.obj.ObjFace;
import de.javagl.obj.ObjReader;
import de.javagl.obj.ObjSplitting;
import de.javagl.obj.ObjUtils;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import mtr.mappings.Utilities;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.commons.lang3.StringUtils;

public class ObjModelLoader {
    public static RawModel loadModel(ResourceManager resourceManager, ResourceLocation objLocation, AtlasManager atlasManager) throws IOException {
        Obj srcObj = ObjReader.read(Utilities.getInputStream((Optional)resourceManager.m_213713_(objLocation)));
        Map<String, Mtl> materials = ObjModelLoader.loadMaterials(resourceManager, srcObj, objLocation);
        RawModel model = ObjModelLoader.loadModel(srcObj, objLocation, materials, atlasManager);
        model.sourceLocation = objLocation;
        return model;
    }

    public static Map<String, RawModel> loadModels(ResourceManager resourceManager, ResourceLocation objLocation, AtlasManager atlasManager) throws IOException {
        Obj srcObj = ObjReader.read(Utilities.getInputStream((Optional)resourceManager.m_213713_(objLocation)));
        Map<String, Mtl> materials = ObjModelLoader.loadMaterials(resourceManager, srcObj, objLocation);
        HashMap<String, RawModel> result = new HashMap<String, RawModel>();
        Map<String, Obj> groupObjs = ObjSplitting.splitByGroups(srcObj);
        for (Map.Entry<String, Obj> groupEntry : groupObjs.entrySet()) {
            RawModel model = ObjModelLoader.loadModel(groupEntry.getValue(), objLocation, materials, atlasManager);
            String compliantKey = groupEntry.getKey().toLowerCase(Locale.ROOT).replace('\\', '/').replaceAll("[^a-z0-9/._-]", "_");
            model.sourceLocation = new ResourceLocation(objLocation.m_135827_(), objLocation.m_135815_() + "/" + compliantKey);
            result.put(groupEntry.getKey(), model);
        }
        return result;
    }

    public static Map<String, RawModel> loadExternalModels(String path, AtlasManager atlasManager) throws IOException {
        try (BufferedInputStream fis = new BufferedInputStream(new FileInputStream(path));){
            Obj srcObj = ObjReader.read(fis);
            HashMap<String, RawModel> result = new HashMap<String, RawModel>();
            Map<String, Obj> groupObjs = ObjSplitting.splitByGroups(srcObj);
            for (Map.Entry<String, Obj> groupEntry : groupObjs.entrySet()) {
                RawModel model = ObjModelLoader.loadModel(groupEntry.getValue(), null, null, atlasManager);
                String compliantPath = path.toLowerCase(Locale.ROOT).replace('\\', '/').replaceAll("[^a-z0-9/._-]", "_");
                String compliantKey = groupEntry.getKey().toLowerCase(Locale.ROOT).replace('\\', '/').replaceAll("[^a-z0-9/._-]", "_");
                model.sourceLocation = new ResourceLocation("mtrsteamloco-external", compliantPath + "/" + compliantKey);
                result.put(groupEntry.getKey(), model);
            }
            HashMap<String, RawModel> hashMap = result;
            return hashMap;
        }
    }

    private static RawModel loadModel(Obj srcObj, ResourceLocation objLocation, Map<String, Mtl> materials, AtlasManager atlasManager) {
        Map<String, Obj> mtlObjs = ObjSplitting.splitByMaterialGroups(srcObj);
        RawModel model = new RawModel();
        for (Map.Entry<String, Obj> entry : mtlObjs.entrySet()) {
            int i;
            if (entry.getValue().getNumFaces() == 0) continue;
            Map<String, String> materialOptions = ObjModelLoader.splitMaterialOptions(entry.getKey());
            String materialGroupName = materialOptions.get("");
            String meshRenderType = materialOptions.getOrDefault("#", "exterior").toLowerCase(Locale.ROOT);
            boolean flipV = materialOptions.getOrDefault("flipv", "0").equals("1");
            MaterialProp materialProp = new MaterialProp();
            if (materials != null && materials.size() > 0 && objLocation != null) {
                Mtl objMaterial = materials.getOrDefault(entry.getKey(), null);
                if (objMaterial != null) {
                    if (!StringUtils.isEmpty((CharSequence)objMaterial.getMapKd())) {
                        materialProp.texture = ResourceUtil.resolveRelativePath(objLocation, objMaterial.getMapKd(), ".png");
                    }
                    FloatTuple color = objMaterial.getKd();
                    materialProp.attrState.setColor((int)(color.getX() * 255.0f), (int)(color.getY() * 255.0f), (int)(color.getZ() * 255.0f), (int)(objMaterial.getD() * 255.0f));
                }
            } else if (objLocation != null) {
                materialProp.texture = materialGroupName.equals("_") ? null : ResourceUtil.resolveRelativePath(objLocation, materialGroupName, ".png");
                materialProp.attrState.setColor(255, 255, 255, 255);
            } else {
                materialProp.texture = null;
                materialProp.attrState.setColor(255, 255, 255, 255);
            }
            Obj renderObjMesh = ObjUtils.convertToRenderable(entry.getValue());
            RawMesh mesh = new RawMesh(materialProp);
            mesh.setRenderType(meshRenderType);
            for (i = 0; i < renderObjMesh.getNumVertices(); ++i) {
                FloatTuple pos = renderObjMesh.getVertex(i);
                FloatTuple normal = i < renderObjMesh.getNumNormals() ? renderObjMesh.getNormal(i) : ZeroFloatTuple.ZERO3;
                FloatTuple uv = i < renderObjMesh.getNumTexCoords() ? renderObjMesh.getTexCoord(i) : ZeroFloatTuple.ZERO2;
                Vertex seVertex = new Vertex(new Vector3f(pos.getX(), pos.getY(), pos.getZ()), new Vector3f(normal.getX(), normal.getY(), normal.getZ()));
                seVertex.u = uv.getX();
                seVertex.v = flipV ? 1.0f - uv.getY() : uv.getY();
                mesh.vertices.add(seVertex);
            }
            for (i = 0; i < renderObjMesh.getNumFaces(); ++i) {
                ObjFace face = renderObjMesh.getFace(i);
                mesh.faces.add(new Face(new int[]{face.getVertexIndex(0), face.getVertexIndex(1), face.getVertexIndex(2)}));
            }
            if (atlasManager != null) {
                atlasManager.applyToMesh(mesh);
            }
            model.append(mesh);
        }
        model.generateNormals();
        model.distinct();
        return model;
    }

    private static Map<String, Mtl> loadMaterials(ResourceManager resourceManager, Obj srcObj, ResourceLocation objLocation) throws IOException {
        HashMap<String, Mtl> materials = new HashMap<String, Mtl>();
        for (String mtlFileName : srcObj.getMtlFileNames()) {
            List<Mtl> srcMtls = MtlReader.read(Utilities.getInputStream((Optional)resourceManager.m_213713_(ResourceUtil.resolveRelativePath(objLocation, mtlFileName, ".mtl"))));
            for (Mtl mtl : srcMtls) {
                materials.put(mtl.getName(), mtl);
            }
        }
        return materials;
    }

    private static Map<String, String> splitMaterialOptions(String src) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] majorParts = src.split("#", 2);
        result.put("", majorParts[0]);
        if (majorParts.length > 1) {
            for (String minorPart : majorParts[1].split(",")) {
                String[] tokens = minorPart.split("=", 2);
                if (tokens.length > 1) {
                    result.put(tokens[0], tokens[1]);
                    continue;
                }
                if (!result.containsKey("#")) {
                    result.put("#", tokens[0]);
                    continue;
                }
                result.put(tokens[0].toLowerCase(Locale.ROOT), "1");
            }
        }
        return result;
    }

    private static class ZeroFloatTuple
    implements FloatTuple {
        public static final ZeroFloatTuple ZERO2 = new ZeroFloatTuple(2);
        public static final ZeroFloatTuple ZERO3 = new ZeroFloatTuple(3);
        private final int dimensions;

        public ZeroFloatTuple(int dimensions) {
            this.dimensions = dimensions;
        }

        @Override
        public float getX() {
            return 0.0f;
        }

        @Override
        public float getY() {
            return 0.0f;
        }

        @Override
        public float getZ() {
            return 0.0f;
        }

        @Override
        public float getW() {
            return 0.0f;
        }

        @Override
        public float get(int index) {
            return 0.0f;
        }

        @Override
        public int getDimensions() {
            return this.dimensions;
        }
    }
}

