/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.sowcerext.multipart.animated.script;

import cn.zbx1425.sowcerext.multipart.MultipartUpdateProp;
import cn.zbx1425.sowcerext.multipart.animated.script.FunctionScript;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class Executor {
    private static final Random randomGenerator = new Random();

    static double ExecuteFunctionScript(FunctionScript Function2, MultipartUpdateProp prop, double elapsedTime, int CurrentState, double lastResult) {
        int s = 0;
        int c = 0;
        block146: for (int i = 0; i < Function2.InstructionSet.length; ++i) {
            switch (Function2.InstructionSet[i]) {
                case SystemHalt: {
                    i = Function2.InstructionSet.length;
                    continue block146;
                }
                case SystemConstant: {
                    Function2.Stack[s] = Function2.Constants[c];
                    ++s;
                    ++c;
                    continue block146;
                }
                case SystemConstantArray: {
                    int n = Function2.InstructionSet[i + 1].ordinal();
                    for (int j = 0; j < n; ++j) {
                        Function2.Stack[s + j] = Function2.Constants[c + j];
                    }
                    s += n;
                    c += n;
                    ++i;
                    continue block146;
                }
                case SystemValue: {
                    Function2.Stack[s] = lastResult;
                    ++s;
                    continue block146;
                }
                case SystemDelta: {
                    Function2.Stack[s] = elapsedTime;
                    ++s;
                    continue block146;
                }
                case StackCopy: {
                    Function2.Stack[s] = Function2.Stack[s - 1];
                    ++s;
                    continue block146;
                }
                case StackSwap: {
                    double a = Function2.Stack[s - 1];
                    Function2.Stack[s - 1] = Function2.Stack[s - 2];
                    Function2.Stack[s - 2] = a;
                    continue block146;
                }
                case MathPlus: {
                    int n = s - 2;
                    Function2.Stack[n] = Function2.Stack[n] + Function2.Stack[s - 1];
                    --s;
                    continue block146;
                }
                case MathSubtract: {
                    int n = s - 2;
                    Function2.Stack[n] = Function2.Stack[n] - Function2.Stack[s - 1];
                    --s;
                    continue block146;
                }
                case MathMinus: {
                    Function2.Stack[s - 1] = -Function2.Stack[s - 1];
                    continue block146;
                }
                case MathTimes: {
                    int n = s - 2;
                    Function2.Stack[n] = Function2.Stack[n] * Function2.Stack[s - 1];
                    --s;
                    continue block146;
                }
                case MathDivide: {
                    Function2.Stack[s - 2] = Function2.Stack[s - 1] == 0.0 ? 0.0 : Function2.Stack[s - 2] / Function2.Stack[s - 1];
                    --s;
                    continue block146;
                }
                case MathReciprocal: {
                    Function2.Stack[s - 1] = Function2.Stack[s - 1] == 0.0 ? 0.0 : 1.0 / Function2.Stack[s - 1];
                    continue block146;
                }
                case MathPower: {
                    double a = Function2.Stack[s - 2];
                    double b = Function2.Stack[s - 1];
                    if (b == 2.0) {
                        Function2.Stack[s - 2] = a * a;
                    } else if (b == 3.0) {
                        Function2.Stack[s - 2] = a * a * a;
                    } else if (b == 4.0) {
                        t = a * a;
                        Function2.Stack[s - 2] = t * t;
                    } else if (b == 5.0) {
                        t = a * a;
                        Function2.Stack[s - 2] = t * t * a;
                    } else if (b == 6.0) {
                        t = a * a * a;
                        Function2.Stack[s - 2] = t * t;
                    } else if (b == 7.0) {
                        t = a * a * a;
                        Function2.Stack[s - 2] = t * t * a;
                    } else if (b == 8.0) {
                        t = a * a;
                        t *= t;
                        Function2.Stack[s - 2] = t * t;
                    } else {
                        Function2.Stack[s - 2] = b == 0.0 ? 1.0 : (b < 0.0 ? 0.0 : Math.pow(a, b));
                    }
                    --s;
                    continue block146;
                }
                case MathRandom: {
                    double min = Function2.Stack[s - 2];
                    double max = Function2.Stack[s - 1];
                    Function2.Stack[s - 2] = min + randomGenerator.nextDouble() * (max - min);
                    --s;
                    continue block146;
                }
                case MathRandomInt: {
                    int min = (int)Function2.Stack[s - 2];
                    int max = (int)Function2.Stack[s - 1];
                    Function2.Stack[s - 2] = ThreadLocalRandom.current().nextInt(max) + min;
                    --s;
                    continue block146;
                }
                case MathIncrement: {
                    int n = s - 1;
                    Function2.Stack[n] = Function2.Stack[n] + 1.0;
                    continue block146;
                }
                case MathDecrement: {
                    int n = s - 1;
                    Function2.Stack[n] = Function2.Stack[n] - 1.0;
                    continue block146;
                }
                case MathFusedMultiplyAdd: {
                    Function2.Stack[s - 3] = Function2.Stack[s - 3] * Function2.Stack[s - 2] + Function2.Stack[s - 1];
                    s -= 2;
                    continue block146;
                }
                case MathQuotient: {
                    Function2.Stack[s - 2] = Function2.Stack[s - 1] == 0.0 ? 0.0 : Math.floor(Function2.Stack[s - 2] / Function2.Stack[s - 1]);
                    --s;
                    continue block146;
                }
                case MathMod: {
                    Function2.Stack[s - 2] = Function2.Stack[s - 1] == 0.0 ? 0.0 : Function2.Stack[s - 2] - Function2.Stack[s - 1] * Math.floor(Function2.Stack[s - 2] / Function2.Stack[s - 1]);
                    --s;
                    continue block146;
                }
                case MathFloor: {
                    Function2.Stack[s - 1] = Math.floor(Function2.Stack[s - 1]);
                    continue block146;
                }
                case MathCeiling: {
                    Function2.Stack[s - 1] = Math.ceil(Function2.Stack[s - 1]);
                    continue block146;
                }
                case MathRound: {
                    Function2.Stack[s - 1] = Math.round(Function2.Stack[s - 1]);
                    continue block146;
                }
                case MathMin: {
                    Function2.Stack[s - 2] = Function2.Stack[s - 2] < Function2.Stack[s - 1] ? Function2.Stack[s - 2] : Function2.Stack[s - 1];
                    --s;
                    continue block146;
                }
                case MathMax: {
                    Function2.Stack[s - 2] = Function2.Stack[s - 2] > Function2.Stack[s - 1] ? Function2.Stack[s - 2] : Function2.Stack[s - 1];
                    --s;
                    continue block146;
                }
                case MathAbs: {
                    Function2.Stack[s - 1] = Math.abs(Function2.Stack[s - 1]);
                    continue block146;
                }
                case MathSign: {
                    Function2.Stack[s - 1] = Math.signum(Function2.Stack[s - 1]);
                    continue block146;
                }
                case MathExp: {
                    Function2.Stack[s - 1] = Math.exp(Function2.Stack[s - 1]);
                    continue block146;
                }
                case MathLog: {
                    Function2.Stack[s - 1] = Executor.Log(Function2.Stack[s - 1]);
                    continue block146;
                }
                case MathSqrt: {
                    Function2.Stack[s - 1] = Executor.Sqrt(Function2.Stack[s - 1]);
                    continue block146;
                }
                case MathSin: {
                    Function2.Stack[s - 1] = Math.sin(Function2.Stack[s - 1]);
                    continue block146;
                }
                case MathCos: {
                    Function2.Stack[s - 1] = Math.cos(Function2.Stack[s - 1]);
                    continue block146;
                }
                case MathTan: {
                    Function2.Stack[s - 1] = Executor.Tan(Function2.Stack[s - 1]);
                    continue block146;
                }
                case MathArcTan: {
                    Function2.Stack[s - 1] = Math.atan(Function2.Stack[s - 1]);
                    continue block146;
                }
                case MathPi: {
                    Function2.Stack[s] = Math.PI;
                    ++s;
                    continue block146;
                }
                case CompareEqual: {
                    Function2.Stack[s - 2] = Function2.Stack[s - 2] == Function2.Stack[s - 1] ? 1.0 : 0.0;
                    --s;
                    continue block146;
                }
                case CompareUnequal: {
                    Function2.Stack[s - 2] = Function2.Stack[s - 2] != Function2.Stack[s - 1] ? 1.0 : 0.0;
                    --s;
                    continue block146;
                }
                case CompareLess: {
                    Function2.Stack[s - 2] = Function2.Stack[s - 2] < Function2.Stack[s - 1] ? 1.0 : 0.0;
                    --s;
                    continue block146;
                }
                case CompareGreater: {
                    Function2.Stack[s - 2] = Function2.Stack[s - 2] > Function2.Stack[s - 1] ? 1.0 : 0.0;
                    --s;
                    continue block146;
                }
                case CompareLessEqual: {
                    Function2.Stack[s - 2] = Function2.Stack[s - 2] <= Function2.Stack[s - 1] ? 1.0 : 0.0;
                    --s;
                    continue block146;
                }
                case CompareGreaterEqual: {
                    Function2.Stack[s - 2] = Function2.Stack[s - 2] >= Function2.Stack[s - 1] ? 1.0 : 0.0;
                    --s;
                    continue block146;
                }
                case CompareConditional: {
                    Function2.Stack[s - 3] = Function2.Stack[s - 3] != 0.0 ? Function2.Stack[s - 2] : Function2.Stack[s - 1];
                    s -= 2;
                    continue block146;
                }
                case LogicalNot: {
                    Function2.Stack[s - 1] = Function2.Stack[s - 1] != 0.0 ? 0.0 : 1.0;
                    continue block146;
                }
                case LogicalAnd: {
                    Function2.Stack[s - 2] = Function2.Stack[s - 2] != 0.0 & Function2.Stack[s - 1] != 0.0 ? 1.0 : 0.0;
                    --s;
                    continue block146;
                }
                case LogicalOr: {
                    Function2.Stack[s - 2] = Function2.Stack[s - 2] != 0.0 | Function2.Stack[s - 1] != 0.0 ? 1.0 : 0.0;
                    --s;
                    continue block146;
                }
                case LogicalNand: {
                    Function2.Stack[s - 2] = Function2.Stack[s - 2] != 0.0 & Function2.Stack[s - 1] != 0.0 ? 0.0 : 1.0;
                    --s;
                    continue block146;
                }
                case LogicalNor: {
                    Function2.Stack[s - 2] = Function2.Stack[s - 2] != 0.0 | Function2.Stack[s - 1] != 0.0 ? 0.0 : 1.0;
                    --s;
                    continue block146;
                }
                case LogicalXor: {
                    Function2.Stack[s - 2] = Function2.Stack[s - 2] != 0.0 ^ Function2.Stack[s - 1] != 0.0 ? 1.0 : 0.0;
                    --s;
                    continue block146;
                }
                case CurrentObjectState: {
                    Function2.Stack[s] = CurrentState;
                    ++s;
                    continue block146;
                }
                case TimeSecondsSinceMidnight: {
                    Function2.Stack[s] = prop.systemTimeSecMidnight;
                    ++s;
                    continue block146;
                }
                case TimeHourDigit: {
                    Function2.Stack[s] = Math.floor((double)prop.systemTimeSecMidnight / 3600.0);
                    ++s;
                    continue block146;
                }
                case TimeMinuteDigit: {
                    Function2.Stack[s] = Math.floor(prop.systemTimeSecMidnight / 60.0f % 60.0f);
                    ++s;
                    continue block146;
                }
                case TimeSecondDigit: {
                    Function2.Stack[s] = Math.floor(prop.systemTimeSecMidnight % 60.0f);
                    ++s;
                    continue block146;
                }
                case CameraDistance: 
                case CameraXDistance: 
                case CameraYDistance: 
                case CameraZDistance: 
                case CameraView: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case PlayerTrain: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case TrainCars: {
                    Function2.Stack[s] = prop.trainCars;
                    ++s;
                    continue block146;
                }
                case TrainDestination: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case TrainSpeed: {
                    Function2.Stack[s] = prop.speed;
                    ++s;
                    continue block146;
                }
                case TrainSpeedOfCar: {
                    Function2.Stack[s - 1] = prop.speed;
                    continue block146;
                }
                case TrainSpeedometer: {
                    Function2.Stack[s] = prop.speed;
                    ++s;
                    continue block146;
                }
                case TrainSpeedometerOfCar: {
                    Function2.Stack[s - 1] = prop.speed;
                    continue block146;
                }
                case TrainAcceleration: {
                    Function2.Stack[s] = prop.acceleration;
                    ++s;
                    continue block146;
                }
                case TrainAccelerationOfCar: {
                    Function2.Stack[s - 1] = prop.acceleration;
                    continue block146;
                }
                case TrainAccelerationMotor: {
                    Function2.Stack[s] = prop.acceleration;
                    ++s;
                    continue block146;
                }
                case TrainAccelerationMotorOfCar: {
                    Function2.Stack[s - 1] = prop.acceleration;
                    continue block146;
                }
                case TrainDistance: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case TrainDistanceToCar: {
                    Function2.Stack[s - 1] = 0.0;
                    continue block146;
                }
                case TrainTrackDistance: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case CurveRadius: {
                    Function2.Stack[s] = 0.0;
                    continue block146;
                }
                case CurveRadiusOfCar: {
                    Function2.Stack[s - 1] = 0.0;
                    continue block146;
                }
                case FrontAxleCurveRadius: {
                    Function2.Stack[s] = 0.0;
                    continue block146;
                }
                case FrontAxleCurveRadiusOfCar: {
                    Function2.Stack[s - 1] = 0.0;
                    continue block146;
                }
                case RearAxleCurveRadius: {
                    Function2.Stack[s] = 0.0;
                    continue block146;
                }
                case RearAxleCurveRadiusOfCar: {
                    Function2.Stack[s - 1] = 0.0;
                    continue block146;
                }
                case CurveCant: {
                    Function2.Stack[s] = 0.0;
                    continue block146;
                }
                case CurveCantOfCar: {
                    Function2.Stack[s - 1] = 0.0;
                    continue block146;
                }
                case Pitch: {
                    Function2.Stack[s] = 0.0;
                    continue block146;
                }
                case PitchOfCar: {
                    Function2.Stack[s - 1] = 0.0;
                    continue block146;
                }
                case Odometer: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case OdometerOfCar: {
                    Function2.Stack[s - 1] = 0.0;
                    continue block146;
                }
                case TrainTrackDistanceToCar: {
                    Function2.Stack[s - 1] = 0.0;
                    continue block146;
                }
                case Doors: {
                    Function2.Stack[s] = Math.max(prop.leftDoorState, prop.rightDoorState);
                    ++s;
                    continue block146;
                }
                case DoorsIndex: {
                    Function2.Stack[s - 1] = Math.max(prop.leftDoorState, prop.rightDoorState);
                    continue block146;
                }
                case LeftDoors: {
                    Function2.Stack[s] = prop.leftDoorState;
                    ++s;
                    continue block146;
                }
                case LeftDoorsIndex: {
                    Function2.Stack[s - 1] = prop.leftDoorState;
                    continue block146;
                }
                case RightDoors: {
                    Function2.Stack[s] = prop.rightDoorState;
                    ++s;
                    continue block146;
                }
                case RightDoorsIndex: {
                    Function2.Stack[s - 1] = prop.rightDoorState;
                    continue block146;
                }
                case LeftDoorsTarget: {
                    Function2.Stack[s] = prop.leftDoorTarget;
                    ++s;
                    continue block146;
                }
                case LeftDoorsTargetIndex: {
                    Function2.Stack[s - 1] = prop.leftDoorTarget;
                    continue block146;
                }
                case RightDoorsTarget: {
                    Function2.Stack[s] = prop.rightDoorTarget;
                    ++s;
                    continue block146;
                }
                case RightDoorsTargetIndex: {
                    Function2.Stack[s - 1] = prop.rightDoorTarget;
                    continue block146;
                }
                case LeftDoorButton: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case RightDoorButton: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case PilotLamp: {
                    Function2.Stack[s] = (double)prop.leftDoorState == 0.0 && (double)prop.rightDoorState == 0.0 ? 1.0 : 0.0;
                    ++s;
                    continue block146;
                }
                case PassAlarm: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case StationAdjustAlarm: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case ReverserNotch: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case PowerNotch: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case PowerNotches: {
                    Function2.Stack[s] = 5.0;
                    ++s;
                    continue block146;
                }
                case LocoBrakeNotch: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case LocoBrakeNotches: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case BrakeNotch: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case BrakeNotches: {
                    Function2.Stack[s] = 7.0;
                    ++s;
                    continue block146;
                }
                case BrakeNotchLinear: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case BrakeNotchesLinear: {
                    Function2.Stack[s] = 7.0;
                    ++s;
                    continue block146;
                }
                case EmergencyBrake: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case Klaxon: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case PrimaryKlaxon: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case SecondaryKlaxon: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case MusicKlaxon: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case HasAirBrake: {
                    Function2.Stack[s] = 1.0;
                    ++s;
                    continue block146;
                }
                case HoldBrake: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case HasHoldBrake: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case ConstSpeed: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case HasConstSpeed: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case BrakeMainReservoir: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case BrakeMainReservoirOfCar: {
                    Function2.Stack[s - 1] = 0.0;
                    continue block146;
                }
                case BrakeEqualizingReservoir: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case BrakeEqualizingReservoirOfCar: {
                    Function2.Stack[s - 1] = 0.0;
                    continue block146;
                }
                case BrakeBrakePipe: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case BrakeBrakePipeOfCar: {
                    Function2.Stack[s - 1] = 0.0;
                    continue block146;
                }
                case BrakeBrakeCylinder: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case BrakeBrakeCylinderOfCar: {
                    Function2.Stack[s - 1] = 0.0;
                    continue block146;
                }
                case BrakeStraightAirPipe: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case BrakeStraightAirPipeOfCar: {
                    Function2.Stack[s - 1] = 0.0;
                    continue block146;
                }
                case SafetyPluginAvailable: {
                    Function2.Stack[s] = 1.0;
                    ++s;
                    continue block146;
                }
                case SafetyPluginState: {
                    int n = (int)Math.round(Function2.Stack[s - 1]);
                    if (prop.pluginState != null) {
                        if (n >= 0 & n < prop.pluginState.length) {
                            Function2.Stack[s - 1] = prop.pluginState[n];
                            continue block146;
                        }
                        Function2.Stack[s - 1] = 0.0;
                        continue block146;
                    }
                    Function2.Stack[s - 1] = 0.0;
                    continue block146;
                }
                case TimetableVisible: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case Panel2Timetable: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case DistanceNextStation: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case StopsNextStation: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case DistanceStation: {
                    Function2.Stack[s - 1] = 0.0;
                    continue block146;
                }
                case StopsStation: {
                    Function2.Stack[s - 1] = 0.0;
                    continue block146;
                }
                case NextStation: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case NextStationStop: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case TerminalStation: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case RouteLimit: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case SectionAspectNumber: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case RainDrop: {
                    Function2.Stack[s - 1] = 0.0;
                    continue block146;
                }
                case SnowFlake: {
                    Function2.Stack[s - 1] = 0.0;
                    continue block146;
                }
                case WiperPosition: {
                    Function2.Stack[s] = 0.0;
                    ++s;
                    continue block146;
                }
                case BrightnessOfCar: {
                    Function2.Stack[s - 1] = 0.0;
                    continue block146;
                }
                case TrainCarNumber: {
                    Function2.Stack[s] = prop.carIndex;
                    ++s;
                    continue block146;
                }
                default: {
                    throw new IllegalArgumentException("The unknown instruction " + Function2.InstructionSet[i].toString() + " was encountered in ExecuteFunctionScript.");
                }
            }
        }
        return Function2.Stack[s - 1];
    }

    private static double Log(double X) {
        if (X <= 0.0) {
            return 0.0;
        }
        return Math.log(X);
    }

    private static double Sqrt(double X) {
        if (X < 0.0) {
            return 0.0;
        }
        return Math.sqrt(X);
    }

    private static double Tan(double X) {
        double e;
        double c = X / Math.PI;
        double d = c - Math.floor(c) - 0.5;
        if (d >= -(e = Math.floor(X >= 0.0 ? X : -X) * 1.38462643383279E-16) & d <= e) {
            return 0.0;
        }
        return Math.tan(X);
    }
}

