/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.sowcerext.reuse;

import cn.zbx1425.sowcerext.model.RawMesh;
import cn.zbx1425.sowcerext.model.Vertex;
import cn.zbx1425.sowcerext.util.Logging;
import net.minecraft.resources.ResourceLocation;

public class AtlasSprite {
    public ResourceLocation sheet;
    public int sheetWidth;
    public int sheetHeight;
    public int frameX;
    public int frameY;
    public int frameWidth;
    public int frameHeight;
    public int spriteX;
    public int spriteY;
    public int spriteWidth;
    public int spriteHeight;
    public int sourceWidth;
    public int sourceHeight;
    public boolean rotated;

    public void applyToMesh(RawMesh mesh) {
        boolean uvBleeding = false;
        for (Vertex vertex : mesh.vertices) {
            vertex.u = AtlasSprite.mapRange(vertex.u, (float)this.spriteX / (float)this.sourceWidth, (float)(this.spriteX + this.spriteWidth) / (float)this.sourceWidth, 0.0f, 1.0f);
            vertex.v = AtlasSprite.mapRange(vertex.v, (float)this.spriteY / (float)this.spriteHeight, (float)(this.spriteY + this.spriteHeight) / (float)this.sourceHeight, 0.0f, 1.0f);
            if (vertex.u < 0.0f || vertex.u > 1.0f || vertex.v < 0.0f || vertex.v > 1.0f) {
                uvBleeding = true;
            }
            vertex.u = AtlasSprite.mapRange(vertex.u, 0.0f, 1.0f, (float)this.frameX / (float)this.sheetWidth, (float)(this.frameX + this.frameWidth) / (float)this.sheetWidth);
            vertex.v = AtlasSprite.mapRange(vertex.v, 0.0f, 1.0f, (float)this.frameY / (float)this.sheetHeight, (float)(this.frameY + this.frameHeight) / (float)this.sheetHeight);
        }
        if (uvBleeding) {
            Logging.LOGGER.warn("UV bleeding into adjacent sprite in " + mesh.materialProp.texture);
        }
        mesh.materialProp.texture = this.sheet;
    }

    private static float mapRange(float x, float in_min, float in_max, float out_min, float out_max) {
        return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
    }

    public AtlasSprite(ResourceLocation sheet, int sheetWidth, int sheetHeight, int frameX, int frameY, int frameWidth, int frameHeight, int spriteX, int spriteY, int spriteWidth, int spriteHeight, int sourceWidth, int sourceHeight, boolean rotated) {
        this.sheet = sheet;
        this.sheetWidth = sheetWidth;
        this.sheetHeight = sheetHeight;
        this.frameX = frameX;
        this.frameY = frameY;
        this.frameWidth = frameWidth;
        this.frameHeight = frameHeight;
        this.spriteX = spriteX;
        this.spriteY = spriteY;
        this.spriteWidth = spriteWidth;
        this.spriteHeight = spriteHeight;
        this.sourceWidth = sourceWidth;
        this.sourceHeight = sourceHeight;
        this.rotated = rotated;
    }
}

