/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.sowcerext.reuse;

import cn.zbx1425.sowcer.batch.BatchManager;
import cn.zbx1425.sowcer.math.Matrix4f;
import cn.zbx1425.sowcer.shader.ShaderManager;
import cn.zbx1425.sowcer.util.GlStateTracker;
import cn.zbx1425.sowcer.util.Profiler;
import cn.zbx1425.sowcerext.model.ModelCluster;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.server.packs.resources.ResourceManager;

public class DrawScheduler {
    public final BatchManager batchManager = new BatchManager();
    public final ShaderManager shaderManager = new ShaderManager();
    private final List<ClusterDrawCall> drawCalls = new LinkedList<ClusterDrawCall>();

    public void reloadShaders(ResourceManager resourceManager) throws IOException {
        this.shaderManager.reloadShaders(resourceManager);
    }

    public void enqueue(ModelCluster model, Matrix4f pose, int light) {
        this.drawCalls.add(new ClusterDrawCall(model, pose, light));
    }

    public void commit(MultiBufferSource vertexConsumers, boolean isOptimized, Profiler profiler) {
        if (isOptimized && !this.shaderManager.isReady()) {
            return;
        }
        if (this.drawCalls.size() < 1) {
            return;
        }
        for (ClusterDrawCall drawCall : this.drawCalls) {
            if (isOptimized && drawCall.model.isUploaded()) {
                drawCall.model.renderOpaqueOptimized(this.batchManager, drawCall.pose, drawCall.light, profiler);
                continue;
            }
            drawCall.model.renderOpaqueUnoptimized(vertexConsumers, drawCall.pose, drawCall.light, profiler);
        }
        if (isOptimized) {
            GlStateTracker.capture();
            this.commitRaw(profiler);
            GlStateTracker.restore();
        }
        for (ClusterDrawCall drawCall : this.drawCalls) {
            drawCall.model.renderTranslucent(vertexConsumers, drawCall.pose, drawCall.light, profiler);
        }
        this.drawCalls.clear();
    }

    public void commitRaw(Profiler profiler) {
        this.batchManager.drawAll(this.shaderManager, profiler);
    }

    private static class ClusterDrawCall {
        public ModelCluster model;
        public Matrix4f pose;
        public int light;

        public ClusterDrawCall(ModelCluster model, Matrix4f pose, int light) {
            this.model = model;
            this.pose = pose;
            this.light = light;
        }
    }
}

