/*
 * Decompiled with CFR 0.152.
 */
package cn.zbx1425.sowcerext.reuse;

import cn.zbx1425.sowcer.model.Model;
import cn.zbx1425.sowcer.vertex.VertAttrMapping;
import cn.zbx1425.sowcer.vertex.VertAttrSrc;
import cn.zbx1425.sowcer.vertex.VertAttrType;
import cn.zbx1425.sowcerext.model.ModelCluster;
import cn.zbx1425.sowcerext.model.RawModel;
import cn.zbx1425.sowcerext.model.loader.CsvModelLoader;
import cn.zbx1425.sowcerext.model.loader.NmbModelLoader;
import cn.zbx1425.sowcerext.model.loader.ObjModelLoader;
import cn.zbx1425.sowcerext.reuse.AtlasManager;
import java.io.IOException;
import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.commons.io.FilenameUtils;

public class ModelManager {
    public HashMap<ResourceLocation, Model> uploadedModels = new HashMap();
    public HashMap<ResourceLocation, ModelCluster> uploadedVertArrays = new HashMap();
    public HashMap<ResourceLocation, RawModel> loadedRawModels = new HashMap();
    public int uploadedVertArraysCount = 0;
    public static final VertAttrMapping DEFAULT_MAPPING = new VertAttrMapping.Builder().set(VertAttrType.POSITION, VertAttrSrc.VERTEX_BUF).set(VertAttrType.COLOR, VertAttrSrc.GLOBAL).set(VertAttrType.UV_TEXTURE, VertAttrSrc.VERTEX_BUF).set(VertAttrType.UV_OVERLAY, VertAttrSrc.GLOBAL).set(VertAttrType.UV_LIGHTMAP, VertAttrSrc.GLOBAL).set(VertAttrType.NORMAL, VertAttrSrc.VERTEX_BUF).set(VertAttrType.MATRIX_MODEL, VertAttrSrc.GLOBAL).build();

    public void clear() {
        for (ModelCluster vertArrays : this.uploadedVertArrays.values()) {
            vertArrays.close();
        }
        this.uploadedVertArrays.clear();
        for (Model model : this.uploadedModels.values()) {
            model.close();
        }
        this.uploadedModels.clear();
        this.loadedRawModels.clear();
        this.uploadedVertArraysCount = 0;
    }

    public void clearNamespace(String namespace) {
        this.uploadedVertArrays.entrySet().stream().filter(k -> ((ResourceLocation)k.getKey()).m_135827_().equals(namespace)).forEach(k -> {
            ((ModelCluster)k.getValue()).close();
            --this.uploadedVertArraysCount;
        });
        this.uploadedVertArrays.keySet().removeIf(k -> k.m_135827_().equals(namespace));
        this.uploadedModels.entrySet().stream().filter(k -> ((ResourceLocation)k.getKey()).m_135827_().equals(namespace)).forEach(k -> ((Model)k.getValue()).close());
        this.uploadedModels.keySet().removeIf(k -> k.m_135827_().equals(namespace));
        this.loadedRawModels.keySet().removeIf(k -> k.m_135827_().equals(namespace));
    }

    public RawModel loadRawModel(ResourceManager resourceManager, ResourceLocation objLocation, AtlasManager atlasManager) throws IOException {
        String crntStatExt;
        if (this.loadedRawModels.containsKey(objLocation)) {
            return this.loadedRawModels.get(objLocation);
        }
        RawModel result = switch (crntStatExt = FilenameUtils.getExtension((String)objLocation.m_135815_())) {
            case "obj" -> ObjModelLoader.loadModel(resourceManager, objLocation, atlasManager);
            case "csv" -> CsvModelLoader.loadModel(resourceManager, objLocation, atlasManager);
            case "nmb" -> NmbModelLoader.loadModel(resourceManager, objLocation, atlasManager);
            case "animated" -> throw new IllegalArgumentException("ANIMATED model cannot be loaded as RawModel.");
            default -> throw new IllegalArgumentException("Unknown model format: " + resourceManager);
        };
        this.loadedRawModels.put(objLocation, result);
        return result;
    }

    public Model uploadModel(RawModel rawModel) {
        if (rawModel.sourceLocation == null) {
            return rawModel.upload(DEFAULT_MAPPING);
        }
        if (this.uploadedModels.containsKey(rawModel.sourceLocation)) {
            return this.uploadedModels.get(rawModel.sourceLocation);
        }
        Model result = rawModel.upload(DEFAULT_MAPPING);
        this.uploadedModels.put(rawModel.sourceLocation, result);
        return result;
    }

    public ModelCluster uploadVertArrays(RawModel rawModel) {
        if (rawModel.sourceLocation == null) {
            ++this.uploadedVertArraysCount;
            return new ModelCluster(rawModel, DEFAULT_MAPPING);
        }
        if (this.uploadedVertArrays.containsKey(rawModel.sourceLocation)) {
            return this.uploadedVertArrays.get(rawModel.sourceLocation);
        }
        ++this.uploadedVertArraysCount;
        ModelCluster result = new ModelCluster(rawModel, DEFAULT_MAPPING);
        this.uploadedVertArrays.put(rawModel.sourceLocation, result);
        return result;
    }
}

