/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.forge.item;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.blay09.mods.balm.api.DeferredObject;
import net.blay09.mods.balm.api.item.BalmItems;
import net.blay09.mods.balm.forge.DeferredRegisters;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.CreativeModeTabEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.Nullable;

public class ForgeBalmItems
implements BalmItems {
    private final Map<String, Registrations> registrations = new ConcurrentHashMap<String, Registrations>();

    @Override
    public Item.Properties itemProperties() {
        return new Item.Properties();
    }

    @Override
    public DeferredObject<Item> registerItem(Supplier<Item> supplier, ResourceLocation identifier, @Nullable ResourceLocation creativeTab) {
        DeferredRegister register = DeferredRegisters.get(ForgeRegistries.ITEMS, identifier.m_135827_());
        RegistryObject registryObject = register.register(identifier.m_135815_(), supplier);
        if (creativeTab != null) {
            this.getActiveRegistrations().creativeTabContents.put((Object)creativeTab, () -> new ItemLike[]{(ItemLike)registryObject.get()});
        }
        return new DeferredObject<Item>(identifier, (Supplier<Item>)registryObject, () -> ((RegistryObject)registryObject).isPresent());
    }

    @Override
    public DeferredObject<CreativeModeTab> registerCreativeModeTab(ResourceLocation identifier, Supplier<ItemStack> iconSupplier) {
        MutableComponent displayName = Component.m_237115_((String)("itemGroup." + identifier.toString().replace(':', '.')));
        CreativeTabRegistration deferred = new CreativeTabRegistration(identifier, (Component)displayName, iconSupplier);
        this.getActiveRegistrations().creativeTabsToRegister.add(deferred);
        return deferred;
    }

    @Override
    public void addToCreativeModeTab(ResourceLocation tabIdentifier, Supplier<ItemLike[]> itemsSupplier) {
        this.getActiveRegistrations().creativeTabContents.put((Object)tabIdentifier, itemsSupplier);
    }

    public void register() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this.getActiveRegistrations());
    }

    private Registrations getActiveRegistrations() {
        return this.registrations.computeIfAbsent(ModLoadingContext.get().getActiveNamespace(), it -> new Registrations());
    }

    private static class Registrations {
        public final List<CreativeTabRegistration> creativeTabsToRegister = new ArrayList<CreativeTabRegistration>();
        public final Multimap<ResourceLocation, Supplier<ItemLike[]>> creativeTabContents = ArrayListMultimap.create();
        private final BiMap<ResourceLocation, CreativeModeTab> creativeTabsByIdentifier = HashBiMap.create();
        private final BiMap<CreativeModeTab, ResourceLocation> creativeTabIdentifiersByTab = this.creativeTabsByIdentifier.inverse();

        private Registrations() {
        }

        @SubscribeEvent
        public void registerCreativeTabs(CreativeModeTabEvent.Register event) {
            this.creativeTabsToRegister.forEach(it -> {
                it.resolve(event);
                this.creativeTabsByIdentifier.put((Object)it.getIdentifier(), (Object)((CreativeModeTab)it.get()));
            });
            this.creativeTabsByIdentifier.put((Object)new ResourceLocation("minecraft", "building_blocks"), (Object)CreativeModeTabs.f_256788_);
            this.creativeTabsByIdentifier.put((Object)new ResourceLocation("minecraft", "spawn_eggs"), (Object)CreativeModeTabs.f_256731_);
            this.creativeTabsByIdentifier.put((Object)new ResourceLocation("minecraft", "colored_blocks"), (Object)CreativeModeTabs.f_256725_);
            this.creativeTabsByIdentifier.put((Object)new ResourceLocation("minecraft", "combat"), (Object)CreativeModeTabs.f_256797_);
            this.creativeTabsByIdentifier.put((Object)new ResourceLocation("minecraft", "food_and_drinks"), (Object)CreativeModeTabs.f_256839_);
            this.creativeTabsByIdentifier.put((Object)new ResourceLocation("minecraft", "functional_blocks"), (Object)CreativeModeTabs.f_256791_);
            this.creativeTabsByIdentifier.put((Object)new ResourceLocation("minecraft", "ingredients"), (Object)CreativeModeTabs.f_256968_);
            this.creativeTabsByIdentifier.put((Object)new ResourceLocation("minecraft", "natural_blocks"), (Object)CreativeModeTabs.f_256776_);
            this.creativeTabsByIdentifier.put((Object)new ResourceLocation("minecraft", "redstone_blocks"), (Object)CreativeModeTabs.f_257028_);
            this.creativeTabsByIdentifier.put((Object)new ResourceLocation("minecraft", "op_blocks"), (Object)CreativeModeTabs.f_256837_);
            this.creativeTabsByIdentifier.put((Object)new ResourceLocation("minecraft", "tools_and_utilities"), (Object)CreativeModeTabs.f_256869_);
        }

        @SubscribeEvent
        public void buildCreativeTabContents(CreativeModeTabEvent.BuildContents event) {
            Collection itemStacks;
            ResourceLocation tabIdentifier = (ResourceLocation)this.creativeTabIdentifiersByTab.get((Object)event.getTab());
            if (tabIdentifier != null && !(itemStacks = this.creativeTabContents.get((Object)tabIdentifier)).isEmpty()) {
                itemStacks.forEach(it -> {
                    for (ItemLike itemStack : (ItemLike[])it.get()) {
                        event.m_246326_(itemStack);
                    }
                });
            }
        }
    }

    private static class CreativeTabRegistration
    extends DeferredObject<CreativeModeTab> {
        private final Component displayName;
        private final Supplier<ItemStack> iconSupplier;

        private CreativeTabRegistration(ResourceLocation identifier, Component displayName, Supplier<ItemStack> iconSupplier) {
            super(identifier);
            this.displayName = displayName;
            this.iconSupplier = iconSupplier;
        }

        public void resolve(CreativeModeTabEvent.Register event) {
            this.set(event.registerCreativeModeTab(this.getIdentifier(), builder -> builder.m_257941_(this.displayName).m_257737_(this.iconSupplier)));
        }
    }
}

