/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.buffer_builder.intrinsics;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultedVertexConsumer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.vertex.VanillaVertexTypes;
import me.jellysquid.mods.sodium.client.model.vertex.VertexDrain;
import me.jellysquid.mods.sodium.client.model.vertex.formats.quad.QuadVertexSink;
import me.jellysquid.mods.sodium.client.util.Norm3b;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.client.util.color.ColorU8;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={BufferBuilder.class})
public abstract class MixinBufferBuilder
extends DefaultedVertexConsumer {
    @Shadow
    private boolean f_85659_;

    public void m_85995_(PoseStack.Pose matrices, BakedQuad quad, float[] brightnessTable, float r, float g, float b, int[] light, int overlay, boolean colorize) {
        if (!this.f_85659_) {
            super.m_85995_(matrices, quad, brightnessTable, r, g, b, light, overlay, colorize);
            return;
        }
        if (this.f_85824_) {
            throw new IllegalStateException();
        }
        ModelQuadView quadView = (ModelQuadView)quad;
        Matrix4f positionMatrix = matrices.m_252922_();
        Matrix3f normalMatrix = matrices.m_252943_();
        int norm = this.computeNormal(normalMatrix, quad.m_111306_());
        QuadVertexSink drain = VertexDrain.of((VertexConsumer)this).createSink(VanillaVertexTypes.QUADS);
        drain.ensureCapacity(4);
        for (int i = 0; i < 4; ++i) {
            float fB;
            float fG;
            float fR;
            float x = quadView.getX(i);
            float y = quadView.getY(i);
            float z = quadView.getZ(i);
            float brightness = brightnessTable[i];
            if (colorize) {
                int color = quadView.getColor(i);
                float oR = ColorU8.normalize(ColorABGR.unpackRed(color));
                float oG = ColorU8.normalize(ColorABGR.unpackGreen(color));
                float oB = ColorU8.normalize(ColorABGR.unpackBlue(color));
                fR = oR * brightness * r;
                fG = oG * brightness * g;
                fB = oB * brightness * b;
            } else {
                fR = brightness * r;
                fG = brightness * g;
                fB = brightness * b;
            }
            float u = quadView.getTexU(i);
            float v = quadView.getTexV(i);
            int color = ColorABGR.pack(fR, fG, fB, 1.0f);
            Vector4f pos = new Vector4f(x, y, z, 1.0f);
            positionMatrix.transform(pos);
            drain.writeQuad(pos.x(), pos.y(), pos.z(), color, u, v, light[i], overlay, norm);
        }
        drain.flush();
    }

    private int computeNormal(Matrix3f normalMatrix, Direction face) {
        Vec3i faceNorm = face.m_122436_();
        float x = faceNorm.m_123341_();
        float y = faceNorm.m_123342_();
        float z = faceNorm.m_123343_();
        float x2 = normalMatrix.m00 * x + normalMatrix.m01 * y + normalMatrix.m02 * z;
        float y2 = normalMatrix.m10 * x + normalMatrix.m11 * y + normalMatrix.m12 * z;
        float z2 = normalMatrix.m20 * x + normalMatrix.m21 * y + normalMatrix.m22 * z;
        return Norm3b.pack(x2, y2, z2);
    }
}

