/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.entity.fast_render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import me.jellysquid.mods.sodium.client.model.ModelCuboidAccessor;
import me.jellysquid.mods.sodium.client.model.vertex.VanillaVertexTypes;
import me.jellysquid.mods.sodium.client.model.vertex.VertexDrain;
import me.jellysquid.mods.sodium.client.model.vertex.formats.quad.QuadVertexSink;
import me.jellysquid.mods.sodium.client.util.Norm3b;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import net.minecraft.client.model.geom.ModelPart;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ModelPart.class})
public class MixinModelPart {
    private static final float NORM = 0.0625f;
    @Shadow
    @Final
    private List<ModelPart.Cube> f_104212_;

    @Overwrite
    private void m_104290_(PoseStack.Pose matrices, VertexConsumer vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        QuadVertexSink drain = VertexDrain.of(vertexConsumer).createSink(VanillaVertexTypes.QUADS);
        drain.ensureCapacity(this.f_104212_.size() * 6 * 4);
        int color = ColorABGR.pack(red, green, blue, alpha);
        for (ModelPart.Cube cuboid : this.f_104212_) {
            for (ModelPart.Polygon quad : ((ModelCuboidAccessor)cuboid).getQuads()) {
                Matrix3f normal = matrices.m_252943_();
                float normX = Math.fma(normal.m00(), quad.f_104360_.x, Math.fma(normal.m10(), quad.f_104360_.y, normal.m20() * quad.f_104360_.z));
                float normY = Math.fma(normal.m01(), quad.f_104360_.x, Math.fma(normal.m11(), quad.f_104360_.y, normal.m21() * quad.f_104360_.z));
                float normZ = Math.fma(normal.m02(), quad.f_104360_.x, Math.fma(normal.m12(), quad.f_104360_.y, normal.m22() * quad.f_104360_.z));
                int norm = Norm3b.pack(normX, normY, normZ);
                for (ModelPart.Vertex vertex : quad.f_104359_) {
                    Vector3f pos = vertex.f_104371_;
                    float x1 = pos.x() * 0.0625f;
                    float y1 = pos.y() * 0.0625f;
                    float z1 = pos.z() * 0.0625f;
                    Matrix4f matrix = matrices.m_252922_();
                    float x2 = Math.fma(matrix.m00(), x1, Math.fma(matrix.m10(), y1, Math.fma(matrix.m20(), z1, matrix.m30())));
                    float y2 = Math.fma(matrix.m01(), x1, Math.fma(matrix.m11(), y1, Math.fma(matrix.m21(), z1, matrix.m31())));
                    float z2 = Math.fma(matrix.m02(), x1, Math.fma(matrix.m12(), y1, Math.fma(matrix.m22(), z1, matrix.m32())));
                    drain.writeQuad(x2, y2, z2, color, vertex.f_104372_, vertex.f_104373_, light, overlay, norm);
                }
            }
        }
        drain.flush();
    }
}

