/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.reeses_sodium_options.client.gui.frame;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import me.jellysquid.mods.sodium.client.gui.options.control.ControlElement;
import me.jellysquid.mods.sodium.client.gui.widgets.AbstractWidget;
import me.jellysquid.mods.sodium.client.util.Dim2i;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFrame
extends AbstractWidget
implements ContainerEventHandler {
    protected final Dim2i dim;
    protected final List<AbstractWidget> children = new ArrayList<AbstractWidget>();
    protected final List<Renderable> drawable = new ArrayList<Renderable>();
    protected final List<ControlElement<?>> controlElements = new ArrayList();
    protected boolean renderOutline;
    private GuiEventListener focused;
    private boolean dragging;

    public AbstractFrame(Dim2i dim, boolean renderOutline) {
        this.dim = dim;
        this.renderOutline = renderOutline;
    }

    public void buildFrame() {
        for (GuiEventListener guiEventListener : this.children) {
            if (guiEventListener instanceof AbstractFrame) {
                this.controlElements.addAll(((AbstractFrame)guiEventListener).controlElements);
            }
            if (guiEventListener instanceof ControlElement) {
                this.controlElements.add((ControlElement)guiEventListener);
            }
            if (!(guiEventListener instanceof Renderable)) continue;
            this.drawable.add((Renderable)guiEventListener);
        }
    }

    public void m_86412_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (this.renderOutline) {
            this.drawRectOutline(this.dim.x(), this.dim.y(), this.dim.getLimitX(), this.dim.getLimitY(), -5592406);
        }
        for (Renderable drawable : this.drawable) {
            drawable.m_86412_(matrices, mouseX, mouseY, delta);
        }
    }

    public void applyScissor(int x, int y, int width, int height, Runnable action) {
        double scale = Minecraft.m_91087_().m_91268_().m_85449_();
        RenderSystem.m_69488_((int)((int)((double)x * scale)), (int)((int)((double)Minecraft.m_91087_().m_91268_().m_85442_() - (double)(y + height) * scale)), (int)((int)((double)width * scale)), (int)((int)((double)height * scale)));
        action.run();
        RenderSystem.m_69471_();
    }

    protected void drawRectOutline(double x, double y, double w, double h, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        this.drawQuads(vertices -> {
            AbstractFrame.addQuad((VertexConsumer)vertices, (double)x, (double)y, (double)w, (double)(y + 1.0), (float)a, (float)r, (float)g, (float)b);
            AbstractFrame.addQuad((VertexConsumer)vertices, (double)x, (double)(h - 1.0), (double)w, (double)h, (float)a, (float)r, (float)g, (float)b);
            AbstractFrame.addQuad((VertexConsumer)vertices, (double)x, (double)y, (double)(x + 1.0), (double)h, (float)a, (float)r, (float)g, (float)b);
            AbstractFrame.addQuad((VertexConsumer)vertices, (double)(w - 1.0), (double)y, (double)w, (double)h, (float)a, (float)r, (float)g, (float)b);
        });
    }

    public boolean m_7282_() {
        return this.dragging;
    }

    public void m_7897_(boolean dragging) {
        this.dragging = dragging;
    }

    @Nullable
    public GuiEventListener m_7222_() {
        return this.focused;
    }

    public void m_7522_(@Nullable GuiEventListener focused) {
        this.focused = focused;
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.children;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.dim.containsCursor(mouseX, mouseY);
    }
}

