/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import com.google.common.collect.ImmutableSortedMap;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import journeymap.client.JourneymapClient;
import journeymap.client.api.event.forge.EntityRadarUpdateEvent;
import journeymap.client.data.DataCache;
import journeymap.client.event.dispatchers.CustomEventDispatcher;
import journeymap.client.log.JMLogger;
import journeymap.client.log.StatTimer;
import journeymap.client.mod.impl.Pixelmon;
import journeymap.client.model.EntityDTO;
import journeymap.client.render.RenderFacade;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.util.PlayerRadarManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.entity.CreeperRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.HorseRenderer;
import net.minecraft.client.renderer.entity.VillagerRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class EntityHelper {
    public static EntityDistanceComparator entityDistanceComparator = new EntityDistanceComparator();
    public static EntityDTODistanceComparator entityDTODistanceComparator = new EntityDTODistanceComparator();
    public static EntityMapComparator entityMapComparator = new EntityMapComparator();
    private static final String[] HORSE_TEXTURES = new String[]{"textures/entity/horse/horse_white.png", "textures/entity/horse/horse_creamy.png", "textures/entity/horse/horse_chestnut.png", "textures/entity/horse/horse_brown.png", "textures/entity/horse/horse_black.png", "textures/entity/horse/horse_gray.png", "textures/entity/horse/horse_darkbrown.png"};

    public static List<EntityDTO> getEntitiesNearby(String timerName, int maxEntities, boolean hostile, Class ... entityClasses) {
        StatTimer timer = StatTimer.get("EntityHelper." + timerName);
        timer.start();
        Minecraft mc = Minecraft.m_91087_();
        List<EntityDTO> list = new ArrayList<EntityDTO>();
        ArrayList allEntities = new ArrayList();
        mc.f_91073_.m_104735_().forEach(allEntities::add);
        AABB bb = EntityHelper.getBB((Player)mc.f_91074_);
        try {
            block2: for (Entity entity : allEntities) {
                if (!(entity instanceof LivingEntity) || !entity.m_6084_() || !bb.m_82381_(entity.m_20191_())) continue;
                for (Class entityClass : entityClasses) {
                    if (!entityClass.isAssignableFrom(entity.getClass()) || !EntityHelper.isSpecialCreature(entity, hostile)) continue;
                    LivingEntity entityLivingBase = (LivingEntity)entity;
                    EntityDTO dto = DataCache.INSTANCE.getEntityDTO(entityLivingBase);
                    dto.update(entityLivingBase, hostile);
                    if (!CustomEventDispatcher.getInstance().entityRadarUpdateEvent(EntityRadarUpdateEvent.EntityType.MOB, dto)) continue block2;
                    list.add(dto);
                    continue block2;
                }
            }
            if (list.size() > maxEntities) {
                int before2 = list.size();
                EntityHelper.entityDTODistanceComparator.player = mc.f_91074_;
                Collections.sort(list, entityDTODistanceComparator);
                list = list.subList(0, maxEntities);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().warn("Failed to " + timerName + ": " + LogFormatter.toString(t));
        }
        timer.stop();
        return list;
    }

    private static boolean isSpecialCreature(Entity entity, boolean hostile) {
        if (PathfinderMob.class.isAssignableFrom(entity.getClass())) {
            if (hostile && entity.m_6095_().m_20674_().equals((Object)MobCategory.MONSTER)) {
                return true;
            }
            return !hostile && entity.m_6095_().m_20674_().m_21609_();
        }
        return true;
    }

    public static List<EntityDTO> getMobsNearby() {
        return EntityHelper.getEntitiesNearby("getMobsNearby", JourneymapClient.getInstance().getCoreProperties().maxMobsData.get(), true, Enemy.class, PathfinderMob.class);
    }

    public static List<EntityDTO> getVillagersNearby() {
        return EntityHelper.getEntitiesNearby("getVillagersNearby", JourneymapClient.getInstance().getCoreProperties().maxVillagersData.get(), false, Villager.class, Npc.class);
    }

    public static List<EntityDTO> getAnimalsNearby() {
        return EntityHelper.getEntitiesNearby("getAnimalsNearby", JourneymapClient.getInstance().getCoreProperties().maxAnimalsData.get(), false, Animal.class, AbstractGolem.class, WaterAnimal.class, PathfinderMob.class);
    }

    public static boolean isPassive(LivingEntity entityLiving) {
        if (entityLiving == null) {
            return false;
        }
        if (entityLiving instanceof Enemy) {
            return false;
        }
        LivingEntity attackTarget = entityLiving.m_21232_();
        return attackTarget == null || !(attackTarget instanceof Player) && !(attackTarget instanceof TamableAnimal);
    }

    public static List<EntityDTO> getPlayersNearby() {
        StatTimer timer = StatTimer.get("EntityHelper.getPlayersNearby");
        timer.start();
        Minecraft mc = Minecraft.m_91087_();
        List<Player> allPlayers = new ArrayList();
        if (JourneymapClient.getInstance().getStateHandler().isExpandedRadarEnabled()) {
            if (mc.m_91403_().m_105142_() != null && mc.m_91403_().m_105142_().size() > 1) {
                for (PlayerInfo onlinePlayer : mc.m_91403_().m_105142_()) {
                    Player networkedPlayer;
                    if (onlinePlayer.m_105312_().getId().equals(mc.f_91074_.m_20148_()) || (networkedPlayer = PlayerRadarManager.getInstance().getPlayers().get(onlinePlayer.m_105312_().getId())) == null || networkedPlayer.f_19853_.m_46472_() != Minecraft.m_91087_().f_91074_.f_19853_.m_46472_()) continue;
                    allPlayers.add(networkedPlayer);
                }
            }
        } else {
            allPlayers.addAll(mc.f_91073_.m_6907_());
            allPlayers.remove(mc.f_91074_);
        }
        int max = JourneymapClient.getInstance().getCoreProperties().maxPlayersData.get();
        if (allPlayers.size() > max) {
            EntityHelper.entityDistanceComparator.player = mc.f_91074_;
            Collections.sort(allPlayers, entityDistanceComparator);
            allPlayers = allPlayers.subList(0, max);
        }
        ArrayList<EntityDTO> playerDTOs = new ArrayList<EntityDTO>(allPlayers.size());
        for (Player player : allPlayers) {
            EntityDTO dto = DataCache.INSTANCE.getEntityDTO((LivingEntity)player);
            dto.update((LivingEntity)player, false);
            if (!CustomEventDispatcher.getInstance().entityRadarUpdateEvent(EntityRadarUpdateEvent.EntityType.PLAYER, dto)) continue;
            playerDTOs.add(dto);
        }
        timer.stop();
        return playerDTOs;
    }

    private static AABB getBB(Player player) {
        int lateralDistance = JourneymapClient.getInstance().getCoreProperties().radarLateralDistance.get();
        int verticalDistance = JourneymapClient.getInstance().getCoreProperties().radarVerticalDistance.get();
        return EntityHelper.getBoundingBox(player, lateralDistance, verticalDistance);
    }

    public static AABB getBoundingBox(Player player, double lateralDistance, double verticalDistance) {
        return player.m_20191_().m_82377_(lateralDistance, verticalDistance, lateralDistance);
    }

    public static Map<String, EntityDTO> buildEntityIdMap(List<? extends EntityDTO> list, boolean sort) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyMap();
        }
        if (sort) {
            Collections.sort(list, new EntityMapComparator());
        }
        LinkedHashMap<CallSite, EntityDTO> idMap = new LinkedHashMap<CallSite, EntityDTO>(list.size());
        for (EntityDTO entityDTO : list) {
            idMap.put((CallSite)((Object)("id" + entityDTO.entityId)), entityDTO);
        }
        return ImmutableSortedMap.copyOf(idMap);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResourceLocation getIconTextureLocation(Entity entity) {
        try {
            EntityRenderer entityRender = Minecraft.m_91087_().m_91290_().m_114382_(entity);
            ResourceLocation original = null;
            if (entityRender instanceof CreeperRenderer) {
                Creeper creeper = (Creeper)entity;
                original = entityRender.m_5478_((Entity)creeper);
                if (creeper.m_7090_()) {
                    String path = original.m_135815_().replace("creeper.png", "creeper_armor.png");
                    original = new ResourceLocation(original.m_135827_(), path);
                }
            } else if (entityRender instanceof VillagerRenderer) {
                Villager villager = (Villager)entity;
                original = entityRender.m_5478_((Entity)villager);
                String profession = BuiltInRegistries.f_256735_.m_7981_((Object)villager.m_7141_().m_35571_()).m_135815_();
                if (profession.contains(":")) {
                    String namespace = profession.split(":")[0];
                    String path = profession.split(":")[1];
                    String poiJobPath = original.m_135815_().replace("villager.png", path + ".png");
                    original = new ResourceLocation(namespace, poiJobPath);
                } else if ("minecraft".equals(original.m_135827_()) && !"unemployed".equals(profession) && !"none".equals(profession)) {
                    String path = original.m_135815_().replace("villager.png", profession + ".png");
                    original = new ResourceLocation(original.m_135827_(), path);
                }
            } else if (entityRender instanceof HorseRenderer) {
                Horse horse = (Horse)entity;
                original = entityRender.m_5478_((Entity)horse);
            } else if (Pixelmon.loaded) {
                original = Pixelmon.INSTANCE.getPixelmonResource(entity);
                if (original != null) return original;
                original = RenderFacade.getEntityTexture(entityRender, entity);
            } else {
                original = RenderFacade.getEntityTexture(entityRender, entity);
            }
            if (original == null) {
                JMLogger.logOnce("Can't get entityTexture for " + entity.getClass() + " via " + entityRender.getClass());
                return null;
            }
            if (!original.m_135815_().contains("/entity/")) {
                JMLogger.logOnce(original + " doesn't have /entity/ in path, so can't look for /entity_icon/");
                return null;
            }
            ResourceLocation entityIconLoc = original.m_135815_().contains("/model/entity/") ? new ResourceLocation(original.m_135827_(), original.m_135815_().replace("/model/entity/", "/entity_icon/")) : (original.m_135815_().contains("/model/") && !original.m_135815_().contains("/entity/") ? new ResourceLocation(original.m_135827_(), original.m_135815_().replace("/model/", "/entity_icon/")) : new ResourceLocation(original.m_135827_(), original.m_135815_().replace("/entity/", "/entity_icon/")));
            if (!Minecraft.m_91087_().m_91098_().m_213713_(entityIconLoc).isEmpty()) return entityIconLoc;
            JMLogger.logOnce("Can't get entityTexture for " + entityIconLoc);
            return null;
        }
        catch (Throwable t) {
            JMLogger.throwLogOnce("Can't get entityTexture for " + entity.m_7755_(), t);
            return null;
        }
    }

    private static class EntityDTODistanceComparator
    implements Comparator<EntityDTO> {
        Player player;

        private EntityDTODistanceComparator() {
        }

        @Override
        public int compare(EntityDTO o1, EntityDTO o2) {
            LivingEntity e1 = (LivingEntity)o1.entityLivingRef.get();
            LivingEntity e2 = (LivingEntity)o2.entityLivingRef.get();
            if (e1 == null || e2 == null) {
                return 0;
            }
            return Double.compare(e1.m_20280_((Entity)this.player), e2.m_20280_((Entity)this.player));
        }
    }

    private static class EntityDistanceComparator
    implements Comparator<Entity> {
        Player player;

        private EntityDistanceComparator() {
        }

        @Override
        public int compare(Entity o1, Entity o2) {
            return Double.compare(o1.m_20280_((Entity)this.player), o2.m_20280_((Entity)this.player));
        }
    }

    private static class EntityMapComparator
    implements Comparator<EntityDTO> {
        private EntityMapComparator() {
        }

        @Override
        public int compare(EntityDTO o1, EntityDTO o2) {
            Integer n;
            Integer o1rank = 0;
            Integer o2rank = 0;
            if (o1.getCustomName() != null) {
                n = o1rank;
                o1rank = o1rank + 1;
            } else if (o1.username != null) {
                o1rank = o1rank + 2;
            }
            if (o2.getCustomName() != null) {
                n = o2rank;
                o2rank = o2rank + 1;
            } else if (o2.username != null) {
                o2rank = o2rank + 2;
            }
            return o1rank.compareTo(o2rank);
        }
    }
}

