/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.fullscreen.menu;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import journeymap.client.api.display.ModPopupMenu;
import journeymap.client.api.impl.ModPopupMenuImpl;
import journeymap.client.event.dispatchers.CustomEventDispatcher;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.GuiHooks;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.DropDownItem;
import journeymap.client.ui.component.Removable;
import journeymap.client.ui.component.ScrollPaneScreen;
import journeymap.client.ui.component.SelectableParent;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.waypoint.Waypoint;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;

public class PopupMenu
extends ScrollPaneScreen
implements Removable,
SelectableParent {
    private static final int MAX_DISPLAY_SIZE = 6;
    private int mouseX;
    private int mouseY;
    private final Screen parent;
    private DropDownItem selected;
    private boolean pass = false;
    private boolean isSub = false;
    private boolean mouseOver = false;

    public PopupMenu(Fullscreen parent) {
        this((Screen)parent);
    }

    public PopupMenu(PopupMenu parent) {
        this((Screen)parent);
        this.isSub = true;
    }

    private PopupMenu(Screen parent) {
        super(null, null, 0, 0, 0, 0);
        this.parent = parent;
        this.setParent(this);
    }

    public void displayBasicOptions(BlockPos blockPos) {
        ModPopupMenuImpl menu = new ModPopupMenuImpl(((Fullscreen)this.parent).popupMenu);
        if (CustomEventDispatcher.getInstance().popupMenuEvent((Fullscreen)this.parent, menu)) {
            this.displayOptions(blockPos, menu);
        }
    }

    public void displayWaypointOptions(BlockPos blockPos, Waypoint wp) {
        ModPopupMenuImpl menu = new ModPopupMenuImpl(((Fullscreen)this.parent).popupMenu);
        if (CustomEventDispatcher.getInstance().popupWaypointMenuEvent((Fullscreen)this.parent, menu, wp)) {
            this.displayOptions(blockPos, menu);
        }
    }

    public void displayOptions(BlockPos blockPos, ModPopupMenu popupMenu) {
        ModPopupMenuImpl menu = (ModPopupMenuImpl)popupMenu;
        if (menu.getMenuItemList() != null && !menu.getMenuItemList().isEmpty()) {
            ArrayList<DropDownItem> items = new ArrayList<DropDownItem>();
            menu.getMenuItemList().forEach(menuItem -> items.add(this.dropDownItemBuilder((ModPopupMenuImpl.MenuItem)menuItem, menu, blockPos)));
            this.display(items);
        }
    }

    private DropDownItem dropDownItemBuilder(ModPopupMenuImpl.MenuItem menuItem, ModPopupMenuImpl menu, BlockPos blockPos) {
        DropDownItem dropDownItem;
        if (menuItem.isAutoCloseable()) {
            dropDownItem = new DropDownItem((SelectableParent)this, (Object)menuItem, menuItem.isAutoCloseable(), menuItem.getLabel(), b -> {
                if (menu.isSub()) {
                    this.closeStack();
                }
                menuItem.getAction().doAction(blockPos);
            });
        } else {
            dropDownItem = new DropDownItem((SelectableParent)this, (Object)menuItem, menuItem.isAutoCloseable(), menuItem.getLabel(), b -> menuItem.getSubMenuAction().doAction(blockPos, (Button)b));
            dropDownItem.setOnHover((button, isHovered) -> menuItem.getSubMenuAction().onHoverState(blockPos, button, isHovered));
        }
        return dropDownItem;
    }

    private void display(List<DropDownItem> items) {
        if (!this.pass) {
            for (DropDownItem item : items) {
                item.setHorizontalAlignment(DrawUtil.HAlign.Right);
            }
            this.pass = true;
            this.setRenderDecorations(false);
            this.setRenderSolidBackground(true);
            this.setItems(items);
            this.setPaneWidth(this.getPaneWidth(items));
            this.setPaneHeight(this.getPaneHeight(items));
            this.setPointsInScreenBounds();
            super.display();
        }
    }

    private void setPointsInScreenBounds() {
        int x;
        boolean inBoundsY;
        int screenWidth = Minecraft.m_91087_().m_91268_().m_85445_();
        int screenHeight = Minecraft.m_91087_().m_91268_().m_85446_();
        boolean inBoundsX = this.mouseX + this.getPaneWidth() < screenWidth;
        boolean bl = inBoundsY = this.mouseY + this.getPaneHeight() < screenHeight;
        if (this.parent instanceof PopupMenu) {
            int width = this.scrollPane != null ? this.getPaneWidth() : this.getPaneWidth() - 6;
            x = inBoundsX ? this.mouseX : ((PopupMenu)this.parent).getPaneX() - width;
        } else {
            x = inBoundsX ? this.mouseX : screenWidth - this.getPaneWidth() - 4;
        }
        int y = inBoundsY ? this.mouseY : screenHeight - this.getPaneHeight() - 2;
        this.mouseX = x;
        this.mouseY = y;
        this.setPaneX(x);
        this.setPaneY(y);
    }

    public void resetPass() {
        this.pass = false;
    }

    @Override
    public void m_86412_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.mouseOver = this.mouseOverPane(mouseX, mouseY);
        int x = (int)(Minecraft.m_91087_().f_91067_.m_91589_() * (double)Minecraft.m_91087_().m_91268_().m_85445_() / (double)Minecraft.m_91087_().m_91268_().m_85443_());
        int y = (int)(Minecraft.m_91087_().f_91067_.m_91594_() * (double)Minecraft.m_91087_().m_91268_().m_85446_() / (double)Minecraft.m_91087_().m_91268_().m_85444_());
        super.m_86412_(poseStack, x, y, partialTicks);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean clicked = super.m_6375_(mouseX, mouseY, button);
        if (!clicked && !this.mouseOverPane(mouseX, mouseY)) {
            this.resetPass();
            return this.parent.m_6375_(mouseX, mouseY, button);
        }
        return clicked;
    }

    public boolean isMouseOver() {
        return this.mouseOver;
    }

    @Override
    public void m_94757_(double mouseX, double mouseY) {
        if (!this.mouseOverPane(mouseX, mouseY)) {
            this.parent.m_94757_(mouseX, mouseY);
        }
        super.m_94757_(mouseX, mouseY);
    }

    private int getPaneHeight(List<DropDownItem> items) {
        int size = Math.min(items.size(), 6);
        return size * (items.get(0).m_93694_() + (size == 1 ? 7 : 5));
    }

    private int getPaneWidth(List<DropDownItem> items) {
        int width = 0;
        if (items != null) {
            Font fontRenderer = Minecraft.m_91087_().f_91062_;
            for (DropDownItem item : items) {
                width = Math.max(width, fontRenderer.m_92895_(item.getLabel()));
            }
            this.f_96543_ = width + 40;
        }
        return this.f_96543_;
    }

    public void setClickLoc(int mouseX, int mouseY) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
    }

    @Override
    public void setSelected(DropDownItem button) {
        this.selected = button;
    }

    public void closeStack() {
        if (this.isSub) {
            ((PopupMenu)this.parent).closeStack();
            this.m_7379_();
        }
    }

    @Override
    public void onClick(DropDownItem pressed) {
        if (pressed.isAutoClose()) {
            this.m_7379_();
        }
        ((ScrollPaneScreen)this).parent.onRemove();
    }

    @Override
    public void m_7379_() {
        this.visible = false;
        GuiHooks.popGuiLayer();
    }

    @Override
    public void onRemove() {
        if (this.selected != null) {
            this.selected.press();
            this.selected = null;
        }
    }
}

