/*
 * Decompiled with CFR 0.152.
 */
package net.londonunderground;

import mtr.CreativeModeTabs;
import mtr.Registry;
import mtr.RegistryObject;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.DeferredRegisterHolder;
import mtr.mappings.RegistryUtilities;
import net.londonunderground.Main;
import net.londonunderground.MainClient;
import net.londonunderground.PanelCommand;
import net.londonunderground.mappings.ForgeUtilities;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="londonunderground")
public class MainForge {
    private static final DeferredRegisterHolder<Item> ITEMS = new DeferredRegisterHolder("londonunderground", ForgeUtilities.registryGetItem());
    private static final DeferredRegisterHolder<Block> BLOCKS = new DeferredRegisterHolder("londonunderground", ForgeUtilities.registryGetBlock());
    private static final DeferredRegisterHolder<BlockEntityType<?>> BLOCK_ENTITY_TYPES = new DeferredRegisterHolder("londonunderground", ForgeUtilities.registryGetBlockEntityType());
    private static final DeferredRegisterHolder<SoundEvent> SOUND_EVENTS = new DeferredRegisterHolder("londonunderground", ForgeUtilities.registryGetSoundEvent());

    public MainForge() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ForgeUtilities.registerModEventBus("londonunderground", eventBus);
        ITEMS.register();
        BLOCKS.register();
        BLOCK_ENTITY_TYPES.register();
        SOUND_EVENTS.register();
        eventBus.register(MTRForgeRegistry.class);
        RegistryUtilities.registerCommand(PanelCommand::register);
    }

    private static void registerBlock(String path, RegistryObject<Block> block) {
        BLOCKS.register(path, () -> block.get());
    }

    private static void registerBlock(String path, RegistryObject<Block> block, CreativeModeTabs.Wrapper creativeModeTabWrapper) {
        MainForge.registerBlock(path, block);
        ITEMS.register(path, () -> {
            BlockItem blockItem = new BlockItem((Block)block.get(), RegistryUtilities.createItemProperties(() -> ((CreativeModeTabs.Wrapper)creativeModeTabWrapper).get()));
            Registry.registerCreativeModeTab((ResourceLocation)creativeModeTabWrapper.resourceLocation, (Item)blockItem);
            return blockItem;
        });
    }

    private static void registerBlockEntityType(String path, RegistryObject<? extends BlockEntityType<? extends BlockEntityMapper>> blockEntityType) {
        BLOCK_ENTITY_TYPES.register(path, () -> blockEntityType.get());
    }

    private static void registerSoundEvent(String path, SoundEvent soundEvent) {
        SOUND_EVENTS.register(path, () -> soundEvent);
    }

    static {
        Main.init(MainForge::registerBlock, MainForge::registerBlockEntityType, MainForge::registerSoundEvent);
    }

    private static class MTRForgeRegistry {
        private MTRForgeRegistry() {
        }

        @SubscribeEvent
        public static void onClientSetupEvent(FMLClientSetupEvent event) {
            MainClient.init();
        }
    }
}

