/*
 * Decompiled with CFR 0.152.
 */
package net.londonunderground.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mtr.MTRClient;
import mtr.block.BlockArrivalProjectorBase;
import mtr.block.BlockPIDSBase;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.client.Config;
import mtr.data.DataCache;
import mtr.data.IGui;
import mtr.data.PIDSType;
import mtr.data.RailwayData;
import mtr.data.Route;
import mtr.data.ScheduleEntry;
import mtr.data.Station;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.render.RenderTrains;
import net.londonunderground.data.IGui2;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class RenderPIDS<T extends BlockEntityMapper>
extends BlockEntityRendererMapper<T>
implements IGui,
IGui2 {
    private final float scale;
    private final float totalScaledWidth;
    private final float destinationStart;
    private final float destinationMaxWidth;
    private final float platformMaxWidth;
    private final float arrivalMaxWidth;
    private final int maxArrivals;
    private final float maxHeight;
    private final float startX;
    private final float startY;
    private final float startZ;
    private final boolean rotate90;
    private final boolean renderArrivalNumber;
    private final int textColor;
    private final int firstTrainColor;
    private final boolean appendDotAfterMin;
    private static final int SWITCH_LANGUAGE_TICKS = 60;
    private static final int CAR_TEXT_COLOR = 0xFF0000;
    private static final int MAX_VIEW_DISTANCE = 64;

    public RenderPIDS(BlockEntityRenderDispatcher dispatcher, int maxArrivals, float startX, float startY, float startZ, float maxHeight, int maxWidth, boolean rotate90, boolean renderArrivalNumber, int textColor, int firstTrainColor, float textPadding, boolean appendDotAfterMin) {
        super(dispatcher);
        this.scale = (float)(160 * maxArrivals) / maxHeight * textPadding;
        this.totalScaledWidth = this.scale * (float)maxWidth / 16.0f;
        this.destinationStart = renderArrivalNumber ? this.scale * 2.0f / 16.0f : 0.0f;
        this.destinationMaxWidth = this.totalScaledWidth * 0.7f;
        this.platformMaxWidth = 0.0f;
        this.arrivalMaxWidth = this.totalScaledWidth - this.destinationStart - this.destinationMaxWidth - this.platformMaxWidth;
        this.maxArrivals = maxArrivals;
        this.maxHeight = maxHeight;
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
        this.rotate90 = rotate90;
        this.renderArrivalNumber = renderArrivalNumber;
        this.textColor = textColor;
        this.firstTrainColor = firstTrainColor;
        this.appendDotAfterMin = appendDotAfterMin;
    }

    public RenderPIDS(BlockEntityRenderDispatcher dispatcher, int maxArrivals, float startX, float startY, float startZ, float maxHeight, int maxWidth, boolean rotate90, boolean renderArrivalNumber, int textColor, int firstTrainColor) {
        this(dispatcher, maxArrivals, startX, startY, startZ, maxHeight, maxWidth, rotate90, renderArrivalNumber, textColor, firstTrainColor, 1.0f, false);
    }

    public void render(T entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        Style style = Config.useMTRFont() ? Style.f_131099_.m_131150_(new ResourceLocation("londonunderground", "londonunderground")) : Style.f_131099_;
        Level world = entity.m_58904_();
        if (world == null) {
            return;
        }
        BlockPos pos = entity.m_58899_();
        Direction facing = (Direction)IBlock.getStatePropertySafe((BlockGetter)world, (BlockPos)pos, (Property)HorizontalDirectionalBlock.f_54117_);
        if (RenderTrains.shouldNotRender((BlockPos)pos, (int)Math.min(64, RenderTrains.maxTrainRenderDistance), (Direction)(this.rotate90 ? null : facing))) {
            return;
        }
        String[] customMessages = new String[this.maxArrivals];
        boolean[] hideArrival = new boolean[this.maxArrivals];
        for (int i = 0; i < this.maxArrivals; ++i) {
            if (entity instanceof BlockPIDSBase.TileEntityBlockPIDSBase) {
                customMessages[i] = ((BlockPIDSBase.TileEntityBlockPIDSBase)entity).getMessage(i);
                hideArrival[i] = ((BlockPIDSBase.TileEntityBlockPIDSBase)entity).getHideArrival(i);
                continue;
            }
            customMessages[i] = "";
        }
        try {
            HashMap platformIdToName = new HashMap();
            Station station = RailwayData.getStation((Set)ClientData.STATIONS, (DataCache)ClientData.DATA_CACHE, (BlockPos)pos);
            if (station == null) {
                return;
            }
            Map platforms = ClientData.DATA_CACHE.requestStationIdToPlatforms(station.id);
            if (platforms.isEmpty()) {
                return;
            }
            PIDSType renderType = PIDSType.PIDS;
            Set platformIds = switch (renderType) {
                case PIDSType.ARRIVAL_PROJECTOR -> {
                    if (entity instanceof BlockArrivalProjectorBase.TileEntityArrivalProjectorBase) {
                        yield ((BlockArrivalProjectorBase.TileEntityArrivalProjectorBase)entity).getPlatformIds();
                    }
                    yield new HashSet();
                }
                case PIDSType.PIDS -> {
                    HashSet tempPlatformIds = entity instanceof BlockPIDSBase.TileEntityBlockPIDSBase ? ((BlockPIDSBase.TileEntityBlockPIDSBase)entity).getPlatformIds() : new HashSet();
                    yield tempPlatformIds.isEmpty() ? Collections.singleton(entity instanceof BlockPIDSBase.TileEntityBlockPIDSBase ? ((BlockPIDSBase.TileEntityBlockPIDSBase)entity).getPlatformId(ClientData.PLATFORMS, (DataCache)ClientData.DATA_CACHE) : 0L) : tempPlatformIds;
                }
                default -> new HashSet();
            };
            HashSet schedules = new HashSet();
            platforms.values().forEach(platform -> {
                Set scheduleForPlatform;
                if ((platformIds.isEmpty() || platformIds.contains(platform.id)) && (scheduleForPlatform = (Set)ClientData.SCHEDULES_FOR_PLATFORM.get(platform.id)) != null) {
                    scheduleForPlatform.forEach(scheduleEntry -> {
                        Route route = (Route)ClientData.DATA_CACHE.routeIdMap.get(scheduleEntry.routeId);
                        if (route != null && (renderType.showTerminatingPlatforms || scheduleEntry.currentStationIndex < route.platformIds.size() - 1)) {
                            schedules.add(scheduleEntry);
                            platformIdToName.put(platform.id, platform.name);
                        }
                    });
                }
            });
            ArrayList scheduleList = new ArrayList(schedules);
            Collections.sort(scheduleList);
            int maxCars = 0;
            int minCars = Integer.MAX_VALUE;
            for (ScheduleEntry scheduleEntry : scheduleList) {
                int trainCars = scheduleEntry.trainCars;
                if (trainCars > maxCars) {
                    maxCars = trainCars;
                }
                if (trainCars >= minCars) continue;
                minCars = trainCars;
            }
            boolean showCarLength = minCars != maxCars;
            float carLengthMaxWidth = showCarLength ? this.scale * 6.0f / 16.0f : 0.0f;
            for (int i = 0; i < this.maxArrivals; ++i) {
                boolean useCustomMessage;
                Object destinationString;
                Route route;
                int languageTicks = (int)Math.floor(MTRClient.getGameTick()) / 60;
                ScheduleEntry currentSchedule = i < scheduleList.size() ? (ScheduleEntry)scheduleList.get(i) : null;
                Route route2 = route = currentSchedule == null ? null : (Route)ClientData.DATA_CACHE.routeIdMap.get(currentSchedule.routeId);
                if (i < scheduleList.size() && !hideArrival[i] && route != null) {
                    destinationSplit = ClientData.DATA_CACHE.getFormattedRouteDestination(route, currentSchedule.currentStationIndex, "").split("\\|");
                    boolean isLightRailRoute = route.isLightRailRoute;
                    String[] routeNumberSplit = route.lightRailRouteNumber.split("\\|");
                    if (customMessages[i].isEmpty()) {
                        destinationString = (String)(isLightRailRoute ? routeNumberSplit[languageTicks % routeNumberSplit.length] + " " : "") + IGui.textOrUntitled((String)destinationSplit[languageTicks % destinationSplit.length]);
                        useCustomMessage = false;
                    } else {
                        String[] customMessageSplit = customMessages[i].split("\\|");
                        int destinationMaxIndex = Math.max(routeNumberSplit.length, destinationSplit.length);
                        int indexToUse = languageTicks % (destinationMaxIndex + customMessageSplit.length);
                        if (indexToUse < destinationMaxIndex) {
                            destinationString = (String)(isLightRailRoute ? routeNumberSplit[languageTicks % routeNumberSplit.length] + " " : "") + IGui.textOrUntitled((String)destinationSplit[languageTicks % destinationSplit.length]);
                            useCustomMessage = false;
                        } else {
                            destinationString = customMessageSplit[indexToUse - destinationMaxIndex];
                            useCustomMessage = true;
                        }
                    }
                } else {
                    destinationSplit = customMessages[i].split("\\|");
                    destinationString = destinationSplit[languageTicks % destinationSplit.length];
                    useCustomMessage = true;
                }
                matrices.m_85836_();
                matrices.m_85837_(0.5, 0.0, 0.5);
                UtilitiesClient.rotateYDegrees((PoseStack)matrices, (float)((float)(this.rotate90 ? 90 : 0) - facing.m_122435_()));
                UtilitiesClient.rotateZDegrees((PoseStack)matrices, (float)180.0f);
                matrices.m_252880_((this.startX - 8.0f) / 16.0f, -this.startY / 16.0f + (float)i * this.maxHeight / (float)this.maxArrivals / 16.0f, (this.startZ - 8.0f) / 16.0f - 0.00625f);
                matrices.m_85841_(1.0f / this.scale, 1.0f / this.scale, 1.0f / this.scale);
                Font textRenderer = Minecraft.m_91087_().f_91062_;
                if (useCustomMessage) {
                    FormattedCharSequence text4 = Text.literal((String)destinationString).m_6270_(style).m_7532_();
                    int destinationWidth = textRenderer.m_92724_(text4);
                    if ((float)destinationWidth > this.totalScaledWidth) {
                        matrices.m_85841_(this.totalScaledWidth / (float)destinationWidth, 1.0f, 1.0f);
                    }
                    textRenderer.m_92877_(matrices, text4, 0.0f, 0.0f, this.textColor);
                } else {
                    int seconds = (int)((currentSchedule.arrivalMillis - System.currentTimeMillis()) / 1000L);
                    boolean isCJK = IGui.isCjk((String)destinationString);
                    MutableComponent arrivalText = seconds >= 60 ? Text.translatable((String)(isCJK ? "gui.mtr.arrival_min_cjk" : "gui.mtr.arrival_min"), (Object[])new Object[]{seconds / 60}).m_130946_(this.appendDotAfterMin && !isCJK ? "." : "") : (seconds > 0 ? Text.translatable((String)(isCJK ? "gui.mtr.arrival_sec_cjk" : "gui.londonunderground.arrival_sec"), (Object[])new Object[]{seconds}).m_130946_(this.appendDotAfterMin && !isCJK ? "." : "") : null);
                    MutableComponent carText = Text.translatable((String)(isCJK ? "gui.mtr.arrival_car_cjk" : "gui.mtr.arrival_car"), (Object[])new Object[]{currentSchedule.trainCars});
                    if (this.renderArrivalNumber) {
                        FormattedCharSequence text1 = Text.literal((String)String.valueOf(i + 1)).m_6270_(style).m_7532_();
                        textRenderer.m_92877_(matrices, text1, 0.0f, 0.0f, seconds > 0 ? this.textColor : this.firstTrainColor);
                    }
                    float newDestinationMaxWidth = this.destinationMaxWidth - carLengthMaxWidth;
                    if (showCarLength) {
                        FormattedCharSequence text3 = Text.literal((String)carText.getString()).m_6270_(style).m_7532_();
                        matrices.m_85836_();
                        matrices.m_252880_(this.destinationStart + newDestinationMaxWidth + this.platformMaxWidth, 0.0f, 0.0f);
                        int carTextWidth = textRenderer.m_92724_(text3);
                        if ((float)carTextWidth > carLengthMaxWidth) {
                            matrices.m_85841_(carLengthMaxWidth / (float)carTextWidth, 1.0f, 1.0f);
                        }
                        textRenderer.m_92877_(matrices, text3, 0.0f, 0.0f, 0xFF0000);
                        matrices.m_85849_();
                    }
                    Object destinationString2 = currentSchedule.currentStationIndex == route.platformIds.size() - 1 ? (isCJK ? "\u7d42\u6b62\u670d\u52d9" : "Terminating Here") : destinationString;
                    FormattedCharSequence text4 = Text.literal((String)destinationString2).m_6270_(style).m_7532_();
                    matrices.m_85836_();
                    matrices.m_252880_(this.destinationStart, 0.0f, 0.0f);
                    int destinationWidth = textRenderer.m_92724_(text4);
                    if ((float)destinationWidth > newDestinationMaxWidth) {
                        matrices.m_85841_(newDestinationMaxWidth / (float)destinationWidth, 1.0f, 1.0f);
                    }
                    textRenderer.m_92877_(matrices, text4, 0.0f, 0.0f, seconds > 0 ? this.textColor : this.firstTrainColor);
                    matrices.m_85849_();
                    if (arrivalText != null) {
                        FormattedCharSequence text5 = Text.literal((String)arrivalText.getString()).m_6270_(style).m_7532_();
                        matrices.m_85836_();
                        int arrivalWidth = textRenderer.m_92724_(text5);
                        if ((float)arrivalWidth > this.arrivalMaxWidth) {
                            matrices.m_252880_(this.destinationStart + newDestinationMaxWidth + this.platformMaxWidth + carLengthMaxWidth, 0.0f, 0.0f);
                            matrices.m_85841_(this.arrivalMaxWidth / (float)arrivalWidth, 1.0f, 1.0f);
                        } else {
                            matrices.m_252880_(this.totalScaledWidth - (float)arrivalWidth, 0.0f, 0.0f);
                        }
                        textRenderer.m_92877_(matrices, text5, 0.0f, 0.0f, this.textColor);
                        matrices.m_85849_();
                    }
                }
                matrices.m_85849_();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

