/*
 * Decompiled with CFR 0.152.
 */
package net.londonunderground.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.Locale;
import java.util.Set;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.client.Config;
import mtr.client.IDrawing;
import mtr.data.DataCache;
import mtr.data.IGui;
import mtr.data.RailwayData;
import mtr.data.Station;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import net.londonunderground.blocks.BlockRoundelBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RenderRoundel<T extends BlockRoundelBase.TileEntityBlockRoundelBase>
extends BlockEntityRendererMapper<T>
implements IGui,
IDrawing {
    private final float maxWidth;
    private final float maxScale;
    private final float xOffset;
    private final float yOffset;
    private final float zOffset;
    private final float xTilt;
    private final int textColor;
    private final boolean isDoubleSided;
    private static Style STYLE;
    private final String font;

    public RenderRoundel(BlockEntityRenderDispatcher dispatcher, float maxWidth, float maxScale, float xOffset, float yOffset, float zOffset, float xTilt, int textColor, boolean isDoubleSided, String font) {
        super(dispatcher);
        this.maxWidth = maxWidth;
        this.maxScale = maxScale;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
        this.xTilt = xTilt;
        this.textColor = textColor;
        this.isDoubleSided = isDoubleSided;
        this.font = font;
    }

    public void render(T entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        STYLE = Config.useMTRFont() ? Style.f_131099_.m_131150_(new ResourceLocation("londonunderground", this.font)) : Style.f_131099_;
        if (!((BlockRoundelBase.TileEntityBlockRoundelBase)((Object)entity)).shouldRender()) {
            return;
        }
        Level world = entity.m_58904_();
        if (world == null) {
            return;
        }
        BlockPos pos = entity.m_58899_();
        BlockState state = world.m_8055_(pos);
        Direction facing = (Direction)IBlock.getStatePropertySafe((BlockState)state, (Property)BlockRoundelBase.f_54117_);
        int color = switch ((Integer)IBlock.getStatePropertySafe((BlockState)state, (Property)BlockRoundelBase.COLOR)) {
            case 1 -> -5592406;
            case 2 -> -16777216;
            default -> -1;
        };
        Station station = RailwayData.getStation((Set)ClientData.STATIONS, (DataCache)ClientData.DATA_CACHE, (BlockPos)pos);
        FormattedCharSequence roundelText = Text.literal((String)IGui.textOrUntitled((String)IGui.formatStationName((String)(station == null ? "" : station.name))).toUpperCase(Locale.ROOT)).m_6270_(STYLE).m_7532_();
        int textWidth = Minecraft.m_91087_().f_91062_.m_92724_(roundelText);
        matrices.m_85836_();
        matrices.m_85837_(0.5, 0.5, 0.5);
        UtilitiesClient.rotateYDegrees((PoseStack)matrices, (float)(-facing.m_122435_()));
        UtilitiesClient.rotateZDegrees((PoseStack)matrices, (float)180.0f);
        MultiBufferSource.BufferSource immediate = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        this.render(matrices, immediate, roundelText, textWidth, color, light);
        if (this.isDoubleSided) {
            UtilitiesClient.rotateYDegrees((PoseStack)matrices, (float)180.0f);
            this.render(matrices, immediate, roundelText, textWidth, color, light);
        }
        immediate.m_109911_();
        matrices.m_85849_();
    }

    private void render(PoseStack matrices, MultiBufferSource.BufferSource immediate, FormattedCharSequence roundelText, int textWidth, int color, int light) {
        matrices.m_85836_();
        UtilitiesClient.rotateXDegrees((PoseStack)matrices, (float)this.xTilt);
        matrices.m_252880_(-this.xOffset, -this.yOffset, -this.zOffset - 0.00625f);
        float scale = Math.min(this.maxWidth / (float)textWidth, this.maxScale);
        matrices.m_85841_(scale, scale, scale);
        matrices.m_85837_(0.0, -3.5, 0.0);
        Minecraft.m_91087_().f_91062_.m_252916_(roundelText, (float)(-textWidth) / 2.0f, 0.0f, this.textColor, false, matrices.m_85850_().m_252922_(), (MultiBufferSource)immediate, false, 0, 190);
        matrices.m_85849_();
    }
}

