/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.level.biome.forge;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import dev.architectury.hooks.level.biome.BiomeProperties;
import dev.architectury.hooks.level.biome.ClimateProperties;
import dev.architectury.hooks.level.biome.EffectsProperties;
import dev.architectury.hooks.level.biome.GenerationProperties;
import dev.architectury.hooks.level.biome.SpawnProperties;
import dev.architectury.platform.forge.EventBuses;
import dev.architectury.registry.level.biome.BiomeModifications;
import dev.architectury.utils.GameInstance;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientAdditionsSettings;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.BiomeSpecialEffectsBuilder;
import net.minecraftforge.common.world.ClimateSettingsBuilder;
import net.minecraftforge.common.world.MobSpawnSettingsBuilder;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class BiomeModificationsImpl {
    private static final List<Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>> ADDITIONS = Lists.newArrayList();
    private static final List<Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>> POST_PROCESSING = Lists.newArrayList();
    private static final List<Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>> REMOVALS = Lists.newArrayList();
    private static final List<Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>> REPLACEMENTS = Lists.newArrayList();
    @Nullable
    private static Codec<BiomeModifierImpl> noneBiomeModCodec = null;

    public static void init() {
        EventBuses.onRegistered("architectury", bus -> bus.addListener(event -> event.register(ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, registry -> {
            noneBiomeModCodec = Codec.unit((Object)BiomeModifierImpl.INSTANCE);
            registry.register(new ResourceLocation("architectury", "none_biome_mod_codec"), (Object)noneBiomeModCodec);
        })));
    }

    public static void addProperties(Predicate<BiomeModifications.BiomeContext> predicate, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable> modifier) {
        ADDITIONS.add((Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>)Pair.of(predicate, modifier));
    }

    public static void postProcessProperties(Predicate<BiomeModifications.BiomeContext> predicate, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable> modifier) {
        POST_PROCESSING.add((Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>)Pair.of(predicate, modifier));
    }

    public static void removeProperties(Predicate<BiomeModifications.BiomeContext> predicate, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable> modifier) {
        REMOVALS.add((Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>)Pair.of(predicate, modifier));
    }

    public static void replaceProperties(Predicate<BiomeModifications.BiomeContext> predicate, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable> modifier) {
        REPLACEMENTS.add((Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>)Pair.of(predicate, modifier));
    }

    private static BiomeModifications.BiomeContext wrapSelectionContext(final Optional<ResourceKey<Biome>> biomeResourceKey, final ModifiableBiomeInfo.BiomeInfo.Builder event) {
        return new BiomeModifications.BiomeContext(){
            BiomeProperties properties;
            {
                this.properties = new BiomeWrapped(event);
            }

            @Override
            public Optional<ResourceLocation> getKey() {
                return biomeResourceKey.map(ResourceKey::m_135782_);
            }

            @Override
            public BiomeProperties getProperties() {
                return this.properties;
            }

            @Override
            public boolean hasTag(TagKey<Biome> tag) {
                Optional holder;
                Optional registry;
                MinecraftServer server = GameInstance.getServer();
                if (server != null && (registry = server.m_206579_().m_6632_(Registries.f_256952_)).isPresent() && (holder = ((Registry)registry.get()).m_203636_((ResourceKey)biomeResourceKey.get())).isPresent()) {
                    return ((Holder.Reference)holder.get()).m_203656_(tag);
                }
                return false;
            }
        };
    }

    private static class BiomeModifierImpl
    implements BiomeModifier {
        private static final BiomeModifierImpl INSTANCE = new BiomeModifierImpl();

        private BiomeModifierImpl() {
        }

        public void modify(Holder<Biome> arg, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            List<Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>> list;
            switch (phase) {
                case ADD: {
                    List<Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>> list2 = ADDITIONS;
                    break;
                }
                case REMOVE: {
                    List<Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>> list2 = REMOVALS;
                    break;
                }
                case MODIFY: {
                    List<Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>> list2 = REPLACEMENTS;
                    break;
                }
                case AFTER_EVERYTHING: {
                    List<Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>> list2 = POST_PROCESSING;
                    break;
                }
                default: {
                    List<Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>>> list2 = list = null;
                }
            }
            if (list == null) {
                return;
            }
            BiomeModifications.BiomeContext biomeContext = BiomeModificationsImpl.wrapSelectionContext(arg.m_203543_(), builder);
            MutableBiomeWrapped mutableBiome = new MutableBiomeWrapped(builder);
            for (Pair<Predicate<BiomeModifications.BiomeContext>, BiConsumer<BiomeModifications.BiomeContext, BiomeProperties.Mutable>> pair : list) {
                if (!((Predicate)pair.getLeft()).test(biomeContext)) continue;
                ((BiConsumer)pair.getRight()).accept(biomeContext, mutableBiome);
            }
        }

        public Codec<? extends BiomeModifier> codec() {
            if (noneBiomeModCodec != null) {
                return noneBiomeModCodec;
            }
            return Codec.unit((Object)INSTANCE);
        }
    }

    private static class MutableSpawnSettingsBuilderWrapped
    extends SpawnSettingsBuilderWrapped
    implements SpawnProperties.Mutable {
        public MutableSpawnSettingsBuilderWrapped(MobSpawnSettingsBuilder builder) {
            super(builder);
        }

        @Override
        public SpawnProperties.Mutable setCreatureProbability(float probability) {
            this.builder.m_48368_(probability);
            return this;
        }

        @Override
        public SpawnProperties.Mutable addSpawn(MobCategory category, MobSpawnSettings.SpawnerData data) {
            this.builder.m_48376_(category, data);
            return this;
        }

        @Override
        public boolean removeSpawns(BiPredicate<MobCategory, MobSpawnSettings.SpawnerData> predicate) {
            boolean removed = false;
            for (MobCategory type : this.builder.getSpawnerTypes()) {
                if (!this.builder.getSpawner(type).removeIf(data -> predicate.test(type, (MobSpawnSettings.SpawnerData)data))) continue;
                removed = true;
            }
            return removed;
        }

        @Override
        public SpawnProperties.Mutable setSpawnCost(EntityType<?> entityType, MobSpawnSettings.MobSpawnCost cost) {
            this.builder.m_48370_(entityType, cost.m_48400_(), cost.m_48395_());
            return this;
        }

        @Override
        public SpawnProperties.Mutable setSpawnCost(EntityType<?> entityType, double mass, double gravityLimit) {
            this.builder.m_48370_(entityType, mass, gravityLimit);
            return this;
        }

        @Override
        public SpawnProperties.Mutable clearSpawnCost(EntityType<?> entityType) {
            this.getMobSpawnCosts().remove(entityType);
            return this;
        }
    }

    private static class MutableGenerationSettingsBuilderWrapped
    extends GenerationSettingsBuilderWrapped
    implements GenerationProperties.Mutable {
        public MutableGenerationSettingsBuilderWrapped(BiomeGenerationSettingsBuilder generation) {
            super(generation);
        }

        @Override
        public GenerationProperties.Mutable addFeature(GenerationStep.Decoration decoration, Holder<PlacedFeature> feature) {
            this.generation.m_255419_(decoration, feature);
            return this;
        }

        @Override
        public GenerationProperties.Mutable addFeature(GenerationStep.Decoration decoration, ResourceKey<PlacedFeature> feature) {
            Optional registry;
            MinecraftServer server = GameInstance.getServer();
            if (server != null && (registry = server.m_206579_().m_6632_(Registries.f_256988_)).isPresent()) {
                Optional holder = ((Registry)registry.get()).m_203636_(feature);
                if (holder.isPresent()) {
                    return this.addFeature(decoration, (Holder<PlacedFeature>)((Holder)holder.get()));
                }
                throw new IllegalArgumentException("Unknown feature: " + feature);
            }
            return this;
        }

        @Override
        public GenerationProperties.Mutable addCarver(GenerationStep.Carving carving, Holder<ConfiguredWorldCarver<?>> feature) {
            this.generation.m_254863_(carving, feature);
            return this;
        }

        @Override
        public GenerationProperties.Mutable addCarver(GenerationStep.Carving carving, ResourceKey<ConfiguredWorldCarver<?>> feature) {
            Optional registry;
            MinecraftServer server = GameInstance.getServer();
            if (server != null && (registry = server.m_206579_().m_6632_(Registries.f_257003_)).isPresent()) {
                Optional holder = ((Registry)registry.get()).m_203636_(feature);
                if (holder.isPresent()) {
                    return this.addCarver(carving, (Holder)holder.get());
                }
                throw new IllegalArgumentException("Unknown carver: " + feature);
            }
            return this;
        }

        @Override
        public GenerationProperties.Mutable removeFeature(GenerationStep.Decoration decoration, ResourceKey<PlacedFeature> feature) {
            this.generation.getFeatures(decoration).removeIf(supplier -> supplier.m_203565_(feature));
            return this;
        }

        @Override
        public GenerationProperties.Mutable removeCarver(GenerationStep.Carving carving, ResourceKey<ConfiguredWorldCarver<?>> feature) {
            this.generation.getCarvers(carving).removeIf(supplier -> supplier.m_203565_(feature));
            return this;
        }
    }

    public static class MutableEffectsPropertiesWrapped
    implements EffectsProperties.Mutable {
        public BiomeSpecialEffects.Builder builder;

        public MutableEffectsPropertiesWrapped(BiomeSpecialEffects.Builder builder) {
            this.builder = builder;
        }

        @Override
        public int getFogColor() {
            BiomeSpecialEffects.Builder builder = this.builder;
            if (builder instanceof BiomeSpecialEffectsBuilder) {
                BiomeSpecialEffectsBuilder b = (BiomeSpecialEffectsBuilder)builder;
                return b.getFogColor();
            }
            return this.builder.f_48005_.orElse(-1);
        }

        @Override
        public int getWaterColor() {
            BiomeSpecialEffects.Builder builder = this.builder;
            if (builder instanceof BiomeSpecialEffectsBuilder) {
                BiomeSpecialEffectsBuilder b = (BiomeSpecialEffectsBuilder)builder;
                return b.getWaterFogColor();
            }
            return this.builder.f_48006_.orElse(-1);
        }

        @Override
        public int getWaterFogColor() {
            BiomeSpecialEffects.Builder builder = this.builder;
            if (builder instanceof BiomeSpecialEffectsBuilder) {
                BiomeSpecialEffectsBuilder b = (BiomeSpecialEffectsBuilder)builder;
                return b.getWaterFogColor();
            }
            return this.builder.f_48007_.orElse(-1);
        }

        @Override
        public int getSkyColor() {
            BiomeSpecialEffects.Builder builder = this.builder;
            if (builder instanceof BiomeSpecialEffectsBuilder) {
                BiomeSpecialEffectsBuilder b = (BiomeSpecialEffectsBuilder)builder;
                return b.getSkyColor();
            }
            return this.builder.f_48008_.orElse(-1);
        }

        @Override
        public OptionalInt getFoliageColorOverride() {
            return this.builder.f_48009_.map(OptionalInt::of).orElseGet(OptionalInt::empty);
        }

        @Override
        public OptionalInt getGrassColorOverride() {
            return this.builder.f_48010_.map(OptionalInt::of).orElseGet(OptionalInt::empty);
        }

        @Override
        public BiomeSpecialEffects.GrassColorModifier getGrassColorModifier() {
            return this.builder.f_48011_;
        }

        @Override
        public Optional<AmbientParticleSettings> getAmbientParticle() {
            return this.builder.f_48012_;
        }

        @Override
        public Optional<Holder<SoundEvent>> getAmbientLoopSound() {
            return this.builder.f_48013_;
        }

        @Override
        public Optional<AmbientMoodSettings> getAmbientMoodSound() {
            return this.builder.f_48014_;
        }

        @Override
        public Optional<AmbientAdditionsSettings> getAmbientAdditionsSound() {
            return this.builder.f_48015_;
        }

        @Override
        public Optional<Music> getBackgroundMusic() {
            return this.builder.f_48016_;
        }

        @Override
        public EffectsProperties.Mutable setFogColor(int color) {
            this.builder.m_48019_(color);
            return this;
        }

        @Override
        public EffectsProperties.Mutable setWaterColor(int color) {
            this.builder.m_48034_(color);
            return this;
        }

        @Override
        public EffectsProperties.Mutable setWaterFogColor(int color) {
            this.builder.m_48037_(color);
            return this;
        }

        @Override
        public EffectsProperties.Mutable setSkyColor(int color) {
            this.builder.m_48040_(color);
            return this;
        }

        @Override
        public EffectsProperties.Mutable setFoliageColorOverride(@Nullable Integer colorOverride) {
            this.builder.f_48009_ = Optional.ofNullable(colorOverride);
            return this;
        }

        @Override
        public EffectsProperties.Mutable setGrassColorOverride(@Nullable Integer colorOverride) {
            this.builder.f_48009_ = Optional.ofNullable(colorOverride);
            return this;
        }

        @Override
        public EffectsProperties.Mutable setGrassColorModifier(BiomeSpecialEffects.GrassColorModifier modifier) {
            this.builder.m_48031_(modifier);
            return this;
        }

        @Override
        public EffectsProperties.Mutable setAmbientParticle(@Nullable AmbientParticleSettings settings) {
            this.builder.f_48012_ = Optional.ofNullable(settings);
            return this;
        }

        @Override
        public EffectsProperties.Mutable setAmbientLoopSound(@Nullable Holder<SoundEvent> sound) {
            this.builder.f_48013_ = Optional.ofNullable(sound);
            return this;
        }

        @Override
        public EffectsProperties.Mutable setAmbientMoodSound(@Nullable AmbientMoodSettings settings) {
            this.builder.f_48014_ = Optional.ofNullable(settings);
            return this;
        }

        @Override
        public EffectsProperties.Mutable setAmbientAdditionsSound(@Nullable AmbientAdditionsSettings settings) {
            this.builder.f_48015_ = Optional.ofNullable(settings);
            return this;
        }

        @Override
        public EffectsProperties.Mutable setBackgroundMusic(@Nullable Music music) {
            this.builder.f_48016_ = Optional.ofNullable(music);
            return this;
        }
    }

    public static class MutableClimatePropertiesWrapped
    implements ClimateProperties.Mutable {
        public ClimateSettingsBuilder builder;

        public MutableClimatePropertiesWrapped(ClimateSettingsBuilder builder) {
            this.builder = builder;
        }

        @Override
        public Biome.Precipitation getPrecipitation() {
            return this.builder.getPrecipitation();
        }

        @Override
        public float getTemperature() {
            return this.builder.getTemperature();
        }

        @Override
        public Biome.TemperatureModifier getTemperatureModifier() {
            return this.builder.getTemperatureModifier();
        }

        @Override
        public float getDownfall() {
            return this.builder.getDownfall();
        }

        @Override
        public ClimateProperties.Mutable setPrecipitation(Biome.Precipitation precipitation) {
            this.builder.setPrecipitation(precipitation);
            return this;
        }

        @Override
        public ClimateProperties.Mutable setTemperature(float temperature) {
            this.builder.setTemperature(temperature);
            return this;
        }

        @Override
        public ClimateProperties.Mutable setTemperatureModifier(Biome.TemperatureModifier temperatureModifier) {
            this.builder.setTemperatureModifier(temperatureModifier);
            return this;
        }

        @Override
        public ClimateProperties.Mutable setDownfall(float downfall) {
            this.builder.setDownfall(downfall);
            return this;
        }
    }

    public static class MutableBiomeWrapped
    extends BiomeWrapped
    implements BiomeProperties.Mutable {
        public MutableBiomeWrapped(ModifiableBiomeInfo.BiomeInfo.Builder event) {
            super(event, new MutableClimatePropertiesWrapped(event.getClimateSettings()), new MutableEffectsPropertiesWrapped((BiomeSpecialEffects.Builder)event.getSpecialEffects()), new MutableGenerationSettingsBuilderWrapped(event.getGenerationSettings()), new MutableSpawnSettingsBuilderWrapped(event.getMobSpawnSettings()));
        }

        @Override
        public ClimateProperties.Mutable getClimateProperties() {
            return (ClimateProperties.Mutable)super.getClimateProperties();
        }

        @Override
        public EffectsProperties.Mutable getEffectsProperties() {
            return (EffectsProperties.Mutable)super.getEffectsProperties();
        }

        @Override
        public GenerationProperties.Mutable getGenerationProperties() {
            return (GenerationProperties.Mutable)super.getGenerationProperties();
        }

        @Override
        public SpawnProperties.Mutable getSpawnProperties() {
            return (SpawnProperties.Mutable)super.getSpawnProperties();
        }
    }

    private static class SpawnSettingsBuilderWrapped
    implements SpawnProperties {
        protected final MobSpawnSettingsBuilder builder;

        public SpawnSettingsBuilderWrapped(MobSpawnSettingsBuilder builder) {
            this.builder = builder;
        }

        @Override
        public float getCreatureProbability() {
            return this.builder.getProbability();
        }

        @Override
        public Map<MobCategory, List<MobSpawnSettings.SpawnerData>> getSpawners() {
            return this.builder.f_48362_;
        }

        @Override
        public Map<EntityType<?>, MobSpawnSettings.MobSpawnCost> getMobSpawnCosts() {
            return this.builder.f_48363_;
        }
    }

    private static class GenerationSettingsBuilderWrapped
    implements GenerationProperties {
        protected final BiomeGenerationSettingsBuilder generation;

        public GenerationSettingsBuilderWrapped(BiomeGenerationSettingsBuilder generation) {
            this.generation = generation;
        }

        @Override
        public Iterable<Holder<ConfiguredWorldCarver<?>>> getCarvers(GenerationStep.Carving carving) {
            return this.generation.getCarvers(carving);
        }

        @Override
        public Iterable<Holder<PlacedFeature>> getFeatures(GenerationStep.Decoration decoration) {
            return this.generation.getFeatures(decoration);
        }

        @Override
        public List<Iterable<Holder<PlacedFeature>>> getFeatures() {
            return this.generation.f_254648_;
        }
    }

    public static class BiomeWrapped
    implements BiomeProperties {
        protected final ModifiableBiomeInfo.BiomeInfo.Builder event;
        protected final ClimateProperties climateProperties;
        protected final EffectsProperties effectsProperties;
        protected final GenerationProperties generationProperties;
        protected final SpawnProperties spawnProperties;

        public BiomeWrapped(ModifiableBiomeInfo.BiomeInfo.Builder event) {
            this(event, new MutableClimatePropertiesWrapped(event.getClimateSettings()), new MutableEffectsPropertiesWrapped((BiomeSpecialEffects.Builder)event.getSpecialEffects()), new GenerationSettingsBuilderWrapped(event.getGenerationSettings()), new SpawnSettingsBuilderWrapped(event.getMobSpawnSettings()));
        }

        public BiomeWrapped(ModifiableBiomeInfo.BiomeInfo.Builder event, ClimateProperties climateProperties, EffectsProperties effectsProperties, GenerationProperties generationProperties, SpawnProperties spawnProperties) {
            this.event = event;
            this.climateProperties = climateProperties;
            this.effectsProperties = effectsProperties;
            this.generationProperties = generationProperties;
            this.spawnProperties = spawnProperties;
        }

        @Override
        public ClimateProperties getClimateProperties() {
            return this.climateProperties;
        }

        @Override
        public EffectsProperties getEffectsProperties() {
            return this.effectsProperties;
        }

        @Override
        public GenerationProperties getGenerationProperties() {
            return this.generationProperties;
        }

        @Override
        public SpawnProperties getSpawnProperties() {
            return this.spawnProperties;
        }
    }
}

