/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.registries;

import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public interface RegistrySupplier<T>
extends Supplier<T> {
    public RegistrarManager getRegistrarManager();

    public Registrar<T> getRegistrar();

    public ResourceLocation getRegistryId();

    default public ResourceKey<Registry<T>> getRegistryKey() {
        return ResourceKey.m_135788_((ResourceLocation)this.getRegistryId());
    }

    public ResourceLocation getId();

    public boolean isPresent();

    @Nullable
    default public T getOrNull() {
        if (this.isPresent()) {
            return this.get();
        }
        return null;
    }

    default public Optional<T> toOptional() {
        return Optional.ofNullable(this.getOrNull());
    }

    default public void ifPresent(Consumer<? super T> action) {
        if (this.isPresent()) {
            action.accept(this.get());
        }
    }

    default public void ifPresentOrElse(Consumer<? super T> action, Runnable emptyAction) {
        if (this.isPresent()) {
            action.accept(this.get());
        } else {
            emptyAction.run();
        }
    }

    default public Stream<T> stream() {
        if (!this.isPresent()) {
            return Stream.empty();
        }
        return Stream.of(this.get());
    }

    default public T orElse(T other) {
        return this.isPresent() ? this.get() : other;
    }

    default public T orElseGet(Supplier<? extends T> supplier) {
        return this.isPresent() ? this.get() : supplier.get();
    }

    default public void listen(Consumer<T> callback) {
        this.getRegistrar().listen(this, callback);
    }
}

