/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.blocks;

import mtr.block.IBlock;
import mtr.data.RailAngle;
import mtr.mappings.BlockDirectionalMapper;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import top.mcmtr.data.CatenaryData;
import top.mcmtr.data.RigidCatenaryData;
import top.mcmtr.packet.MSDPacketTrainDataGuiServer;

public class BlockRigidCatenaryNode
extends BlockDirectionalMapper {
    public static final BooleanProperty FACING = BooleanProperty.m_61465_((String)"facing");
    public static final BooleanProperty IS_22_5 = BooleanProperty.m_61465_((String)"is_22_5");
    public static final BooleanProperty IS_45 = BooleanProperty.m_61465_((String)"is_45");
    public static final BooleanProperty IS_CONNECTED = BooleanProperty.m_61465_((String)"is_connected");

    public BlockRigidCatenaryNode(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)IS_22_5, (Comparable)Boolean.valueOf(false))).m_61124_((Property)IS_45, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        int quadrant = RailAngle.getQuadrant((float)blockPlaceContext.m_7074_(), (boolean)true);
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Boolean.valueOf(quadrant % 8 >= 4))).m_61124_((Property)IS_45, (Comparable)Boolean.valueOf(quadrant % 4 >= 2))).m_61124_((Property)IS_22_5, (Comparable)Boolean.valueOf(quadrant % 2 == 1))).m_61124_((Property)IS_CONNECTED, (Comparable)Boolean.valueOf(false));
    }

    public void m_5707_(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        if (!level.f_46443_) {
            RigidCatenaryData rigidCatenaryData = RigidCatenaryData.getInstance(level);
            CatenaryData catenaryData = CatenaryData.getInstance(level);
            if (rigidCatenaryData != null) {
                rigidCatenaryData.removeRigidCatenaryNode(blockPos);
                MSDPacketTrainDataGuiServer.removeRigidCatenaryNodeS2C(level, blockPos);
            }
            if (catenaryData != null) {
                catenaryData.removeCatenaryNode(blockPos);
                MSDPacketTrainDataGuiServer.removeCatenaryNodeS2C(level, blockPos);
            }
        }
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return Shapes.m_83144_();
    }

    public VoxelShape m_5939_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return Shapes.m_83040_();
    }

    public VoxelShape m_7952_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return Shapes.m_83040_();
    }

    public PushReaction m_5537_(BlockState blockState) {
        return PushReaction.BLOCK;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, IS_22_5, IS_45, IS_CONNECTED});
    }

    public static void resetRigidCatenaryNode(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() instanceof BlockRigidCatenaryNode) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)IS_CONNECTED, (Comparable)Boolean.valueOf(false)));
        }
    }

    public static float getAngle(BlockState state) {
        return (float)((Boolean)IBlock.getStatePropertySafe((BlockState)state, (Property)FACING) != false ? 0 : 90) + ((Boolean)IBlock.getStatePropertySafe((BlockState)state, (Property)IS_22_5) != false ? 22.5f : 0.0f) + (float)((Boolean)IBlock.getStatePropertySafe((BlockState)state, (Property)IS_45) != false ? 45 : 0);
    }
}

