/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mtr.block.IBlock;
import mtr.mappings.BlockDirectionalMapper;
import mtr.mappings.BlockEntityClientSerializableMapper;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.mappings.Text;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import top.mcmtr.MSDBlockEntityTypes;
import top.mcmtr.MSDBlocks;
import top.mcmtr.packet.MSDPacketTrainDataGuiServer;

public class BlockYamanoteRailwaySign
extends BlockDirectionalMapper
implements EntityBlockMapper,
IBlock {
    public final int length;
    public final boolean isOdd;
    public static final float SMALL_SIGN_PERCENTAGE = 0.75f;

    public BlockYamanoteRailwaySign(int length, boolean isOdd) {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76419_).m_60999_().m_60978_(2.0f).m_60953_(state -> 15));
        this.length = length;
        this.isOdd = isOdd;
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        return IBlock.checkHoldingBrush((Level)level, (Player)player, () -> {
            BlockPos checkPos;
            Direction facing = (Direction)IBlock.getStatePropertySafe((BlockState)blockState, (Property)f_54117_);
            Direction hitSide = blockHitResult.m_82434_();
            if ((hitSide == facing || hitSide == facing.m_122424_()) && (checkPos = this.findEndWithDirection(level, blockPos, hitSide.m_122424_(), false)) != null) {
                MSDPacketTrainDataGuiServer.openYamanoteRailwaySignScreenS2C((ServerPlayer)player, checkPos);
            }
        });
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos posFrom) {
        boolean isNext;
        Direction facing = (Direction)IBlock.getStatePropertySafe((BlockState)state, (Property)f_54117_);
        boolean bl = isNext = direction == facing.m_122427_() || state.m_60713_((Block)MSDBlocks.YAMANOTE_RAILWAY_SIGN_MIDDLE.get()) && direction == facing.m_122428_();
        if (isNext && !(newState.m_60734_() instanceof BlockYamanoteRailwaySign)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        Direction facing = blockPlaceContext.m_8125_();
        return IBlock.isReplaceable((BlockPlaceContext)blockPlaceContext, (Direction)facing.m_122427_(), (int)(this.getMiddleLength() + 2)) ? (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)facing) : null;
    }

    public void m_5707_(Level level, BlockPos blockPos, BlockState blockState, Player player) {
        Direction facing = (Direction)IBlock.getStatePropertySafe((BlockState)blockState, (Property)f_54117_);
        BlockPos checkPos = this.findEndWithDirection(level, blockPos, facing, true);
        if (checkPos != null) {
            IBlock.onBreakCreative((Level)level, (Player)player, (BlockPos)checkPos);
        }
        super.m_5707_(level, blockPos, blockState, player);
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
        if (!level.f_46443_) {
            Direction facing = (Direction)IBlock.getStatePropertySafe((BlockState)blockState, (Property)f_54117_);
            for (int i = 1; i <= this.getMiddleLength(); ++i) {
                level.m_7731_(blockPos.m_5484_(facing.m_122427_(), i), (BlockState)((Block)MSDBlocks.YAMANOTE_RAILWAY_SIGN_MIDDLE.get()).m_49966_().m_61124_((Property)f_54117_, (Comparable)facing), 3);
            }
            level.m_7731_(blockPos.m_5484_(facing.m_122427_(), this.getMiddleLength() + 1), (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)facing.m_122424_()), 3);
            level.m_46672_(blockPos, Blocks.f_50016_);
            blockState.m_60701_((LevelAccessor)level, blockPos, 3);
        }
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        Direction facing = (Direction)IBlock.getStatePropertySafe((BlockState)blockState, (Property)f_54117_);
        if (blockState.m_60713_((Block)MSDBlocks.YAMANOTE_RAILWAY_SIGN_MIDDLE.get())) {
            return IBlock.getVoxelShapeByDirection((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)12.0, (double)9.0, (Direction)facing);
        }
        int xStart = this.getXStart();
        VoxelShape main = IBlock.getVoxelShapeByDirection((double)(xStart - 1), (double)0.0, (double)7.0, (double)16.0, (double)12.0, (double)9.0, (Direction)facing);
        VoxelShape pole = IBlock.getVoxelShapeByDirection((double)(xStart - 2), (double)0.0, (double)7.5, (double)(xStart - 1), (double)16.0, (double)8.5, (Direction)facing);
        return Shapes.m_83110_((VoxelShape)main, (VoxelShape)pole);
    }

    public String m_7705_() {
        return "block.msd.yamanote_railway_sign";
    }

    public void m_5871_(ItemStack itemStack, BlockGetter blockGetter, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Text.translatable((String)"tooltip.msd.yamanote_railway_sign_length", (Object[])new Object[]{this.length}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
        tooltip.add((Component)Text.translatable((String)(this.isOdd ? "tooltip.msd.yamanote_railway_sign_odd" : "tooltip.msd.yamanote_railway_sign_even"), (Object[])new Object[0]).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
    }

    public BlockEntityMapper createBlockEntity(BlockPos blockPos, BlockState blockState) {
        if (this == MSDBlocks.YAMANOTE_RAILWAY_SIGN_MIDDLE.get()) {
            return null;
        }
        return new TileEntityRailwaySign(this.length, this.isOdd, blockPos, blockState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    public int getXStart() {
        switch (this.length % 4) {
            case 1: {
                return this.isOdd ? 4 : 12;
            }
            case 2: {
                return this.isOdd ? 16 : 8;
            }
            case 3: {
                return this.isOdd ? 12 : 4;
            }
        }
        return this.isOdd ? 8 : 16;
    }

    private int getMiddleLength() {
        return (this.length - (4 - this.getXStart() / 4)) / 2;
    }

    private BlockPos findEndWithDirection(Level world, BlockPos startPos, Direction direction, boolean allowOpposite) {
        int i = 0;
        while (true) {
            BlockPos checkPos;
            BlockState checkState;
            if ((checkState = world.m_8055_(checkPos = startPos.m_5484_(direction.m_122428_(), i))).m_60734_() instanceof BlockYamanoteRailwaySign) {
                Direction facing = (Direction)IBlock.getStatePropertySafe((BlockState)checkState, (Property)f_54117_);
                if (!checkState.m_60713_((Block)MSDBlocks.YAMANOTE_RAILWAY_SIGN_MIDDLE.get()) && (facing == direction || allowOpposite && facing == direction.m_122424_())) {
                    return checkPos;
                }
            } else {
                return null;
            }
            ++i;
        }
    }

    public static class TileEntityRailwaySign
    extends BlockEntityClientSerializableMapper {
        private final Set<Long> selectedIds;
        private final String[] signIds;
        private static final String KEY_SELECTED_IDS = "yamanote_selected_ids";
        private static final String KEY_SIGN_LENGTH = "yamanote_sign_length";

        public TileEntityRailwaySign(int length, boolean isOdd, BlockPos pos, BlockState state) {
            super(TileEntityRailwaySign.getType(length, isOdd), pos, state);
            this.signIds = new String[length];
            this.selectedIds = new HashSet<Long>();
        }

        public void readCompoundTag(CompoundTag compoundTag) {
            this.selectedIds.clear();
            Arrays.stream(compoundTag.m_128467_(KEY_SELECTED_IDS)).forEach(this.selectedIds::add);
            for (int i = 0; i < this.signIds.length; ++i) {
                String signId = compoundTag.m_128461_(KEY_SIGN_LENGTH + i);
                this.signIds[i] = signId.isEmpty() ? null : signId;
            }
        }

        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.m_128428_(KEY_SELECTED_IDS, new ArrayList<Long>(this.selectedIds));
            for (int i = 0; i < this.signIds.length; ++i) {
                compoundTag.m_128359_(KEY_SIGN_LENGTH + i, this.signIds[i] == null ? "" : this.signIds[i]);
            }
        }

        public void setData(Set<Long> selectedIds, String[] signTypes) {
            this.selectedIds.clear();
            this.selectedIds.addAll(selectedIds);
            if (this.signIds.length == signTypes.length) {
                System.arraycopy(signTypes, 0, this.signIds, 0, signTypes.length);
            }
            this.m_6596_();
            this.syncData();
        }

        public Set<Long> getSelectedIds() {
            return this.selectedIds;
        }

        public String[] getSignIds() {
            return this.signIds;
        }

        private static BlockEntityType<?> getType(int length, boolean isOdd) {
            switch (length) {
                case 2: {
                    return isOdd ? (BlockEntityType)MSDBlockEntityTypes.YAMANOTE_RAILWAY_SIGN_2_ODD_TILE_ENTITY.get() : (BlockEntityType)MSDBlockEntityTypes.YAMANOTE_RAILWAY_SIGN_2_EVEN_TILE_ENTITY.get();
                }
                case 3: {
                    return isOdd ? (BlockEntityType)MSDBlockEntityTypes.YAMANOTE_RAILWAY_SIGN_3_ODD_TILE_ENTITY.get() : (BlockEntityType)MSDBlockEntityTypes.YAMANOTE_RAILWAY_SIGN_3_EVEN_TILE_ENTITY.get();
                }
                case 4: {
                    return isOdd ? (BlockEntityType)MSDBlockEntityTypes.YAMANOTE_RAILWAY_SIGN_4_ODD_TILE_ENTITY.get() : (BlockEntityType)MSDBlockEntityTypes.YAMANOTE_RAILWAY_SIGN_4_EVEN_TILE_ENTITY.get();
                }
                case 5: {
                    return isOdd ? (BlockEntityType)MSDBlockEntityTypes.YAMANOTE_RAILWAY_SIGN_5_ODD_TILE_ENTITY.get() : (BlockEntityType)MSDBlockEntityTypes.YAMANOTE_RAILWAY_SIGN_5_EVEN_TILE_ENTITY.get();
                }
                case 6: {
                    return isOdd ? (BlockEntityType)MSDBlockEntityTypes.YAMANOTE_RAILWAY_SIGN_6_ODD_TILE_ENTITY.get() : (BlockEntityType)MSDBlockEntityTypes.YAMANOTE_RAILWAY_SIGN_6_EVEN_TILE_ENTITY.get();
                }
                case 7: {
                    return isOdd ? (BlockEntityType)MSDBlockEntityTypes.YAMANOTE_RAILWAY_SIGN_7_ODD_TILE_ENTITY.get() : (BlockEntityType)MSDBlockEntityTypes.YAMANOTE_RAILWAY_SIGN_7_EVEN_TILE_ENTITY.get();
                }
            }
            return null;
        }
    }
}

