/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.config;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Config {
    private static final Logger LOGGER = LogManager.getLogger();
    private static int rigidCatenarySegmentLength = 1;
    private static final String SEGMENT_LENGTH = "rigid_catenary_segment_length";
    private static final Path CONFIG_PATH = Minecraft.m_91087_().f_91069_.toPath().resolve("config").resolve("msd.json");

    public static int getRigidCatenarySegmentLength() {
        return rigidCatenarySegmentLength;
    }

    public static void refreshProperties() {
        LOGGER.info("Refreshed MSD config");
        try {
            JsonObject jsonConfig = new JsonParser().parse(String.join((CharSequence)"", Files.readAllLines(CONFIG_PATH))).getAsJsonObject();
            try {
                rigidCatenarySegmentLength = jsonConfig.get(SEGMENT_LENGTH).getAsInt();
                if (rigidCatenarySegmentLength < 1 || rigidCatenarySegmentLength > 4) {
                    LOGGER.error("error! Rigid Catenary Segment Length must be >= 1 & <= 4");
                    rigidCatenarySegmentLength = 1;
                }
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            Config.writeToFile();
            Config.refreshProperties();
        }
    }

    private static void writeToFile() {
        LOGGER.info("Wrote MSD config to file");
        JsonObject jsonConfig = new JsonObject();
        jsonConfig.addProperty(SEGMENT_LENGTH, (Number)rigidCatenarySegmentLength);
        try {
            if (!Files.exists(CONFIG_PATH.getParent(), new LinkOption[0])) {
                Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            }
            Files.write(CONFIG_PATH, Collections.singleton(Config.prettyPrint((JsonElement)jsonConfig)), new OpenOption[0]);
        }
        catch (IOException e) {
            LOGGER.error("Configuration file write exception");
            e.printStackTrace();
        }
    }

    private static String prettyPrint(JsonElement jsonElement) {
        return new GsonBuilder().setPrettyPrinting().create().toJson(jsonElement);
    }
}

