/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.data;

import java.io.IOException;
import java.util.Map;
import mtr.data.EnumHelper;
import mtr.data.MessagePackHelper;
import mtr.data.SerializedDataBase;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.Value;
import top.mcmtr.data.CatenaryType;

public class Catenary
extends SerializedDataBase {
    private final int xStart;
    private final int yStart;
    private final int zStart;
    private final int xEnd;
    private final int yEnd;
    private final int zEnd;
    public final CatenaryType catenaryType;
    private static final int ELECTRIC_CURVATURE_SCALE = 300;
    private static final int MAX_ELECTRIC_DIP = 8;
    private static final String KEY_X_START = "c_x_start";
    private static final String KEY_Y_START = "c_y_start";
    private static final String KEY_Z_START = "c_z_start";
    private static final String KEY_X_END = "c_x_end";
    private static final String KEY_Y_END = "c_y_end";
    private static final String KEY_Z_END = "c_z_end";
    private static final String KEY_CATENARY_TYPE = "catenary_type";

    public Catenary(BlockPos posStart, BlockPos posEnd, CatenaryType catenaryType) {
        this.xStart = posStart.m_123341_();
        this.yStart = posStart.m_123342_();
        this.zStart = posStart.m_123343_();
        this.xEnd = posEnd.m_123341_();
        this.yEnd = posEnd.m_123342_();
        this.zEnd = posEnd.m_123343_();
        this.catenaryType = catenaryType;
    }

    public Catenary(Map<String, Value> map) {
        MessagePackHelper messagePackHelper = new MessagePackHelper(map);
        this.xStart = messagePackHelper.getInt(KEY_X_START);
        this.yStart = messagePackHelper.getInt(KEY_Y_START);
        this.zStart = messagePackHelper.getInt(KEY_Z_START);
        this.xEnd = messagePackHelper.getInt(KEY_X_END);
        this.yEnd = messagePackHelper.getInt(KEY_Y_END);
        this.zEnd = messagePackHelper.getInt(KEY_Z_END);
        this.catenaryType = (CatenaryType)EnumHelper.valueOf((Enum)CatenaryType.CATENARY, (String)messagePackHelper.getString(KEY_CATENARY_TYPE));
    }

    @Deprecated
    public Catenary(CompoundTag compoundTag) {
        this.xStart = compoundTag.m_128451_(KEY_X_START);
        this.yStart = compoundTag.m_128451_(KEY_Y_START);
        this.zStart = compoundTag.m_128451_(KEY_Z_START);
        this.xEnd = compoundTag.m_128451_(KEY_X_END);
        this.yEnd = compoundTag.m_128451_(KEY_Y_END);
        this.zEnd = compoundTag.m_128451_(KEY_Z_END);
        this.catenaryType = (CatenaryType)EnumHelper.valueOf((Enum)CatenaryType.CATENARY, (String)compoundTag.m_128461_(KEY_CATENARY_TYPE));
    }

    public Catenary(FriendlyByteBuf packet) {
        this.xStart = packet.readInt();
        this.yStart = packet.readInt();
        this.zStart = packet.readInt();
        this.xEnd = packet.readInt();
        this.yEnd = packet.readInt();
        this.zEnd = packet.readInt();
        this.catenaryType = (CatenaryType)EnumHelper.valueOf((Enum)CatenaryType.CATENARY, (String)packet.m_130136_(Short.MAX_VALUE));
    }

    public void toMessagePack(MessagePacker messagePacker) throws IOException {
        messagePacker.packString(KEY_X_START).packInt(this.xStart);
        messagePacker.packString(KEY_Y_START).packInt(this.yStart);
        messagePacker.packString(KEY_Z_START).packInt(this.zStart);
        messagePacker.packString(KEY_X_END).packInt(this.xEnd);
        messagePacker.packString(KEY_Y_END).packInt(this.yEnd);
        messagePacker.packString(KEY_Z_END).packInt(this.zEnd);
        messagePacker.packString(KEY_CATENARY_TYPE).packString(this.catenaryType.toString());
    }

    public int messagePackLength() {
        return 7;
    }

    public void writePacket(FriendlyByteBuf packet) {
        packet.writeInt(this.xStart);
        packet.writeInt(this.yStart);
        packet.writeInt(this.zStart);
        packet.writeInt(this.xEnd);
        packet.writeInt(this.yEnd);
        packet.writeInt(this.zEnd);
        packet.m_130070_(this.catenaryType.toString());
    }

    public void render(RenderCatenary callback) {
        this.renderSegment(this.xStart, this.yStart, this.zStart, this.xEnd, this.yEnd, this.zEnd, this.catenaryType, callback);
    }

    private void renderSegment(int xStart, int yStart, int zStart, int xEnd, int yEnd, int zEnd, CatenaryType catenaryType, RenderCatenary callback) {
        double count = this.getLength();
        double increment = count / (double)Math.round(count / 2.0);
        double increment2 = increment - 0.5;
        double base = 0.6;
        double sinX = this.getSin(zStart, zEnd, 0.015625, count);
        double sinZ = this.getSin(xStart, xEnd, 0.015625, count);
        if (count < 8.0) {
            for (double i = 0.0; i < count - 0.1; i += increment) {
                Vec3 corner1 = new Vec3(this.getPositionXZ(i, xStart, xEnd) + 0.5, this.getPositionY(i, yStart, yEnd, catenaryType), this.getPositionXZ(i, zStart, zEnd) + 0.5);
                Vec3 corner2 = new Vec3(this.getPositionXZ(i + increment, xStart, xEnd) + 0.5, this.getPositionY(i + increment, yStart, yEnd, catenaryType), this.getPositionXZ(i + increment, zStart, zEnd) + 0.5);
                callback.renderCatenary(corner1.f_82479_, corner1.f_82480_, corner1.f_82481_, corner2.f_82479_, corner2.f_82480_, corner2.f_82481_, count, i, base, sinX, sinZ, increment2);
            }
        } else {
            for (double i = 0.0; i < count - 0.1; i += increment) {
                Vec3 corner1 = new Vec3(this.getPositionXZ(i, xStart, xEnd) + 0.5, this.getPositionY(i, yStart, yEnd, catenaryType), this.getPositionXZ(i, zStart, zEnd) + 0.5);
                Vec3 corner2 = new Vec3(this.getPositionXZ(i + increment, xStart, xEnd) + 0.5, this.getPositionY(i + increment, yStart, yEnd, catenaryType), this.getPositionXZ(i + increment, zStart, zEnd) + 0.5);
                callback.renderCatenary(corner1.f_82479_, corner1.f_82480_, corner1.f_82481_, corner2.f_82479_, corner2.f_82480_, corner2.f_82481_, count, i, base, sinX, sinZ, increment2);
                if (i < count / 2.0 - increment2) {
                    base *= 0.5;
                    continue;
                }
                if (!(i >= count / 2.0)) continue;
                base /= 0.5;
            }
        }
    }

    private double getPositionXZ(double value, int start, int end) {
        double offsetValue;
        double initial;
        double change;
        double length = this.getLength();
        double intercept = length / 2.0;
        if (value < intercept) {
            change = (double)(end - start) / 2.0;
            initial = start;
            offsetValue = value;
        } else {
            change = (double)(start - end) / 2.0;
            initial = end;
            offsetValue = length - value;
        }
        return change / intercept * offsetValue + initial;
    }

    private double getPositionY(double value, int start, int end, CatenaryType catenaryType) {
        double offsetValue;
        double initial;
        double change;
        double length = this.getLength();
        if (catenaryType == CatenaryType.ELECTRIC) {
            if (value < 0.5) {
                return start;
            }
            if (value > length - 0.5) {
                return end;
            }
            double offsetValue2 = value - 0.5;
            double offsetLength = length - 1.0;
            double posY = (double)start + (double)(end - start) * offsetValue2 / offsetLength;
            double dip = offsetLength * offsetLength / 4.0 / 300.0;
            return posY + (dip > 8.0 ? 8.0 / dip : 1.0) * (offsetValue2 - offsetLength) * offsetValue2 / 300.0;
        }
        double intercept = length / 2.0;
        if (value < intercept) {
            change = (double)(end - start) / 2.0;
            initial = start;
            offsetValue = value;
        } else {
            change = (double)(start - end) / 2.0;
            initial = end;
            offsetValue = length - value;
        }
        return change / intercept * offsetValue + initial;
    }

    public double getLength() {
        return Math.sqrt((this.xEnd - this.xStart) * (this.xEnd - this.xStart) + (this.yEnd - this.yStart) * (this.yEnd - this.yStart) + (this.zEnd - this.zStart) * (this.zEnd - this.zStart));
    }

    private double getSin(double start, double end, double offset, double length) {
        return (end - start) / length * offset;
    }

    @FunctionalInterface
    public static interface RenderCatenary {
        public void renderCatenary(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17, double var19, double var21, double var23);
    }
}

