/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import mtr.data.IReducedSaveData;
import mtr.data.MessagePackHelper;
import mtr.data.NameColorDataBase;
import mtr.data.SerializedDataBase;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.ImmutableValue;
import org.msgpack.value.Value;
import top.mcmtr.data.Catenary;
import top.mcmtr.data.CatenaryData;
import top.mcmtr.data.CatenaryDataModuleBase;

public class CatenaryDataFileSaveModule
extends CatenaryDataModuleBase {
    private boolean canAutoSave = false;
    private boolean dataLoaded = false;
    private boolean useReducedHash = true;
    private int filesWritten;
    private int filesDeleted;
    private long autoSaveStartMillis;
    private final List<BlockPos> dirtyCatenaryPositions = new ArrayList<BlockPos>();
    private final Map<Path, Integer> existingFiles = new HashMap<Path, Integer>();
    private final List<Path> checkFilesToDelete = new ArrayList<Path>();
    private final Path catenariesPath;

    public CatenaryDataFileSaveModule(CatenaryData catenaryData, Level world, Map<BlockPos, Map<BlockPos, Catenary>> catenaries, Path savePath) {
        super(catenaryData, world, catenaries);
        this.catenariesPath = savePath.resolve("catenaries");
        try {
            Files.createDirectories(this.catenariesPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void load() {
        this.existingFiles.clear();
        this.readMessagePackFromFile(this.catenariesPath, CatenaryEntry::new, catenaryEntry -> this.catenaries.put(catenaryEntry.pos, catenaryEntry.connections), true);
        System.out.println("MTR Station Decoration data successfully load for " + this.world.m_46472_().m_135782_());
        this.canAutoSave = true;
        this.dataLoaded = true;
    }

    public void fullSave() {
        this.useReducedHash = false;
        this.dirtyCatenaryPositions.clear();
        this.checkFilesToDelete.clear();
        this.autoSave();
        while (!this.autoSaveTick()) {
        }
        this.canAutoSave = false;
    }

    public void autoSave() {
        if (!this.dataLoaded) {
            this.dataLoaded = true;
            this.canAutoSave = true;
        }
        if (this.canAutoSave && this.checkFilesToDelete.isEmpty()) {
            this.autoSaveStartMillis = System.currentTimeMillis();
            this.filesWritten = 0;
            this.filesDeleted = 0;
            this.dirtyCatenaryPositions.addAll(this.catenaries.keySet());
            this.checkFilesToDelete.addAll(this.existingFiles.keySet());
        }
    }

    public boolean autoSaveTick() {
        if (this.canAutoSave) {
            boolean deleteEmptyOld = this.checkFilesToDelete.isEmpty();
            boolean hasSpareTime = this.writeDirtyDataToFile(this.dirtyCatenaryPositions, pos -> this.catenaries.containsKey(pos) ? new CatenaryEntry((BlockPos)pos, (Map)this.catenaries.get(pos)) : null, BlockPos::m_121878_, this.catenariesPath);
            boolean doneWriting = this.dirtyCatenaryPositions.isEmpty();
            if (hasSpareTime && !this.checkFilesToDelete.isEmpty() && doneWriting) {
                Path path = this.checkFilesToDelete.remove(0);
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.existingFiles.remove(path);
                ++this.filesDeleted;
            }
            if (!(deleteEmptyOld || !this.checkFilesToDelete.isEmpty() || this.useReducedHash && this.filesWritten <= 0 && this.filesDeleted <= 0)) {
                System.out.println("MTR Station Decoration save complete for " + this.world.m_46472_().m_135782_() + " in " + (System.currentTimeMillis() - this.autoSaveStartMillis) / 1000L + " second(s)");
                if (this.filesWritten > 0) {
                    System.out.println("- Changed: " + this.filesWritten);
                }
                if (this.filesDeleted > 0) {
                    System.out.println("- Deleted: " + this.filesDeleted);
                }
            }
            return doneWriting && this.checkFilesToDelete.isEmpty();
        }
        return true;
    }

    private <T extends SerializedDataBase> void readMessagePackFromFile(Path path, Function<Map<String, Value>, T> getData, Consumer<T> callback, boolean skipVerify) {
        try (Stream<Path> pathStream = Files.list(path);){
            pathStream.forEach(idFolder -> {
                try (Stream<Path> folderStream = Files.list(idFolder);){
                    folderStream.forEach(idFile -> {
                        try (InputStream inputStream = Files.newInputStream(idFile, new OpenOption[0]);){
                            try (MessageUnpacker messageUnpacker = MessagePack.newDefaultUnpacker((InputStream)inputStream);){
                                int size = messageUnpacker.unpackMapHeader();
                                HashMap<String, ImmutableValue> result = new HashMap<String, ImmutableValue>(size);
                                for (int i = 0; i < size; ++i) {
                                    result.put(messageUnpacker.unpackString(), messageUnpacker.unpackValue());
                                }
                                SerializedDataBase data = (SerializedDataBase)getData.apply(result);
                                if (skipVerify || !(data instanceof NameColorDataBase) || !((NameColorDataBase)data).name.isEmpty()) {
                                    callback.accept(data);
                                }
                                this.existingFiles.put((Path)idFile, CatenaryDataFileSaveModule.getHash(data, true));
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Path writeMessagePackToFile(SerializedDataBase data, long id, Path path) {
        Path parentPath = path.resolve(String.valueOf(id % 100L));
        try {
            Files.createDirectories(parentPath, new FileAttribute[0]);
            Path dataPath = parentPath.resolve(String.valueOf(id));
            int hash = CatenaryDataFileSaveModule.getHash(data, this.useReducedHash);
            if (!this.existingFiles.containsKey(dataPath) || hash != this.existingFiles.get(dataPath)) {
                MessagePacker messagePacker = MessagePack.newDefaultPacker((OutputStream)Files.newOutputStream(dataPath, StandardOpenOption.CREATE));
                messagePacker.packMapHeader(data.messagePackLength());
                data.toMessagePack(messagePacker);
                messagePacker.close();
                this.existingFiles.put(dataPath, hash);
                ++this.filesWritten;
            }
            return dataPath;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private <T extends SerializedDataBase, U> boolean writeDirtyDataToFile(List<U> dirtyData, Function<U, T> getId, Function<U, Long> idToLong, Path path) {
        long millis = System.currentTimeMillis();
        while (!dirtyData.isEmpty()) {
            Path newPath;
            U id = dirtyData.remove(0);
            SerializedDataBase data = (SerializedDataBase)getId.apply(id);
            if (data != null && (newPath = this.writeMessagePackToFile(data, idToLong.apply(id), path)) != null) {
                this.checkFilesToDelete.remove(newPath);
            }
            if (System.currentTimeMillis() - millis < 2L) continue;
            return false;
        }
        return true;
    }

    private static int getHash(SerializedDataBase data, boolean useReducedHash) {
        try {
            MessageBufferPacker messageBufferPacker = MessagePack.newDefaultBufferPacker();
            if (useReducedHash && data instanceof IReducedSaveData) {
                messageBufferPacker.packMapHeader(((IReducedSaveData)data).reducedMessagePackLength());
                ((IReducedSaveData)data).toReducedMessagePack((MessagePacker)messageBufferPacker);
            } else {
                messageBufferPacker.packMapHeader(data.messagePackLength());
                data.toMessagePack((MessagePacker)messageBufferPacker);
            }
            int hash = Arrays.hashCode(messageBufferPacker.toByteArray());
            messageBufferPacker.close();
            return hash;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    private static class CatenaryEntry
    extends SerializedDataBase {
        public final BlockPos pos;
        public final Map<BlockPos, Catenary> connections;
        private static final String KEY_NODE_POS = "catenary_node_pos";
        private static final String KEY_CATENARY_CONNECTIONS = "catenary_connections";

        public CatenaryEntry(BlockPos pos, Map<BlockPos, Catenary> connections) {
            this.pos = pos;
            this.connections = connections;
        }

        public CatenaryEntry(Map<String, Value> map) {
            MessagePackHelper messagePackHelper = new MessagePackHelper(map);
            this.pos = BlockPos.m_122022_((long)messagePackHelper.getLong(KEY_NODE_POS));
            this.connections = new HashMap<BlockPos, Catenary>();
            messagePackHelper.iterateArrayValue(KEY_CATENARY_CONNECTIONS, value -> {
                Map<String, Value> mapSK = CatenaryData.castMessagePackValueToSKMap(value);
                this.connections.put(BlockPos.m_122022_((long)new MessagePackHelper(mapSK).getLong(KEY_NODE_POS)), new Catenary(mapSK));
            });
        }

        public void toMessagePack(MessagePacker messagePacker) throws IOException {
            messagePacker.packString(KEY_NODE_POS).packLong(this.pos.m_121878_());
            messagePacker.packString(KEY_CATENARY_CONNECTIONS).packArrayHeader(this.connections.size());
            for (Map.Entry<BlockPos, Catenary> entry : this.connections.entrySet()) {
                BlockPos endNodePos = entry.getKey();
                messagePacker.packMapHeader(entry.getValue().messagePackLength() + 1);
                messagePacker.packString(KEY_NODE_POS).packLong(endNodePos.m_121878_());
                entry.getValue().toMessagePack(messagePacker);
            }
        }

        public int messagePackLength() {
            return 2;
        }

        public void writePacket(FriendlyByteBuf packet) {
        }
    }
}

