/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.data;

import java.io.IOException;
import java.util.Map;
import mtr.data.EnumHelper;
import mtr.data.MessagePackHelper;
import mtr.data.RailAngle;
import mtr.data.SerializedDataBase;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.Value;
import top.mcmtr.config.Config;
import top.mcmtr.data.CatenaryType;

public class RigidCatenary
extends SerializedDataBase {
    public final CatenaryType catenaryType;
    public final RailAngle facingStart;
    public final RailAngle facingEnd;
    private final double h1;
    private final double k1;
    private final double r1;
    private final double tStart1;
    private final double tEnd1;
    private final double h2;
    private final double k2;
    private final double r2;
    private final double tStart2;
    private final double tEnd2;
    private final int yStart;
    private final int yEnd;
    private final boolean reverseT1;
    private final boolean isStraight1;
    private final boolean reverseT2;
    private final boolean isStraight2;
    private static final double ACCEPT_THRESHOLD = 1.0E-4;
    private static final int MIN_RADIUS = 2;
    private static final String KEY_H_1 = "rigid_h_1";
    private static final String KEY_K_1 = "rigid_k_1";
    private static final String KEY_H_2 = "rigid_h_2";
    private static final String KEY_K_2 = "rigid_k_2";
    private static final String KEY_R_1 = "rigid_r_1";
    private static final String KEY_R_2 = "rigid_r_2";
    private static final String KEY_T_START_1 = "rigid_t_start_1";
    private static final String KEY_T_END_1 = "rigid_t_end_1";
    private static final String KEY_T_START_2 = "rigid_t_start_2";
    private static final String KEY_T_END_2 = "rigid_t_end_2";
    private static final String KEY_Y_START = "rigid_y_start";
    private static final String KEY_Y_END = "rigid_y_end";
    private static final String KEY_REVERSE_T_1 = "rigid_reverse_t_1";
    private static final String KEY_IS_STRAIGHT_1 = "rigid_is_straight_1";
    private static final String KEY_REVERSE_T_2 = "rigid_reverse_t_2";
    private static final String KEY_IS_STRAIGHT_2 = "rigid_is_straight_2";
    private static final String KEY_CATENARY_TYPE = "rigid_catenary_type";

    public RigidCatenary(BlockPos posStart, RailAngle facingStart, BlockPos posEnd, RailAngle facingEnd, CatenaryType catenaryType) {
        this.facingStart = facingStart;
        this.facingEnd = facingEnd;
        this.catenaryType = catenaryType;
        this.yStart = posStart.m_123342_();
        this.yEnd = posEnd.m_123342_();
        int xStart = posStart.m_123341_();
        int zStart = posStart.m_123343_();
        int xEnd = posEnd.m_123341_();
        int zEnd = posEnd.m_123343_();
        Vec3 vecDifference = new Vec3((double)(posEnd.m_123341_() - posStart.m_123341_()), 0.0, (double)(posEnd.m_123343_() - posStart.m_123343_()));
        Vec3 vecDifferenceRotated = vecDifference.m_82524_((float)facingStart.angleRadians);
        double deltaForward = vecDifferenceRotated.f_82481_;
        double deltaSide = vecDifferenceRotated.f_82479_;
        if (facingStart.isParallel(facingEnd)) {
            if (Math.abs(deltaForward) < 1.0E-4) {
                this.h1 = facingStart.cos;
                this.k1 = facingStart.sin;
                if (Math.abs(this.h1) >= 0.5 && Math.abs(this.k1) >= 0.5) {
                    this.r1 = (this.h1 * (double)zStart - this.k1 * (double)xStart) / this.h1 / this.h1;
                    this.tStart1 = (double)xStart / this.h1;
                    this.tEnd1 = (double)xEnd / this.h1;
                } else {
                    double div = facingStart.add((RailAngle)facingStart).cos;
                    this.r1 = (this.h1 * (double)zStart - this.k1 * (double)xStart) / div;
                    this.tStart1 = (this.h1 * (double)xStart - this.k1 * (double)zStart) / div;
                    this.tEnd1 = (this.h1 * (double)xEnd - this.k1 * (double)zEnd) / div;
                }
                this.r2 = 0.0;
                this.k2 = 0.0;
                this.h2 = 0.0;
                this.reverseT1 = this.tStart1 > this.tEnd1;
                this.reverseT2 = false;
                this.isStraight2 = true;
                this.isStraight1 = true;
                this.tEnd2 = 0.0;
                this.tStart2 = 0.0;
            } else if (Math.abs(deltaSide) > 1.0E-4) {
                double radius = (deltaForward * deltaForward + deltaSide * deltaSide) / (4.0 * deltaForward);
                this.r1 = this.r2 = Math.abs(radius);
                this.h1 = (double)xStart - radius * facingStart.sin;
                this.k1 = (double)zStart + radius * facingStart.cos;
                this.h2 = (double)xEnd - radius * facingEnd.sin;
                this.k2 = (double)zEnd + radius * facingEnd.cos;
                this.reverseT1 = deltaForward < 0.0 != deltaSide < 0.0;
                this.reverseT2 = !this.reverseT1;
                this.tStart1 = RigidCatenary.getTBounds(xStart, this.h1, zStart, this.k1, this.r1);
                this.tEnd1 = RigidCatenary.getTBounds((double)xStart + vecDifference.f_82479_ / 2.0, this.h1, (double)zStart + vecDifference.f_82481_ / 2.0, this.k1, this.r1, this.tStart1, this.reverseT1);
                this.tStart2 = RigidCatenary.getTBounds((double)xStart + vecDifference.f_82479_ / 2.0, this.h2, (double)zStart + vecDifference.f_82481_ / 2.0, this.k2, this.r2);
                this.tEnd2 = RigidCatenary.getTBounds(xEnd, this.h2, zEnd, this.k2, this.r2, this.tStart2, this.reverseT2);
                this.isStraight2 = false;
                this.isStraight1 = false;
            } else {
                this.r2 = 0.0;
                this.r1 = 0.0;
                this.k2 = 0.0;
                this.h2 = 0.0;
                this.k1 = 0.0;
                this.h1 = 0.0;
                this.tEnd2 = 0.0;
                this.tEnd1 = 0.0;
                this.tStart2 = 0.0;
                this.tStart1 = 0.0;
                this.reverseT1 = false;
                this.reverseT2 = false;
                this.isStraight2 = true;
                this.isStraight1 = true;
            }
        } else {
            RailAngle newFacingStart = vecDifferenceRotated.f_82479_ < -1.0E-4 ? facingStart.getOpposite() : facingStart;
            RailAngle newFacingEnd = facingEnd.cos * vecDifference.f_82479_ + facingEnd.sin * vecDifference.f_82481_ < -1.0E-4 ? facingEnd.getOpposite() : facingEnd;
            double angleForward = Math.atan2(deltaForward, deltaSide);
            RailAngle railAngleDifference = newFacingEnd.sub(newFacingStart);
            double angleDifference = railAngleDifference.angleRadians;
            if (Math.signum(angleForward) == Math.signum(angleDifference)) {
                double absAngleForward = Math.abs(angleForward);
                if (absAngleForward - Math.abs(angleDifference / 2.0) < 1.0E-4) {
                    double offsetSide = Math.abs(deltaForward / railAngleDifference.halfTan);
                    double remainingSide = deltaSide - offsetSide;
                    double deltaXEnd = (double)xStart + remainingSide * newFacingStart.cos;
                    double deltaZEnd = (double)zStart + remainingSide * newFacingStart.sin;
                    this.h1 = newFacingStart.cos;
                    this.k1 = newFacingStart.sin;
                    if (Math.abs(this.h1) >= 0.5 && Math.abs(this.k1) >= 0.5) {
                        this.r1 = (this.h1 * (double)zStart - this.k1 * (double)xStart) / this.h1 / this.h1;
                        this.tStart1 = (double)xStart / this.h1;
                        this.tEnd1 = deltaXEnd / this.h1;
                    } else {
                        double div = newFacingStart.add((RailAngle)newFacingStart).cos;
                        this.r1 = (this.h1 * (double)zStart - this.k1 * (double)xStart) / div;
                        this.tStart1 = (this.h1 * (double)xStart - this.k1 * (double)zStart) / div;
                        this.tEnd1 = (this.h1 * deltaXEnd - this.k1 * deltaZEnd) / div;
                    }
                    this.isStraight1 = true;
                    this.reverseT1 = this.tStart1 > this.tEnd1;
                    double radius = deltaForward / (1.0 - railAngleDifference.cos);
                    this.r2 = Math.abs(radius);
                    this.h2 = deltaXEnd - radius * newFacingStart.sin;
                    this.k2 = deltaZEnd + radius * newFacingStart.cos;
                    this.reverseT2 = deltaForward < 0.0;
                    this.tStart2 = RigidCatenary.getTBounds(deltaXEnd, this.h2, deltaZEnd, this.k2, this.r2);
                    this.tEnd2 = RigidCatenary.getTBounds(xEnd, this.h2, zEnd, this.k2, this.r2, this.tStart2, this.reverseT2);
                    this.isStraight2 = false;
                } else if (absAngleForward - Math.abs(angleDifference) < 1.0E-4) {
                    double crossSide = deltaForward / railAngleDifference.tan;
                    double remainingSide = (deltaSide - crossSide) * (1.0 + railAngleDifference.cos);
                    double remainingForward = (deltaSide - crossSide) * railAngleDifference.sin;
                    double deltaXEnd = (double)xStart + remainingSide * newFacingStart.cos - remainingForward * newFacingStart.sin;
                    double deltaZEnd = (double)zStart + remainingSide * newFacingStart.sin + remainingForward * newFacingStart.cos;
                    double radius = (deltaSide - deltaForward / railAngleDifference.tan) / railAngleDifference.halfTan;
                    this.r1 = Math.abs(radius);
                    this.h1 = (double)xStart - radius * newFacingStart.sin;
                    this.k1 = (double)zStart + radius * newFacingStart.cos;
                    this.isStraight1 = false;
                    this.reverseT1 = deltaForward < 0.0;
                    this.tStart1 = RigidCatenary.getTBounds(xStart, this.h1, zStart, this.k1, this.r1);
                    this.tEnd1 = RigidCatenary.getTBounds(deltaXEnd, this.h1, deltaZEnd, this.k1, this.r1, this.tStart1, this.reverseT1);
                    this.h2 = newFacingEnd.cos;
                    this.k2 = newFacingEnd.sin;
                    if (Math.abs(this.h2) >= 0.5 && Math.abs(this.k2) >= 0.5) {
                        this.r2 = (this.h2 * deltaZEnd - this.k2 * deltaXEnd) / this.h2 / this.h2;
                        this.tStart2 = deltaXEnd / this.h2;
                        this.tEnd2 = (double)xEnd / this.h2;
                    } else {
                        double div = newFacingEnd.add((RailAngle)newFacingEnd).cos;
                        this.r2 = (this.h2 * deltaZEnd - this.k2 * deltaXEnd) / div;
                        this.tStart2 = (this.h2 * deltaXEnd - this.k2 * deltaZEnd) / div;
                        this.tEnd2 = (this.h2 * (double)xEnd - this.k2 * (double)zEnd) / div;
                    }
                    this.isStraight2 = true;
                    this.reverseT2 = this.tStart2 > this.tEnd2;
                } else {
                    this.r2 = 0.0;
                    this.r1 = 0.0;
                    this.k2 = 0.0;
                    this.h2 = 0.0;
                    this.k1 = 0.0;
                    this.h1 = 0.0;
                    this.tEnd2 = 0.0;
                    this.tEnd1 = 0.0;
                    this.tStart2 = 0.0;
                    this.tStart1 = 0.0;
                    this.reverseT1 = false;
                    this.reverseT2 = false;
                    this.isStraight2 = true;
                    this.isStraight1 = true;
                }
            } else {
                this.r2 = 0.0;
                this.r1 = 0.0;
                this.k2 = 0.0;
                this.h2 = 0.0;
                this.k1 = 0.0;
                this.h1 = 0.0;
                this.tEnd2 = 0.0;
                this.tEnd1 = 0.0;
                this.tStart2 = 0.0;
                this.tStart1 = 0.0;
                this.reverseT1 = false;
                this.reverseT2 = false;
                this.isStraight2 = true;
                this.isStraight1 = true;
            }
        }
    }

    public RigidCatenary(Map<String, Value> map) {
        MessagePackHelper messagePackHelper = new MessagePackHelper(map);
        this.h1 = messagePackHelper.getDouble(KEY_H_1);
        this.k1 = messagePackHelper.getDouble(KEY_K_1);
        this.h2 = messagePackHelper.getDouble(KEY_H_2);
        this.k2 = messagePackHelper.getDouble(KEY_K_2);
        this.r1 = messagePackHelper.getDouble(KEY_R_1);
        this.r2 = messagePackHelper.getDouble(KEY_R_2);
        this.tStart1 = messagePackHelper.getDouble(KEY_T_START_1);
        this.tEnd1 = messagePackHelper.getDouble(KEY_T_END_1);
        this.tStart2 = messagePackHelper.getDouble(KEY_T_START_2);
        this.tEnd2 = messagePackHelper.getDouble(KEY_T_END_2);
        this.yStart = messagePackHelper.getInt(KEY_Y_START);
        this.yEnd = messagePackHelper.getInt(KEY_Y_END);
        this.reverseT1 = messagePackHelper.getBoolean(KEY_REVERSE_T_1);
        this.isStraight1 = messagePackHelper.getBoolean(KEY_IS_STRAIGHT_1);
        this.reverseT2 = messagePackHelper.getBoolean(KEY_REVERSE_T_2);
        this.isStraight2 = messagePackHelper.getBoolean(KEY_IS_STRAIGHT_2);
        this.catenaryType = (CatenaryType)EnumHelper.valueOf((Enum)CatenaryType.RIGID_CATENARY, (String)messagePackHelper.getString(KEY_CATENARY_TYPE));
        this.facingStart = this.getRigidCatenaryAngle(false);
        this.facingEnd = this.getRigidCatenaryAngle(true);
    }

    @Deprecated
    public RigidCatenary(CompoundTag compoundTag) {
        this.h1 = compoundTag.m_128459_(KEY_H_1);
        this.k1 = compoundTag.m_128459_(KEY_K_1);
        this.h2 = compoundTag.m_128459_(KEY_H_2);
        this.k2 = compoundTag.m_128459_(KEY_K_2);
        this.r1 = compoundTag.m_128459_(KEY_R_1);
        this.r2 = compoundTag.m_128459_(KEY_R_2);
        this.tStart1 = compoundTag.m_128459_(KEY_T_START_1);
        this.tEnd1 = compoundTag.m_128459_(KEY_T_END_1);
        this.tStart2 = compoundTag.m_128459_(KEY_T_START_2);
        this.tEnd2 = compoundTag.m_128459_(KEY_T_END_2);
        this.yStart = compoundTag.m_128451_(KEY_Y_START);
        this.yEnd = compoundTag.m_128451_(KEY_Y_END);
        this.reverseT1 = compoundTag.m_128471_(KEY_REVERSE_T_1);
        this.isStraight1 = compoundTag.m_128471_(KEY_IS_STRAIGHT_1);
        this.reverseT2 = compoundTag.m_128471_(KEY_REVERSE_T_2);
        this.isStraight2 = compoundTag.m_128471_(KEY_IS_STRAIGHT_2);
        this.catenaryType = (CatenaryType)EnumHelper.valueOf((Enum)CatenaryType.RIGID_CATENARY, (String)compoundTag.m_128461_(KEY_CATENARY_TYPE));
        this.facingStart = this.getRigidCatenaryAngle(false);
        this.facingEnd = this.getRigidCatenaryAngle(true);
    }

    public RigidCatenary(FriendlyByteBuf packet) {
        this.h1 = packet.readDouble();
        this.k1 = packet.readDouble();
        this.h2 = packet.readDouble();
        this.k2 = packet.readDouble();
        this.r1 = packet.readDouble();
        this.r2 = packet.readDouble();
        this.tStart1 = packet.readDouble();
        this.tEnd1 = packet.readDouble();
        this.tStart2 = packet.readDouble();
        this.tEnd2 = packet.readDouble();
        this.yStart = packet.readInt();
        this.yEnd = packet.readInt();
        this.reverseT1 = packet.readBoolean();
        this.isStraight1 = packet.readBoolean();
        this.reverseT2 = packet.readBoolean();
        this.isStraight2 = packet.readBoolean();
        this.catenaryType = (CatenaryType)EnumHelper.valueOf((Enum)CatenaryType.RIGID_CATENARY, (String)packet.m_130136_(Short.MAX_VALUE));
        this.facingStart = this.getRigidCatenaryAngle(false);
        this.facingEnd = this.getRigidCatenaryAngle(true);
    }

    public void toMessagePack(MessagePacker messagePacker) throws IOException {
        messagePacker.packString(KEY_H_1).packDouble(this.h1);
        messagePacker.packString(KEY_K_1).packDouble(this.k1);
        messagePacker.packString(KEY_H_2).packDouble(this.h2);
        messagePacker.packString(KEY_K_2).packDouble(this.k2);
        messagePacker.packString(KEY_R_1).packDouble(this.r1);
        messagePacker.packString(KEY_R_2).packDouble(this.r2);
        messagePacker.packString(KEY_T_START_1).packDouble(this.tStart1);
        messagePacker.packString(KEY_T_END_1).packDouble(this.tEnd1);
        messagePacker.packString(KEY_T_START_2).packDouble(this.tStart2);
        messagePacker.packString(KEY_T_END_2).packDouble(this.tEnd2);
        messagePacker.packString(KEY_Y_START).packInt(this.yStart);
        messagePacker.packString(KEY_Y_END).packInt(this.yEnd);
        messagePacker.packString(KEY_REVERSE_T_1).packBoolean(this.reverseT1);
        messagePacker.packString(KEY_IS_STRAIGHT_1).packBoolean(this.isStraight1);
        messagePacker.packString(KEY_REVERSE_T_2).packBoolean(this.reverseT2);
        messagePacker.packString(KEY_IS_STRAIGHT_2).packBoolean(this.isStraight2);
        messagePacker.packString(KEY_CATENARY_TYPE).packString(this.catenaryType.toString());
    }

    public int messagePackLength() {
        return 17;
    }

    public void writePacket(FriendlyByteBuf packet) {
        packet.writeDouble(this.h1);
        packet.writeDouble(this.k1);
        packet.writeDouble(this.h2);
        packet.writeDouble(this.k2);
        packet.writeDouble(this.r1);
        packet.writeDouble(this.r2);
        packet.writeDouble(this.tStart1);
        packet.writeDouble(this.tEnd1);
        packet.writeDouble(this.tStart2);
        packet.writeDouble(this.tEnd2);
        packet.writeInt(this.yStart);
        packet.writeInt(this.yEnd);
        packet.writeBoolean(this.reverseT1);
        packet.writeBoolean(this.isStraight1);
        packet.writeBoolean(this.reverseT2);
        packet.writeBoolean(this.isStraight2);
        packet.m_130070_(this.catenaryType.toString());
    }

    public Vec3 getPosition(double rawValue) {
        double count1 = Math.abs(this.tEnd1 - this.tStart1);
        double count2 = Math.abs(this.tEnd2 - this.tStart2);
        double value = Mth.m_14008_((double)rawValue, (double)0.0, (double)(count1 + count2));
        double y = this.getPositionY(value);
        if (value <= count1) {
            return RigidCatenary.getPositionXZ(this.h1, this.k1, this.r1, (double)(this.reverseT1 ? -1 : 1) * value + this.tStart1, 0.0, this.isStraight1).m_82520_(0.0, y, 0.0);
        }
        return RigidCatenary.getPositionXZ(this.h2, this.k2, this.r2, (double)(this.reverseT2 ? -1 : 1) * (value - count1) + this.tStart2, 0.0, this.isStraight2).m_82520_(0.0, y, 0.0);
    }

    public double getLength() {
        return Math.abs(this.tEnd2 - this.tStart2) + Math.abs(this.tEnd1 - this.tStart1);
    }

    public void render(RenderRigidCatenary callback) {
        this.renderSegment(this.h1, this.k1, this.r1, this.tStart1, this.tEnd1, 0.0, this.reverseT1, this.isStraight1, callback);
        this.renderSegment(this.h2, this.k2, this.r2, this.tStart2, this.tEnd2, Math.abs(this.tEnd1 - this.tStart1), this.reverseT2, this.isStraight2, callback);
    }

    private void renderSegment(double h, double k, double r, double tStart, double tEnd, double rawValueOffset, boolean reverseT, boolean isStraight, RenderRigidCatenary callback) {
        int SEGMENT_LENGTH = Config.getRigidCatenarySegmentLength();
        double count = Math.abs(tEnd - tStart);
        double segment_count = Math.round(count / (double)SEGMENT_LENGTH);
        double increment = count / Math.max(1.0, segment_count);
        for (double i = 0.0; i < count - 0.1; i += increment) {
            double t1 = (double)(reverseT ? -1 : 1) * i + tStart;
            double t2 = (double)(reverseT ? -1 : 1) * (i + increment) + tStart;
            Vec3 corner1 = RigidCatenary.getPositionXZ(h, k, r, t1, -0.015625, isStraight);
            Vec3 corner2 = RigidCatenary.getPositionXZ(h, k, r, t1, 0.015625, isStraight);
            Vec3 corner3 = RigidCatenary.getPositionXZ(h, k, r, t2, 0.015625, isStraight);
            Vec3 corner4 = RigidCatenary.getPositionXZ(h, k, r, t2, -0.015625, isStraight);
            Vec3 corner5 = RigidCatenary.getPositionXZ(h, k, r, t1, -0.09375, isStraight);
            Vec3 corner6 = RigidCatenary.getPositionXZ(h, k, r, t1, 0.09375, isStraight);
            Vec3 corner7 = RigidCatenary.getPositionXZ(h, k, r, t2, 0.09375, isStraight);
            Vec3 corner8 = RigidCatenary.getPositionXZ(h, k, r, t2, -0.09375, isStraight);
            double y1 = this.getPositionY(i + rawValueOffset);
            double y2 = this.getPositionY(i + increment + rawValueOffset);
            callback.renderRigidCatenary(corner1.f_82479_, corner1.f_82481_, corner2.f_82479_, corner2.f_82481_, corner3.f_82479_, corner3.f_82481_, corner4.f_82479_, corner4.f_82481_, corner5.f_82479_, corner5.f_82481_, corner6.f_82479_, corner6.f_82481_, corner7.f_82479_, corner7.f_82481_, corner8.f_82479_, corner8.f_82481_, y1, y2);
        }
    }

    public boolean goodRadius() {
        return (this.isStraight1 || this.r1 > 1.9999) && (this.isStraight2 || this.r2 > 1.9999);
    }

    public boolean isValid() {
        return (this.h1 != 0.0 || this.k1 != 0.0 || this.h2 != 0.0 || this.k2 != 0.0 || this.r1 != 0.0 || this.r2 != 0.0 || this.tStart1 != 0.0 || this.tStart2 != 0.0 || this.tEnd1 != 0.0 || this.tEnd2 != 0.0) && this.facingStart == this.getRigidCatenaryAngle(false) && this.facingEnd == this.getRigidCatenaryAngle(true);
    }

    private static Vec3 getPositionXZ(double h, double k, double r, double t, double radiusOffset, boolean isStraight) {
        if (isStraight) {
            return new Vec3(h * t + k * ((Math.abs(h) >= 0.5 && Math.abs(k) >= 0.5 ? 0.0 : r) + radiusOffset) + 0.5, 0.0, k * t + h * (r - radiusOffset) + 0.5);
        }
        return new Vec3(h + (r + radiusOffset) * Math.cos(t / r) + 0.5, 0.0, k + (r + radiusOffset) * Math.sin(t / r) + 0.5);
    }

    private double getPositionY(double value) {
        double offsetValue;
        double yInitial;
        double yChange;
        double length = this.getLength();
        double intercept = length / 2.0;
        if (value < intercept) {
            yChange = (double)(this.yEnd - this.yStart) / 2.0;
            yInitial = this.yStart;
            offsetValue = value;
        } else {
            yChange = (double)(this.yStart - this.yEnd) / 2.0;
            yInitial = this.yEnd;
            offsetValue = length - value;
        }
        return yChange * offsetValue * offsetValue / (intercept * intercept) + yInitial;
    }

    private RailAngle getRigidCatenaryAngle(boolean getEnd) {
        double end;
        double start;
        if (getEnd) {
            start = this.getLength();
            end = start - 1.0E-4;
        } else {
            start = 0.0;
            end = 1.0E-4;
        }
        Vec3 pos1 = this.getPosition(start);
        Vec3 pos2 = this.getPosition(end);
        return RailAngle.fromAngle((float)((float)Math.toDegrees(Math.atan2(pos2.f_82481_ - pos1.f_82481_, pos2.f_82479_ - pos1.f_82479_))));
    }

    private static double getTBounds(double x, double h, double z, double k, double r) {
        return Mth.m_14136_((double)(z - k), (double)(x - h)) * r;
    }

    private static double getTBounds(double x, double h, double z, double k, double r, double tStart, boolean reverse) {
        double t = RigidCatenary.getTBounds(x, h, z, k, r);
        if (t < tStart && !reverse) {
            return t + Math.PI * 2 * r;
        }
        if (t > tStart && reverse) {
            return t - Math.PI * 2 * r;
        }
        return t;
    }

    @FunctionalInterface
    public static interface RenderRigidCatenary {
        public void renderRigidCatenary(double var1, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17, double var19, double var21, double var23, double var25, double var27, double var29, double var31, double var33, double var35);
    }
}

