/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.data;

import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mtr.Registry;
import mtr.data.SerializedDataBase;
import mtr.mappings.PersistentStateMapper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.msgpack.core.MessagePacker;
import org.msgpack.value.Value;
import top.mcmtr.blocks.BlockRigidCatenaryNode;
import top.mcmtr.data.RigidCatenary;
import top.mcmtr.data.RigidCatenaryDataFileSaveModule;
import top.mcmtr.packet.MSDPacket;

public class RigidCatenaryData
extends PersistentStateMapper {
    private final Level world;
    private final Map<BlockPos, Map<BlockPos, RigidCatenary>> rigidCatenaries = new HashMap<BlockPos, Map<BlockPos, RigidCatenary>>();
    private final RigidCatenaryDataFileSaveModule rigidCatenaryDataFileSaveModule;
    private static final String NAME = "msd_rigid_catenary_data";
    private static final String KEY_CATENARIES = "rigid_catenaries";
    private static final int CATENARY_UPDATE_DISTANCE = 128;
    private final Map<Player, BlockPos> playerLastUpdatedPositions = new HashMap<Player, BlockPos>();
    private static final int PLAYER_MOVE_UPDATE_THRESHOLD = 16;

    public RigidCatenaryData(Level world) {
        super(NAME);
        this.world = world;
        ResourceLocation dimensionLocation = world.m_46472_().m_135782_();
        Path savePath = ((ServerLevel)world).m_7654_().m_129843_(LevelResource.f_78182_).resolve("msd").resolve(dimensionLocation.m_135827_()).resolve(dimensionLocation.m_135815_());
        this.rigidCatenaryDataFileSaveModule = new RigidCatenaryDataFileSaveModule(this, world, this.rigidCatenaries, savePath);
    }

    public void load(CompoundTag compoundTag) {
        try {
            CompoundTag tagNewCatenaries = compoundTag.m_128469_(KEY_CATENARIES);
            for (String key : tagNewCatenaries.m_128431_()) {
                RigidCatenaryEntry rigidCatenaryEntry = new RigidCatenaryEntry(tagNewCatenaries.m_128469_(key));
                this.rigidCatenaries.put(rigidCatenaryEntry.pos, rigidCatenaryEntry.connections);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.rigidCatenaryDataFileSaveModule.load();
    }

    public void m_77757_(File file) {
        MinecraftServer minecraftServer = ((ServerLevel)this.world).m_7654_();
        if (minecraftServer.m_129918_() || !minecraftServer.m_130010_()) {
            this.rigidCatenaryDataFileSaveModule.fullSave();
        } else {
            this.rigidCatenaryDataFileSaveModule.autoSave();
        }
        this.m_77762_();
        super.m_77757_(file);
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        return compoundTag;
    }

    public void simulateRigidCatenaries() {
        List players = this.world.m_6907_();
        players.forEach(player -> {
            BlockPos playerBlockPos = player.m_20183_();
            Vec3 playerPos = player.m_20182_();
            if (!this.playerLastUpdatedPositions.containsKey(player) || this.playerLastUpdatedPositions.get(player).m_123333_((Vec3i)playerBlockPos) > 16) {
                HashMap<BlockPos, Map> rigidCatenariesToAdd = new HashMap<BlockPos, Map>();
                this.rigidCatenaries.forEach((startPos, blockPosRigidCatenaryMap) -> blockPosRigidCatenaryMap.forEach((endPos, rigidCatenary) -> {
                    if (new AABB(startPos, endPos).m_82400_(128.0).m_82390_(playerPos)) {
                        if (!rigidCatenariesToAdd.containsKey(startPos)) {
                            rigidCatenariesToAdd.put((BlockPos)startPos, new HashMap());
                        }
                        ((Map)rigidCatenariesToAdd.get(startPos)).put(endPos, rigidCatenary);
                    }
                }));
                FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
                packet.writeInt(rigidCatenariesToAdd.size());
                rigidCatenariesToAdd.forEach((posStart, rigidCatenaryMap) -> {
                    packet.m_130064_(posStart);
                    packet.writeInt(rigidCatenaryMap.size());
                    rigidCatenaryMap.forEach((posEnd, rigidCatenary) -> {
                        packet.m_130064_(posEnd);
                        rigidCatenary.writePacket(packet);
                    });
                });
                if (packet.readableBytes() <= 0x100000) {
                    Registry.sendToPlayer((ServerPlayer)((ServerPlayer)player), (ResourceLocation)MSDPacket.PACKET_WRITE_RIGID_CATENARY, (FriendlyByteBuf)packet);
                }
                this.playerLastUpdatedPositions.put((Player)player, playerBlockPos);
            }
        });
        this.rigidCatenaryDataFileSaveModule.autoSaveTick();
    }

    public void disconnectPlayer(Player player) {
        this.playerLastUpdatedPositions.remove(player);
    }

    public boolean addRigidCatenary(BlockPos posStart, BlockPos posEnd, RigidCatenary rigidCatenary) {
        return RigidCatenaryData.addRigidCatenary(this.rigidCatenaries, posStart, posEnd, rigidCatenary);
    }

    public void removeRigidCatenaryNode(BlockPos pos) {
        RigidCatenaryData.removeRigidCatenaryNode(this.world, this.rigidCatenaries, pos);
    }

    public void removeRigidCatenaryConnection(BlockPos pos1, BlockPos pos2) {
        RigidCatenaryData.removeRigidCatenaryConnection(this.world, this.rigidCatenaries, pos1, pos2);
    }

    public static boolean addRigidCatenary(Map<BlockPos, Map<BlockPos, RigidCatenary>> rigidCatenaries, BlockPos posStart, BlockPos posEnd, RigidCatenary rigidCatenary) {
        try {
            if (posStart.m_123341_() == posEnd.m_123341_() && posStart.m_123342_() == posEnd.m_123342_() && posStart.m_123343_() == posEnd.m_123343_()) {
                return false;
            }
            if (!rigidCatenaries.containsKey(posStart)) {
                rigidCatenaries.put(posStart, new HashMap());
            } else if (rigidCatenaries.get(posStart).containsKey(posEnd)) {
                return false;
            }
            rigidCatenaries.get(posStart).put(posEnd, rigidCatenary);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static void removeRigidCatenaryNode(Level world, Map<BlockPos, Map<BlockPos, RigidCatenary>> rigidCatenaries, BlockPos pos) {
        try {
            rigidCatenaries.remove(pos);
            rigidCatenaries.forEach((startPos, rigidCatenaryMap) -> {
                rigidCatenaryMap.remove(pos);
                if (rigidCatenaryMap.isEmpty() && world != null) {
                    BlockRigidCatenaryNode.resetRigidCatenaryNode(world, pos);
                }
            });
            if (world != null) {
                RigidCatenaryData.validateCatenaries(world, rigidCatenaries);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removeRigidCatenaryConnection(Level world, Map<BlockPos, Map<BlockPos, RigidCatenary>> rigidCatenaries, BlockPos pos1, BlockPos pos2) {
        try {
            if (rigidCatenaries.containsKey(pos1)) {
                rigidCatenaries.get(pos1).remove(pos2);
                if (rigidCatenaries.get(pos1).isEmpty() && world != null) {
                    BlockRigidCatenaryNode.resetRigidCatenaryNode(world, pos1);
                }
            }
            if (rigidCatenaries.containsKey(pos2)) {
                rigidCatenaries.get(pos2).remove(pos1);
                if (rigidCatenaries.get(pos2).isEmpty() && world != null) {
                    BlockRigidCatenaryNode.resetRigidCatenaryNode(world, pos2);
                }
            }
            if (world != null) {
                RigidCatenaryData.validateCatenaries(world, rigidCatenaries);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Map<String, Value> castMessagePackValueToSKMap(Value value) {
        Map<Value, Value> oldMap = value == null ? new HashMap() : value.asMapValue().map();
        HashMap<String, Value> resultMap = new HashMap<String, Value>(oldMap.size());
        oldMap.forEach((key, newValue) -> resultMap.put(key.asStringValue().asString(), (Value)newValue));
        return resultMap;
    }

    public static boolean chunkLoaded(Level world, BlockPos pos) {
        return world.m_7726_().m_7131_(pos.m_123341_() / 16, pos.m_123343_() / 16) != null && world.m_7232_(pos.m_123341_() / 16, pos.m_123343_() / 16);
    }

    public static RigidCatenaryData getInstance(Level world) {
        return (RigidCatenaryData)RigidCatenaryData.getInstance((Level)world, () -> new RigidCatenaryData(world), (String)NAME);
    }

    private static void validateCatenaries(Level world, Map<BlockPos, Map<BlockPos, RigidCatenary>> rigidCatenaries) {
        HashSet rigidCatenariesToRemove = new HashSet();
        HashSet rigidCatenariesNodesToRemove = new HashSet();
        rigidCatenaries.forEach((startPos, rigidCatenaryMap) -> {
            boolean chunkLoaded = RigidCatenaryData.chunkLoaded(world, startPos);
            if (chunkLoaded && !(world.m_8055_(startPos).m_60734_() instanceof BlockRigidCatenaryNode)) {
                rigidCatenariesNodesToRemove.add(startPos);
            }
            if (rigidCatenaryMap.isEmpty()) {
                rigidCatenariesToRemove.add(startPos);
            }
        });
        rigidCatenariesToRemove.forEach(rigidCatenaries::remove);
        rigidCatenariesNodesToRemove.forEach(pos -> RigidCatenaryData.removeRigidCatenaryNode(null, rigidCatenaries, pos));
    }

    @Deprecated
    private static class RigidCatenaryEntry
    extends SerializedDataBase {
        public final BlockPos pos;
        public final Map<BlockPos, RigidCatenary> connections;
        private static final String KEY_NODE_POS = "rigid_catenary_node_pos";
        private static final String KEY_CATENARY_CONNECTIONS = "rigid_catenary_connections";

        public RigidCatenaryEntry(CompoundTag compoundTag) {
            this.pos = BlockPos.m_122022_((long)compoundTag.m_128454_(KEY_NODE_POS));
            this.connections = new HashMap<BlockPos, RigidCatenary>();
            CompoundTag tagConnections = compoundTag.m_128469_(KEY_CATENARY_CONNECTIONS);
            for (String keyConnection : tagConnections.m_128431_()) {
                this.connections.put(BlockPos.m_122022_((long)tagConnections.m_128469_(keyConnection).m_128454_(KEY_NODE_POS)), new RigidCatenary(tagConnections.m_128469_(keyConnection)));
            }
        }

        public void toMessagePack(MessagePacker messagePacker) throws IOException {
            messagePacker.packString(KEY_NODE_POS).packLong(this.pos.m_121878_());
            messagePacker.packString(KEY_CATENARY_CONNECTIONS).packArrayHeader(this.connections.size());
            for (Map.Entry<BlockPos, RigidCatenary> entry : this.connections.entrySet()) {
                BlockPos endNodePos = entry.getKey();
                messagePacker.packMapHeader(entry.getValue().messagePackLength() + 1);
                messagePacker.packString(KEY_NODE_POS).packLong(endNodePos.m_121878_());
                entry.getValue().toMessagePack(messagePacker);
            }
        }

        public int messagePackLength() {
            return 2;
        }

        public void writePacket(FriendlyByteBuf friendlyByteBuf) {
        }
    }
}

