/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.items;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import top.mcmtr.MSDCreativeModeTabs;
import top.mcmtr.blocks.BlockCatenaryNode;
import top.mcmtr.blocks.BlockRigidCatenaryNode;
import top.mcmtr.data.Catenary;
import top.mcmtr.data.CatenaryData;
import top.mcmtr.data.CatenaryType;
import top.mcmtr.items.ItemMSDBlockClickingBase;
import top.mcmtr.packet.MSDPacketTrainDataGuiServer;

public class ItemCatenaryModifier
extends ItemMSDBlockClickingBase {
    private final CatenaryType catenaryType;
    private final boolean isConnector;

    public ItemCatenaryModifier() {
        super(MSDCreativeModeTabs.MSD_BLOCKS, (Item.Properties properties) -> properties.m_41487_(1));
        this.catenaryType = null;
        this.isConnector = false;
    }

    public ItemCatenaryModifier(boolean isConnector, CatenaryType catenaryType) {
        super(MSDCreativeModeTabs.MSD_BLOCKS, (Item.Properties properties) -> properties.m_41487_(1));
        this.catenaryType = catenaryType;
        this.isConnector = isConnector;
    }

    @Override
    protected void onStartClick(UseOnContext context, CompoundTag compoundTag) {
    }

    @Override
    protected void onEndClick(UseOnContext context, BlockPos posEnd, CompoundTag compoundTag) {
        Level world = context.m_43725_();
        CatenaryData catenaryData = CatenaryData.getInstance(world);
        BlockPos posStart = context.m_8083_();
        BlockState stateStart = world.m_8055_(posStart);
        BlockState stateEnd = world.m_8055_(posEnd);
        if (catenaryData != null && (stateEnd.m_60734_() instanceof BlockCatenaryNode || stateEnd.m_60734_() instanceof BlockRigidCatenaryNode)) {
            if (this.isConnector) {
                if (!posStart.equals((Object)posEnd)) {
                    this.onConnect(world, stateStart, stateEnd, posStart, posEnd, catenaryData);
                }
            } else {
                this.onRemove(world, posStart, posEnd, catenaryData);
            }
        }
    }

    @Override
    protected boolean clickCondition(UseOnContext context) {
        Level world = context.m_43725_();
        Block blockStart = world.m_8055_(context.m_8083_()).m_60734_();
        return blockStart instanceof BlockCatenaryNode || blockStart instanceof BlockRigidCatenaryNode;
    }

    private void onConnect(Level world, BlockState stateStart, BlockState stateEnd, BlockPos posStart, BlockPos posEnd, CatenaryData catenaryData) {
        Catenary catenary1 = new Catenary(posStart, posEnd, this.catenaryType);
        Catenary catenary2 = new Catenary(posEnd, posStart, this.catenaryType);
        if (!catenaryData.addCatenary(posStart, posEnd, catenary1)) {
            return;
        }
        catenaryData.addCatenary(posEnd, posStart, catenary2);
        if (stateStart.m_60734_() instanceof BlockCatenaryNode) {
            world.m_46597_(posStart, (BlockState)stateStart.m_61124_((Property)BlockCatenaryNode.IS_CONNECTED, (Comparable)Boolean.valueOf(true)));
        } else {
            world.m_46597_(posStart, (BlockState)stateStart.m_61124_((Property)BlockRigidCatenaryNode.IS_CONNECTED, (Comparable)Boolean.valueOf(true)));
        }
        if (stateEnd.m_60734_() instanceof BlockCatenaryNode) {
            world.m_46597_(posEnd, (BlockState)stateEnd.m_61124_((Property)BlockCatenaryNode.IS_CONNECTED, (Comparable)Boolean.valueOf(true)));
        } else {
            world.m_46597_(posEnd, (BlockState)stateEnd.m_61124_((Property)BlockRigidCatenaryNode.IS_CONNECTED, (Comparable)Boolean.valueOf(true)));
        }
        MSDPacketTrainDataGuiServer.createCatenaryS2C(world, posStart, posEnd, catenary1, catenary2);
    }

    private void onRemove(Level world, BlockPos posStart, BlockPos posEnd, CatenaryData catenaryData) {
        catenaryData.removeCatenaryConnection(posStart, posEnd);
        MSDPacketTrainDataGuiServer.removeCatenaryConnectionS2C(world, posStart, posEnd);
    }
}

