/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.items;

import java.util.List;
import mtr.data.RailAngle;
import mtr.mappings.Text;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import top.mcmtr.MSDCreativeModeTabs;
import top.mcmtr.blocks.BlockRigidCatenaryNode;
import top.mcmtr.data.CatenaryType;
import top.mcmtr.data.RigidCatenary;
import top.mcmtr.data.RigidCatenaryData;
import top.mcmtr.items.ItemMSDBlockClickingBase;
import top.mcmtr.packet.MSDPacketTrainDataGuiServer;

public class ItemRigidCatenaryModifier
extends ItemMSDBlockClickingBase {
    private final CatenaryType catenaryType;
    private final boolean isConnector;

    public ItemRigidCatenaryModifier() {
        super(MSDCreativeModeTabs.MSD_BLOCKS, (Item.Properties properties) -> properties.m_41487_(1));
        this.catenaryType = null;
        this.isConnector = false;
    }

    public ItemRigidCatenaryModifier(boolean isConnector, CatenaryType catenaryType) {
        super(MSDCreativeModeTabs.MSD_BLOCKS, (Item.Properties properties) -> properties.m_41487_(1));
        this.catenaryType = catenaryType;
        this.isConnector = isConnector;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Text.translatable((String)"tooltip.msd.rigid_catenary", (Object[])new Object[0]).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
    }

    @Override
    protected void onStartClick(UseOnContext context, CompoundTag compoundTag) {
    }

    @Override
    protected void onEndClick(UseOnContext context, BlockPos posEnd, CompoundTag compoundTag) {
        Level world = context.m_43725_();
        RigidCatenaryData rigidCatenaryData = RigidCatenaryData.getInstance(world);
        BlockPos posStart = context.m_8083_();
        BlockState stateStart = world.m_8055_(posStart);
        BlockState stateEnd = world.m_8055_(posEnd);
        if (rigidCatenaryData != null && stateEnd.m_60734_() instanceof BlockRigidCatenaryNode) {
            Player player = context.m_43723_();
            if (this.isConnector) {
                if (!posStart.equals((Object)posEnd)) {
                    float angle1 = BlockRigidCatenaryNode.getAngle(stateStart);
                    float angle2 = BlockRigidCatenaryNode.getAngle(stateEnd);
                    float angleDifference = (float)Math.toDegrees(Math.atan2(posEnd.m_123343_() - posStart.m_123343_(), posEnd.m_123341_() - posStart.m_123341_()));
                    RailAngle rigidCatenaryAngleStart = RailAngle.fromAngle((float)(angle1 + (float)(RailAngle.similarFacing((float)angleDifference, (float)angle1) ? 0 : 180)));
                    RailAngle rigidCatenaryAngleEnd = RailAngle.fromAngle((float)(angle2 + (float)(RailAngle.similarFacing((float)angleDifference, (float)angle2) ? 180 : 0)));
                    this.onConnect(world, stateStart, stateEnd, posStart, posEnd, rigidCatenaryAngleStart, rigidCatenaryAngleEnd, rigidCatenaryData, player);
                }
            } else {
                this.onRemove(world, posStart, posEnd, rigidCatenaryData);
            }
        }
    }

    @Override
    protected boolean clickCondition(UseOnContext context) {
        Level world = context.m_43725_();
        Block blockStart = world.m_8055_(context.m_8083_()).m_60734_();
        return blockStart instanceof BlockRigidCatenaryNode;
    }

    private void onConnect(Level world, BlockState stateStart, BlockState stateEnd, BlockPos posStart, BlockPos posEnd, RailAngle facingStart, RailAngle facingEnd, RigidCatenaryData rigidCatenaryData, Player player) {
        boolean isValid;
        RigidCatenary catenary1 = new RigidCatenary(posStart, facingStart, posEnd, facingEnd, this.catenaryType);
        RigidCatenary catenary2 = new RigidCatenary(posEnd, facingEnd, posStart, facingStart, this.catenaryType);
        boolean goodRadius = catenary1.goodRadius() && catenary2.goodRadius();
        boolean bl = isValid = catenary1.isValid() && catenary2.isValid();
        if (goodRadius && isValid) {
            if (!rigidCatenaryData.addRigidCatenary(posStart, posEnd, catenary1)) {
                return;
            }
            rigidCatenaryData.addRigidCatenary(posEnd, posStart, catenary2);
            world.m_46597_(posStart, (BlockState)stateStart.m_61124_((Property)BlockRigidCatenaryNode.IS_CONNECTED, (Comparable)Boolean.valueOf(true)));
            world.m_46597_(posEnd, (BlockState)stateEnd.m_61124_((Property)BlockRigidCatenaryNode.IS_CONNECTED, (Comparable)Boolean.valueOf(true)));
            MSDPacketTrainDataGuiServer.createRigidCatenaryS2C(world, posStart, posEnd, catenary1, catenary2);
        } else if (player != null) {
            player.m_5661_((Component)Text.translatable((String)(goodRadius ? "gui.msd.invalid_orientation" : "gui.msd.radius_too_small"), (Object[])new Object[0]), true);
        }
    }

    private void onRemove(Level world, BlockPos posStart, BlockPos posEnd, RigidCatenaryData rigidCatenaryData) {
        rigidCatenaryData.removeRigidCatenaryConnection(posStart, posEnd);
        MSDPacketTrainDataGuiServer.removeRigidCatenaryConnectionS2C(world, posStart, posEnd);
    }
}

