/*
 * Decompiled with CFR 0.152.
 */
package top.mcmtr.packet;

import io.netty.buffer.Unpooled;
import java.util.HashSet;
import java.util.function.Consumer;
import mtr.Registry;
import mtr.block.BlockRouteSignBase;
import mtr.data.RailwayData;
import mtr.data.RailwayDataLoggingModule;
import mtr.mappings.BlockEntityMapper;
import mtr.packet.PacketTrainDataBase;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import top.mcmtr.blocks.BlockYamanoteRailwaySign;
import top.mcmtr.data.Catenary;
import top.mcmtr.data.RigidCatenary;
import top.mcmtr.packet.MSDPacket;

public class MSDPacketTrainDataGuiServer
extends PacketTrainDataBase {
    public static void openYamanoteRailwaySignScreenS2C(ServerPlayer player, BlockPos signPos) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130064_(signPos);
        Registry.sendToPlayer((ServerPlayer)player, (ResourceLocation)MSDPacket.PACKET_OPEN_YAMANOTE_RAILWAY_SIGN_SCREEN, (FriendlyByteBuf)packet);
    }

    public static void receiveMSDSignIdsC2S(MinecraftServer minecraftServer, ServerPlayer player, FriendlyByteBuf packet) {
        BlockPos signPos = packet.m_130135_();
        int selectedIdsLength = packet.readInt();
        HashSet<Long> selectedIds = new HashSet<Long>();
        for (int i = 0; i < selectedIdsLength; ++i) {
            selectedIds.add(packet.readLong());
        }
        int signLength = packet.readInt();
        String[] signIds = new String[signLength];
        for (int i = 0; i < signLength; ++i) {
            String signId = packet.m_130136_(Short.MAX_VALUE);
            signIds[i] = signId.isEmpty() ? null : signId;
        }
        minecraftServer.execute(() -> {
            BlockEntity entity = player.f_19853_.m_7702_(signPos);
            if (entity instanceof BlockYamanoteRailwaySign.TileEntityRailwaySign) {
                MSDPacketTrainDataGuiServer.setTileEntityDataAndWriteUpdate((ServerPlayer)player, (T entity2) -> entity2.setData(selectedIds, signIds), (BlockEntityMapper[])new BlockYamanoteRailwaySign.TileEntityRailwaySign[]{(BlockYamanoteRailwaySign.TileEntityRailwaySign)entity});
            } else if (entity instanceof BlockRouteSignBase.TileEntityRouteSignBase) {
                long platformId = selectedIds.isEmpty() ? 0L : (Long)selectedIds.toArray()[0];
                BlockEntity entityAbove = player.f_19853_.m_7702_(signPos.m_7494_());
                if (entityAbove instanceof BlockRouteSignBase.TileEntityRouteSignBase) {
                    MSDPacketTrainDataGuiServer.setTileEntityDataAndWriteUpdate((ServerPlayer)player, (T entity2) -> entity2.setPlatformId(platformId), (BlockEntityMapper[])new BlockRouteSignBase.TileEntityRouteSignBase[]{(BlockRouteSignBase.TileEntityRouteSignBase)entityAbove, (BlockRouteSignBase.TileEntityRouteSignBase)entity});
                } else {
                    MSDPacketTrainDataGuiServer.setTileEntityDataAndWriteUpdate((ServerPlayer)player, (T entity2) -> entity2.setPlatformId(platformId), (BlockEntityMapper[])new BlockRouteSignBase.TileEntityRouteSignBase[]{(BlockRouteSignBase.TileEntityRouteSignBase)entity});
                }
            }
        });
    }

    @SafeVarargs
    private static <T extends BlockEntityMapper> void setTileEntityDataAndWriteUpdate(ServerPlayer player, Consumer<T> setData, T ... entities) {
        RailwayData railwayData = RailwayData.getInstance((Level)player.f_19853_);
        if (railwayData != null && entities.length > 0) {
            CompoundTag compoundTagOld = new CompoundTag();
            entities[0].writeCompoundTag(compoundTagOld);
            BlockPos blockPos = null;
            long posLong = 0L;
            for (T entity : entities) {
                setData.accept(entity);
                BlockPos entityPos = entity.m_58899_();
                if (blockPos != null && entityPos.m_121878_() <= posLong) continue;
                blockPos = entityPos;
                posLong = entityPos.m_121878_();
            }
            CompoundTag compoundTagNew = new CompoundTag();
            entities[0].writeCompoundTag(compoundTagNew);
            railwayData.railwayDataLoggingModule.addEvent(player, entities[0].getClass(), RailwayDataLoggingModule.getData((CompoundTag)compoundTagOld), RailwayDataLoggingModule.getData((CompoundTag)compoundTagNew), new BlockPos[]{blockPos});
        }
    }

    public static void createCatenaryS2C(Level world, BlockPos pos1, BlockPos pos2, Catenary catenary1, Catenary catenary2) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130064_(pos1);
        packet.m_130064_(pos2);
        catenary1.writePacket(packet);
        catenary2.writePacket(packet);
        world.m_6907_().forEach(worldPlayer -> Registry.sendToPlayer((ServerPlayer)((ServerPlayer)worldPlayer), (ResourceLocation)MSDPacket.PACKET_CREATE_CATENARY, (FriendlyByteBuf)packet));
    }

    public static void removeCatenaryNodeS2C(Level world, BlockPos pos) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130064_(pos);
        world.m_6907_().forEach(worldPlayer -> Registry.sendToPlayer((ServerPlayer)((ServerPlayer)worldPlayer), (ResourceLocation)MSDPacket.PACKET_REMOVE_CATENARY_NODE, (FriendlyByteBuf)packet));
    }

    public static void removeCatenaryConnectionS2C(Level world, BlockPos pos1, BlockPos pos2) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130064_(pos1);
        packet.m_130064_(pos2);
        world.m_6907_().forEach(worldPlayer -> Registry.sendToPlayer((ServerPlayer)((ServerPlayer)worldPlayer), (ResourceLocation)MSDPacket.PACKET_REMOVE_CATENARY, (FriendlyByteBuf)packet));
    }

    public static void createRigidCatenaryS2C(Level world, BlockPos pos1, BlockPos pos2, RigidCatenary catenary1, RigidCatenary catenary2) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130064_(pos1);
        packet.m_130064_(pos2);
        catenary1.writePacket(packet);
        catenary2.writePacket(packet);
        world.m_6907_().forEach(worldPlayer -> Registry.sendToPlayer((ServerPlayer)((ServerPlayer)worldPlayer), (ResourceLocation)MSDPacket.PACKET_CREATE_RIGID_CATENARY, (FriendlyByteBuf)packet));
    }

    public static void removeRigidCatenaryNodeS2C(Level world, BlockPos pos) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130064_(pos);
        world.m_6907_().forEach(worldPlayer -> Registry.sendToPlayer((ServerPlayer)((ServerPlayer)worldPlayer), (ResourceLocation)MSDPacket.PACKET_REMOVE_RIGID_CATENARY_NODE, (FriendlyByteBuf)packet));
    }

    public static void removeRigidCatenaryConnectionS2C(Level world, BlockPos pos1, BlockPos pos2) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130064_(pos1);
        packet.m_130064_(pos2);
        world.m_6907_().forEach(worldPlayer -> Registry.sendToPlayer((ServerPlayer)((ServerPlayer)worldPlayer), (ResourceLocation)MSDPacket.PACKET_REMOVE_RIGID_CATENARY, (FriendlyByteBuf)packet));
    }
}

