/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.config;

import com.aizistral.nochatreports.common.config.NCRConfig;
import com.aizistral.nochatreports.common.core.ServerSafetyState;
import com.aizistral.nochatreports.common.core.SigningMode;
import com.aizistral.nochatreports.common.gui.FontHelper;
import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;

@Environment(value=EnvType.CLIENT)
public final class ModMenuIntegration
implements ModMenuApi {
    private String translateKey(String key) {
        return Language.m_128107_().m_6834_(key);
    }

    private Component[] wrapTooltip(String text) {
        List<String> list = FontHelper.wrap(Minecraft.m_91087_().f_91062_, text, 250);
        Component[] tooltip = new Component[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            tooltip[i] = Component.m_237113_((String)list.get(i));
        }
        return tooltip;
    }

    private Component[] makeTooltip(String key) {
        return this.wrapTooltip(this.translateKey(key));
    }

    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return screen -> {
            ConfigBuilder builder = ConfigBuilder.create().setParentScreen(Minecraft.m_91087_().f_91080_).setTitle((Component)Component.m_237115_((String)"configuration.NoChatReports.config"));
            ConfigCategory client = builder.getOrCreateCategory((Component)Component.m_237115_((String)"configuration.NoChatReports.category.client"));
            ConfigCategory lan = builder.getOrCreateCategory((Component)Component.m_237115_((String)"configuration.NoChatReports.category.lan"));
            ConfigEntryBuilder entryBuilder = builder.entryBuilder();
            client.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.NoChatReports.enableMod"), NCRConfig.getClient().enableMod).setDefaultValue(true).setTooltip(this.makeTooltip("option.NoChatReports.enableMod.tooltip")).setSaveConsumer(newValue -> ServerSafetyState.scheduleResetAction(() -> {
                NCRConfig.getClient().enableMod = newValue;
                NCRConfig.getClient().saveFile();
            })).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.NoChatReports.showNCRButton"), NCRConfig.getClient().showNCRButton).setDefaultValue(true).setTooltip(this.makeTooltip("option.NoChatReports.showNCRButton.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getClient().showNCRButton = newValue;
            }).build());
            String signingTooltip = this.translateKey("option.NoChatReports.defaultSigningMode.tooltip") + "\n ";
            for (SigningMode mode2 : SigningMode.values()) {
                if (!mode2.isSelectableGlobally()) continue;
                signingTooltip = signingTooltip + "\n\n";
                signingTooltip = signingTooltip + ChatFormatting.AQUA;
                signingTooltip = signingTooltip + ChatFormatting.BOLD;
                signingTooltip = signingTooltip + ChatFormatting.UNDERLINE;
                signingTooltip = signingTooltip + this.translateKey(mode2.getNameKey());
                signingTooltip = signingTooltip + ChatFormatting.RESET;
                signingTooltip = signingTooltip + "\n";
                signingTooltip = signingTooltip + this.translateKey(mode2.getTooltipKey());
            }
            client.addEntry((AbstractConfigListEntry)entryBuilder.startStringDropdownMenu((Component)Component.m_237115_((String)"option.NoChatReports.defaultSigningMode"), NCRConfig.getClient().defaultSigningMode.getName().getString()).setTooltip(this.wrapTooltip(signingTooltip)).setDefaultValue((Object)SigningMode.PROMPT.getName().getString()).setSelections(Stream.of(SigningMode.values()).filter(SigningMode::isSelectableGlobally).map(mode -> mode.getName().getString()).toList()).setSaveConsumer(newValue -> {
                NCRConfig.getClient().defaultSigningMode = Arrays.stream(SigningMode.values()).filter(mode -> mode.getName().getString().equals(newValue)).findFirst().get();
            }).setSuggestionMode(false).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.NoChatReports.showReloadButton"), NCRConfig.getClient().showReloadButton).setDefaultValue(true).setTooltip(this.makeTooltip("option.NoChatReports.showReloadButton.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getClient().showReloadButton = newValue;
            }).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.NoChatReports.verifiedIconEnabled"), NCRConfig.getClient().verifiedIconEnabled).setDefaultValue(true).setTooltip(this.makeTooltip("option.NoChatReports.verifiedIconEnabled.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getClient().verifiedIconEnabled = newValue;
            }).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((Component)Component.m_237115_((String)"option.NoChatReports.verifiedIconOffsetX"), NCRConfig.getClient().verifiedIconOffsetX).setDefaultValue(0).setTooltip(this.makeTooltip("option.NoChatReports.verifiedIconOffsetX.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getClient().verifiedIconOffsetX = newValue;
            }).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((Component)Component.m_237115_((String)"option.NoChatReports.verifiedIconOffsetY"), NCRConfig.getClient().verifiedIconOffsetY).setDefaultValue(0).setTooltip(this.makeTooltip("option.NoChatReports.verifiedIconOffsetY.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getClient().verifiedIconOffsetY = newValue;
            }).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.m_237115_((String)"gui.NoChatReports.showEncryptionButtonWarning")).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.NoChatReports.showEncryptionButton"), NCRConfig.getEncryption().showEncryptionButton).setDefaultValue(true).setTooltip(this.makeTooltip("option.NoChatReports.showEncryptionButton.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getEncryption().showEncryptionButton = newValue;
            }).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.NoChatReports.showEncryptionIndicators"), NCRConfig.getEncryption().showEncryptionIndicators).setDefaultValue(true).setTooltip(this.makeTooltip("option.NoChatReports.showEncryptionIndicators.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getEncryption().showEncryptionIndicators = newValue;
            }).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.NoChatReports.showServerSafety"), NCRConfig.getClient().showServerSafety).setDefaultValue(true).setTooltip(this.makeTooltip("option.NoChatReports.showServerSafety.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getClient().showServerSafety = newValue;
            }).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startTextDescription((Component)Component.m_237115_((String)"option.NoChatReports.showServerSafety.moreInfo").m_130938_(s -> s.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"https://github.com/Aizistral-Studios/No-Chat-Reports/wiki/Configuration-Files/#option-showserversafety"))).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/Aizistral-Studios/No-Chat-Reports/wiki/Configuration-Files/#option-showserversafety")))).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.NoChatReports.hideInsecureMessageIndicators"), NCRConfig.getClient().hideInsecureMessageIndicators).setDefaultValue(true).setTooltip(this.makeTooltip("option.NoChatReports.hideInsecureMessageIndicators.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getClient().hideInsecureMessageIndicators = newValue;
            }).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.NoChatReports.hideModifiedMessageIndicators"), NCRConfig.getClient().hideModifiedMessageIndicators).setDefaultValue(true).setTooltip(this.makeTooltip("option.NoChatReports.hideModifiedMessageIndicators.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getClient().hideModifiedMessageIndicators = newValue;
            }).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.NoChatReports.hideSystemMessageIndicators"), NCRConfig.getClient().hideSystemMessageIndicators).setDefaultValue(true).setTooltip(this.makeTooltip("option.NoChatReports.hideSystemMessageIndicators.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getClient().hideSystemMessageIndicators = newValue;
            }).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.NoChatReports.hideWarningToast"), NCRConfig.getClient().hideWarningToast).setDefaultValue(true).setTooltip(this.makeTooltip("option.NoChatReports.hideWarningToast.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getClient().hideWarningToast = newValue;
            }).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.NoChatReports.hideSigningRequestMessage"), NCRConfig.getClient().hideSigningRequestMessage).setDefaultValue(false).setTooltip(this.makeTooltip("option.NoChatReports.hideSigningRequestMessage.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getClient().hideSigningRequestMessage = newValue;
            }).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.NoChatReports.alwaysHideReportButton"), NCRConfig.getClient().alwaysHideReportButton).setDefaultValue(false).setTooltip(this.makeTooltip("option.NoChatReports.alwaysHideReportButton.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getClient().alwaysHideReportButton = newValue;
            }).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.NoChatReports.demandOnServer"), NCRConfig.getClient().demandOnServer).setDefaultValue(false).setTooltip(this.makeTooltip("option.NoChatReports.demandOnServer.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getClient().demandOnServer = newValue;
            }).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.NoChatReports.enableDebugLog"), NCRConfig.getCommon().enableDebugLog).setDefaultValue(false).setTooltip(this.makeTooltip("option.NoChatReports.enableDebugLog.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getCommon().enableDebugLog = newValue;
            }).build());
            client.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.NoChatReports.disableTelemetry"), NCRConfig.getClient().disableTelemetry).setDefaultValue(true).setTooltip(this.makeTooltip("option.NoChatReports.disableTelemetry.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getClient().disableTelemetry = newValue;
            }).build());
            lan.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.NoChatReports.demandOnClient"), NCRConfig.getCommon().demandOnClient).setDefaultValue(false).setTooltip(this.makeTooltip("option.NoChatReports.demandOnClient.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getCommon().demandOnClient = newValue;
            }).build());
            lan.addEntry((AbstractConfigListEntry)entryBuilder.startStrField((Component)Component.m_237115_((String)"option.NoChatReports.demandOnClientMessage"), NCRConfig.getCommon().demandOnClientMessage).setDefaultValue(NCRConfig.getCommon().demandOnClientMessage).setTooltip(this.makeTooltip("option.NoChatReports.demandOnClientMessage.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getCommon().demandOnClientMessage = newValue;
            }).build());
            lan.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.NoChatReports.convertToGameMessage"), NCRConfig.getCommon().convertToGameMessage).setDefaultValue(true).setTooltip(this.makeTooltip("option.NoChatReports.convertToGameMessage.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getCommon().convertToGameMessage = newValue;
            }).build());
            lan.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((Component)Component.m_237115_((String)"option.NoChatReports.addQueryData"), NCRConfig.getCommon().addQueryData).setDefaultValue(true).setTooltip(this.makeTooltip("option.NoChatReports.addQueryData.tooltip")).setSaveConsumer(newValue -> {
                NCRConfig.getCommon().addQueryData = newValue;
            }).build());
            builder.setSavingRunnable(NCRConfig::save);
            return builder.build();
        };
    }
}

