/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.core;

import com.aizistral.nochatreports.common.config.NCRConfig;
import com.aizistral.nochatreports.common.encryption.Encryptor;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.TranslatableContents;

public class EncryptionUtil {
    public static Optional<Component> tryDecrypt(Component component) {
        Optional<Encryptor<?>> optional = NCRConfig.getEncryption().getEncryptor();
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        Encryptor<?> encryption = optional.get();
        Component copy = EncryptionUtil.recreate(component);
        ComponentContents contents = copy.m_214077_();
        return Optional.ofNullable(EncryptionUtil.tryDecrypt(copy, encryption) ? copy : null);
    }

    public static boolean tryDecrypt(Component component, Encryptor<?> encryptor) {
        boolean decryptedSiblings = false;
        for (Component sibling : component.m_7360_()) {
            if (!EncryptionUtil.tryDecrypt(sibling, encryptor)) continue;
            decryptedSiblings = true;
        }
        ComponentContents componentContents = component.m_214077_();
        if (componentContents instanceof LiteralContents) {
            LiteralContents literal = (LiteralContents)componentContents;
            Optional<String> decrypted = EncryptionUtil.tryDecrypt(literal.f_237368_(), encryptor);
            if (decrypted.isPresent()) {
                ((MutableComponent)component).f_237194_ = new LiteralContents(decrypted.get());
                return true;
            }
        } else {
            componentContents = component.m_214077_();
            if (componentContents instanceof TranslatableContents) {
                TranslatableContents translatable = (TranslatableContents)componentContents;
                for (Object arg : translatable.f_237498_) {
                    MutableComponent mutable;
                    if (!(arg instanceof MutableComponent) || !EncryptionUtil.tryDecrypt((Component)(mutable = (MutableComponent)arg), encryptor)) continue;
                    decryptedSiblings = true;
                }
            }
        }
        return decryptedSiblings;
    }

    public static Optional<String> tryDecrypt(String message, Encryptor<?> encryptor) {
        try {
            String[] stringArray;
            if (message.contains(" ")) {
                stringArray = message.split(" ");
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = message;
            }
            String[] splat = stringArray;
            String decryptable = splat[splat.length - 1];
            String decrypted = encryptor.decrypt(decryptable);
            if (decrypted.startsWith("#%")) {
                return Optional.of(message.substring(0, message.length() - decryptable.length()) + decrypted.substring(2, decrypted.length()));
            }
            return Optional.empty();
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    public static Component recreate(Component component) {
        return Component.Serializer.m_130701_((String)Component.Serializer.m_237122_((Component)component));
    }
}

