/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class AdvancedTooltip
extends Tooltip {
    @Nullable
    protected Supplier<Component> supplier;
    protected int maxWidth = 170;
    protected boolean renderWithoutGap = false;

    public AdvancedTooltip(Component message, @Nullable Component narration) {
        super(message, narration);
    }

    public AdvancedTooltip(Component message) {
        this(message, message);
    }

    public AdvancedTooltip(Supplier<Component> message) {
        this(message.get());
        this.supplier = message;
    }

    public AdvancedTooltip setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public AdvancedTooltip setRenderWithoutGap(boolean render) {
        this.renderWithoutGap = render;
        return this;
    }

    public Component getMessage() {
        return this.supplier != null ? this.supplier.get() : this.f_256850_;
    }

    public List<FormattedCharSequence> m_257408_(Minecraft minecraft) {
        if (this.supplier == null) {
            if (this.f_256766_ == null) {
                this.f_256766_ = AdvancedTooltip.splitTooltip(minecraft, this.getMessage(), this.maxWidth);
            }
            return this.f_256766_;
        }
        return AdvancedTooltip.splitTooltip(minecraft, this.getMessage(), this.maxWidth);
    }

    public boolean hasCustomRender() {
        return this.renderWithoutGap;
    }

    public void doCustomRender(Screen screen, PoseStack poseStack, int x, int y) {
        if (!this.renderWithoutGap) {
            throw new UnsupportedOperationException("This tooltip doesn't support custom render!");
        }
        this.renderTooltipNoGap(screen, poseStack, AdvancedTooltip.splitTooltip(screen.f_96541_, this.getMessage(), this.maxWidth), x, y);
    }

    public static List<FormattedCharSequence> splitTooltip(Minecraft minecraft, Component component, int maxWidth) {
        return minecraft.f_91062_.m_92923_((FormattedText)component, maxWidth);
    }

    protected void renderTooltipNoGap(Screen screen, PoseStack poseStack, List<? extends FormattedCharSequence> list, int x, int y) {
        this.renderTooltipInternalNoGap(screen, poseStack, list.stream().map(ClientTooltipComponent::m_169948_).collect(Collectors.toList()), x, y);
    }

    protected void renderTooltipInternalNoGap(Screen screen, PoseStack poseStack, List<ClientTooltipComponent> list, int x, int y) {
        ClientTooltipComponent clientTooltipComponent2;
        int v;
        int m;
        if (list.isEmpty()) {
            return;
        }
        int k = 0;
        int l = list.size() == 1 ? -2 : -2;
        for (ClientTooltipComponent clientTooltipComponent : list) {
            m = clientTooltipComponent.m_142069_(screen.f_96547_);
            if (m > k) {
                k = m;
            }
            l += clientTooltipComponent.m_142103_();
        }
        int n = x + 12;
        int o = y - 12;
        m = k;
        int p = l;
        if (n + k > screen.f_96543_) {
            n -= 28 + k;
        }
        if (o + p + 6 > screen.f_96544_) {
            o = screen.f_96544_ - p - 6;
        }
        if (y - p - 8 < 0) {
            o = y + 8;
        }
        poseStack.m_85836_();
        int q = -267386864;
        int r = 0x505000FF;
        int s = 1344798847;
        int t = 400;
        float f = screen.f_96542_.f_115093_;
        screen.f_96542_.f_115093_ = 400.0f;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tesselator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        AdvancedTooltip.fillGradient(matrix4f, bufferBuilder, n - 3, o - 4, n + m + 3, o - 3, 400, -267386864, -267386864);
        AdvancedTooltip.fillGradient(matrix4f, bufferBuilder, n - 3, o + p + 3, n + m + 3, o + p + 4, 400, -267386864, -267386864);
        AdvancedTooltip.fillGradient(matrix4f, bufferBuilder, n - 3, o - 3, n + m + 3, o + p + 3, 400, -267386864, -267386864);
        AdvancedTooltip.fillGradient(matrix4f, bufferBuilder, n - 4, o - 3, n - 3, o + p + 3, 400, -267386864, -267386864);
        AdvancedTooltip.fillGradient(matrix4f, bufferBuilder, n + m + 3, o - 3, n + m + 4, o + p + 3, 400, -267386864, -267386864);
        AdvancedTooltip.fillGradient(matrix4f, bufferBuilder, n - 3, o - 3 + 1, n - 3 + 1, o + p + 3 - 1, 400, 0x505000FF, 1344798847);
        AdvancedTooltip.fillGradient(matrix4f, bufferBuilder, n + m + 2, o - 3 + 1, n + m + 3, o + p + 3 - 1, 400, 0x505000FF, 1344798847);
        AdvancedTooltip.fillGradient(matrix4f, bufferBuilder, n - 3, o - 3, n + m + 3, o - 3 + 1, 400, 0x505000FF, 0x505000FF);
        AdvancedTooltip.fillGradient(matrix4f, bufferBuilder, n - 3, o + p + 2, n + m + 3, o + p + 3, 400, 1344798847, 1344798847);
        RenderSystem.m_69482_();
        RenderSystem.m_69472_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.m_69461_();
        RenderSystem.m_69493_();
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        poseStack.m_85837_(0.0, 0.0, 400.0);
        int u = o;
        for (v = 0; v < list.size(); ++v) {
            clientTooltipComponent2 = list.get(v);
            clientTooltipComponent2.m_142440_(screen.f_96547_, n, u, matrix4f, bufferSource);
            u += clientTooltipComponent2.m_142103_();
        }
        bufferSource.m_109911_();
        poseStack.m_85849_();
        u = o;
        for (v = 0; v < list.size(); ++v) {
            clientTooltipComponent2 = list.get(v);
            clientTooltipComponent2.m_183452_(screen.f_96547_, n, u, poseStack, screen.f_96542_, 400);
            u += clientTooltipComponent2.m_142103_() + (v == 0 ? 2 : 0);
        }
        screen.f_96542_.f_115093_ = f;
    }

    protected static void fillGradient(Matrix4f matrix4f, BufferBuilder bufferBuilder, int i, int j, int k, int l, int m, int n, int o) {
        float f = (float)(n >> 24 & 0xFF) / 255.0f;
        float g = (float)(n >> 16 & 0xFF) / 255.0f;
        float h = (float)(n >> 8 & 0xFF) / 255.0f;
        float p = (float)(n & 0xFF) / 255.0f;
        float q = (float)(o >> 24 & 0xFF) / 255.0f;
        float r = (float)(o >> 16 & 0xFF) / 255.0f;
        float s = (float)(o >> 8 & 0xFF) / 255.0f;
        float t = (float)(o & 0xFF) / 255.0f;
        bufferBuilder.m_252986_(matrix4f, (float)k, (float)j, (float)m).m_85950_(g, h, p, f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)i, (float)j, (float)m).m_85950_(g, h, p, f).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)i, (float)l, (float)m).m_85950_(r, s, t, q).m_5752_();
        bufferBuilder.m_252986_(matrix4f, (float)k, (float)l, (float)m).m_85950_(r, s, t, q).m_5752_();
    }
}

