/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.mixins.client;

import com.aizistral.nochatreports.common.NCRClient;
import com.aizistral.nochatreports.common.NCRCore;
import com.aizistral.nochatreports.common.config.NCRConfig;
import com.aizistral.nochatreports.common.core.EncryptionUtil;
import com.aizistral.nochatreports.common.core.ServerSafetyLevel;
import com.aizistral.nochatreports.common.core.ServerSafetyState;
import com.aizistral.nochatreports.common.core.SigningMode;
import com.aizistral.nochatreports.common.gui.UnsafeServerScreen;
import java.time.Instant;
import java.util.Base64;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.chat.ChatListener;
import net.minecraft.client.multiplayer.chat.ChatTrustLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChatListener.class})
public class MixinChatListener {
    @Shadow
    private boolean m_240963_(UUID uuid) {
        throw new IllegalStateException("@Shadow transformation failed. Should never happen.");
    }

    @Inject(method={"handleSystemMessage"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHandleSystemMessage(Component message, boolean overlay, CallbackInfo info) {
        if (message instanceof MutableComponent) {
            TranslatableContents translatable;
            MutableComponent mutable = (MutableComponent)message;
            ComponentContents componentContents = message.m_214077_();
            if (componentContents instanceof TranslatableContents && (translatable = (TranslatableContents)componentContents).m_237508_().equals("chat.disabled.missingProfileKey")) {
                mutable.f_237194_ = new TranslatableContents("chat.nochatreports.disabled.signing_requested");
                if (!ServerSafetyState.isOnRealms()) {
                    ServerSafetyState.updateCurrent(ServerSafetyLevel.INSECURE);
                }
                if (UnsafeServerScreen.hideThisSession() || ServerSafetyState.allowChatSigning()) {
                    return;
                }
                if (NCRConfig.getServerPreferences().hasModeCurrent(SigningMode.ON_DEMAND)) {
                    ServerSafetyState.scheduleSigningAction(NCRClient::resendLastChatMessage);
                    ServerSafetyState.setAllowChatSigning(true);
                    if (NCRConfig.getClient().hideSigningRequestMessage()) {
                        info.cancel();
                    }
                    return;
                }
                if (NCRConfig.getServerPreferences().hasModeCurrent(SigningMode.PROMPT)) {
                    ChatScreen chat;
                    Screen screen;
                    Minecraft.m_91087_().m_91152_((Screen)new UnsafeServerScreen((Screen)((screen = Minecraft.m_91087_().f_91080_) instanceof ChatScreen ? (chat = (ChatScreen)screen) : new ChatScreen(""))));
                    if (NCRConfig.getClient().hideSigningRequestMessage()) {
                        info.cancel();
                    }
                }
            }
        }
    }

    @Inject(method={"evaluateTrustLevel"}, at={@At(value="HEAD")}, cancellable=true)
    private void onEvaluateTrustLevel(PlayerChatMessage playerChatMessage, Component component, Instant instant, CallbackInfoReturnable<ChatTrustLevel> info) {
        if (this.m_240963_(playerChatMessage.m_245167_())) {
            info.setReturnValue((Object)ChatTrustLevel.SECURE);
        } else {
            ChatTrustLevel evaluate;
            if (playerChatMessage.m_245272_() && ServerSafetyState.getCurrent() == ServerSafetyLevel.SECURE) {
                ServerSafetyState.updateCurrent(ServerSafetyLevel.UNINTRUSIVE);
            }
            if ((evaluate = ChatTrustLevel.m_245358_((PlayerChatMessage)playerChatMessage, (Component)component, (Instant)instant)) == ChatTrustLevel.NOT_SECURE && NCRConfig.getClient().hideInsecureMessageIndicators()) {
                info.setReturnValue((Object)ChatTrustLevel.SECURE);
            } else if (evaluate == ChatTrustLevel.MODIFIED && NCRConfig.getClient().hideModifiedMessageIndicators()) {
                info.setReturnValue((Object)ChatTrustLevel.SECURE);
            }
        }
        if (NCRConfig.getCommon().enableDebugLog()) {
            NCRCore.LOGGER.info("Received message: {}, from: {}, signature: {}", (Object)Component.Serializer.m_237122_((Component)playerChatMessage.f_237215_()), (Object)playerChatMessage.f_243882_().f_244443_(), (Object)Base64.getEncoder().encodeToString(playerChatMessage.f_244279_() != null ? playerChatMessage.f_244279_().f_240884_() : new byte[]{}));
        }
    }

    @ModifyVariable(method={"narrateChatMessage(Lnet/minecraft/network/chat/ChatType$Bound;Lnet/minecraft/network/chat/Component;)V"}, at=@At(value="HEAD"), argsOnly=true)
    private Component decryptNarratedMessage(Component msg) {
        return EncryptionUtil.tryDecrypt(msg).orElse(msg);
    }
}

