/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.fabric;

import com.google.common.base.Preconditions;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.blocks.BaseItemStack;
import com.sk89q.worldedit.fabric.FabricPlayer;
import com.sk89q.worldedit.fabric.FabricWorld;
import com.sk89q.worldedit.fabric.FabricWorldEdit;
import com.sk89q.worldedit.fabric.internal.FabricTransmogrifier;
import com.sk89q.worldedit.fabric.internal.NBTConverter;
import com.sk89q.worldedit.internal.block.BlockStateIdAccess;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.math.Vector3;
import com.sk89q.worldedit.registry.state.Property;
import com.sk89q.worldedit.util.Direction;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockType;
import com.sk89q.worldedit.world.block.BlockTypes;
import com.sk89q.worldedit.world.item.ItemType;
import com.sk89q.worldedit.world.item.ItemTypes;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3542;
import net.minecraft.class_7924;

public final class FabricAdapter {
    private FabricAdapter() {
    }

    public static World adapt(class_1937 world) {
        return new FabricWorld(world);
    }

    public static class_1937 adapt(World world) {
        Preconditions.checkNotNull((Object)world);
        if (world instanceof FabricWorld) {
            return ((FabricWorld)world).getWorld();
        }
        throw new UnsupportedOperationException("Cannot adapt from a " + world.getClass());
    }

    public static class_1959 adapt(BiomeType biomeType) {
        return (class_1959)FabricWorldEdit.getRegistry(class_7924.field_41236).method_10223(new class_2960(biomeType.getId()));
    }

    public static BiomeType adapt(class_1959 biome) {
        class_2960 id = FabricWorldEdit.getRegistry(class_7924.field_41236).method_10221((Object)biome);
        Objects.requireNonNull(id, "biome is not registered");
        return BiomeTypes.get(id.toString());
    }

    public static Vector3 adapt(class_243 vector) {
        return Vector3.at(vector.field_1352, vector.field_1351, vector.field_1350);
    }

    public static BlockVector3 adapt(class_2338 pos) {
        return BlockVector3.at(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public static class_243 toVec3(BlockVector3 vector) {
        return new class_243((double)vector.getBlockX(), (double)vector.getBlockY(), (double)vector.getBlockZ());
    }

    public static class_2350 adapt(Direction face) {
        switch (face) {
            case NORTH: {
                return class_2350.field_11043;
            }
            case SOUTH: {
                return class_2350.field_11035;
            }
            case WEST: {
                return class_2350.field_11039;
            }
            case EAST: {
                return class_2350.field_11034;
            }
            case DOWN: {
                return class_2350.field_11033;
            }
        }
        return class_2350.field_11036;
    }

    public static Direction adaptEnumFacing(@Nullable class_2350 face) {
        if (face == null) {
            return null;
        }
        switch (face) {
            case field_11043: {
                return Direction.NORTH;
            }
            case field_11035: {
                return Direction.SOUTH;
            }
            case field_11039: {
                return Direction.WEST;
            }
            case field_11034: {
                return Direction.EAST;
            }
            case field_11033: {
                return Direction.DOWN;
            }
        }
        return Direction.UP;
    }

    public static class_2338 toBlockPos(BlockVector3 vector) {
        return new class_2338(vector.getBlockX(), vector.getBlockY(), vector.getBlockZ());
    }

    @Deprecated
    public static Property<?> adaptProperty(class_2769<?> property) {
        return FabricTransmogrifier.transmogToWorldEditProperty(property);
    }

    @Deprecated
    public static Map<Property<?>, Object> adaptProperties(BlockType block, Map<class_2769<?>, Comparable<?>> mcProps) {
        TreeMap props = new TreeMap(Comparator.comparing(Property::getName));
        for (Map.Entry<class_2769<?>, Comparable<?>> prop : mcProps.entrySet()) {
            Object value = prop.getValue();
            if (prop.getKey() instanceof class_2753) {
                value = FabricAdapter.adaptEnumFacing((class_2350)value);
            } else if (prop.getKey() instanceof class_2754) {
                value = ((class_3542)value).method_15434();
            }
            props.put(block.getProperty(prop.getKey().method_11899()), value);
        }
        return props;
    }

    public static class_2680 adapt(BlockState blockState) {
        int blockStateId = BlockStateIdAccess.getBlockStateId(blockState);
        if (!BlockStateIdAccess.isValidInternalId(blockStateId)) {
            return FabricTransmogrifier.transmogToMinecraft(blockState);
        }
        return class_2248.method_9531((int)blockStateId);
    }

    public static BlockState adapt(class_2680 blockState) {
        int blockStateId = class_2248.method_9507((class_2680)blockState);
        BlockState worldEdit = BlockStateIdAccess.getBlockStateById(blockStateId);
        if (worldEdit == null) {
            return FabricTransmogrifier.transmogToWorldEdit(blockState);
        }
        return worldEdit;
    }

    public static class_2248 adapt(BlockType blockType) {
        return (class_2248)FabricWorldEdit.getRegistry(class_7924.field_41254).method_10223(new class_2960(blockType.getId()));
    }

    public static BlockType adapt(class_2248 block) {
        return BlockTypes.get(FabricWorldEdit.getRegistry(class_7924.field_41254).method_10221((Object)block).toString());
    }

    public static class_1792 adapt(ItemType itemType) {
        return (class_1792)FabricWorldEdit.getRegistry(class_7924.field_41197).method_10223(new class_2960(itemType.getId()));
    }

    public static ItemType adapt(class_1792 item) {
        return ItemTypes.get(FabricWorldEdit.getRegistry(class_7924.field_41197).method_10221((Object)item).toString());
    }

    public static class_1799 adapt(BaseItemStack baseItemStack) {
        class_2487 fabricCompound = null;
        if (baseItemStack.getNbtData() != null) {
            fabricCompound = NBTConverter.toNative(baseItemStack.getNbtData());
        }
        class_1799 itemStack = new class_1799((class_1935)FabricAdapter.adapt(baseItemStack.getType()), baseItemStack.getAmount());
        itemStack.method_7980(fabricCompound);
        return itemStack;
    }

    public static BaseItemStack adapt(class_1799 itemStack) {
        Tag tagTag;
        CompoundTag tag = NBTConverter.fromNative(itemStack.method_7953(new class_2487()));
        tag = tag.getValue().isEmpty() ? null : ((tagTag = (Tag)tag.getValue().get("tag")) instanceof CompoundTag ? (CompoundTag)tagTag : null);
        return new BaseItemStack(FabricAdapter.adapt(itemStack.method_7909()), tag, itemStack.method_7947());
    }

    public static FabricPlayer adaptPlayer(class_3222 player) {
        Preconditions.checkNotNull((Object)player);
        return new FabricPlayer(player);
    }
}

