/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.entity.npc;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.core.CorgiLibRegistry;
import corgitaco.corgilib.reg.RegistrationProvider;
import corgitaco.corgilib.serialization.codec.CodecUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1291;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_20;
import net.minecraft.class_3853;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class VillagerTradeRegistry {
    public static final Codec<class_1792> ITEM_CODEC = CodecUtil.createLoggedExceptionRegistryCodec(class_7923.field_41178);
    public static final Codec<class_1291> MOB_EFFECT_CODEC = CodecUtil.createLoggedExceptionRegistryCodec(class_7923.field_41174);
    private static final Codec<class_3853.class_4161> EMERALD_FOR_ITEMS_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ITEM_CODEC.fieldOf("item").forGetter(listing -> listing.field_18548), (App)Codec.INT.fieldOf("cost").forGetter(listing -> listing.field_18549), (App)Codec.INT.fieldOf("max_uses").forGetter(listing -> listing.field_18550), (App)Codec.INT.fieldOf("villager_xp").forGetter(listing -> listing.field_18551)).apply((Applicative)builder, class_3853.class_4161::new));
    private static final Codec<class_3853.class_4165> ITEMS_FOR_EMERALDS_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ITEM_CODEC.fieldOf("item").forGetter(listing -> listing.field_18571.method_7909()), (App)Codec.INT.fieldOf("emerald_cost").forGetter(listing -> listing.field_18572), (App)Codec.INT.fieldOf("number_of_items").forGetter(listing -> listing.field_18573), (App)Codec.INT.fieldOf("max_uses").forGetter(listing -> listing.field_18574), (App)Codec.INT.fieldOf("villager_xp").forGetter(listing -> listing.field_18575)).apply((Applicative)builder, class_3853.class_4165::new));
    private static final Codec<class_3853.class_4164> ITEMS_AND_EMERALDS_TO_ITEMS_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ITEM_CODEC.fieldOf("from_item").forGetter(listing -> listing.field_18563.method_7909()), (App)Codec.INT.fieldOf("from_count").forGetter(listing -> listing.field_18564), (App)Codec.INT.fieldOf("emerald_cost").forGetter(listing -> listing.field_18565), (App)ITEM_CODEC.fieldOf("to_item").forGetter(listing -> listing.field_18566.method_7909()), (App)Codec.INT.fieldOf("to_count").forGetter(listing -> listing.field_18567), (App)Codec.INT.fieldOf("max_uses").forGetter(listing -> listing.field_18568), (App)Codec.INT.fieldOf("villager_xp").forGetter(listing -> listing.field_18569)).apply((Applicative)builder, class_3853.class_4164::new));
    private static final Codec<class_3853.class_4166> SUSPICIOUS_STEW_FOR_EMERALD_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)MOB_EFFECT_CODEC.fieldOf("mob_effect").forGetter(listing -> listing.field_18577), (App)Codec.INT.fieldOf("duration").forGetter(listing -> listing.field_18578), (App)Codec.INT.fieldOf("xp").forGetter(listing -> listing.field_18579)).apply((Applicative)builder, class_3853.class_4166::new));
    public static final Codec<class_20.class_21> MAP_DECORATION_TYPE_CODEC = Codec.STRING.comapFlatMap(type -> {
        try {
            return DataResult.success((Object)class_20.class_21.valueOf((String)type.toUpperCase()));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Invalid Map Decoration Type! You put \"%s\". Valid values: %s".formatted(type, Arrays.toString(class_20.class_21.values())));
        }
    }, Enum::name);
    private static final Codec<class_3853.class_1654> TREASURE_MAP_FOR_EMERALDS_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("emerald_cost").forGetter(listing -> listing.field_18589), (App)class_6862.method_40093((class_5321)class_7924.field_41246).fieldOf("destination").forGetter(listing -> listing.field_7474), (App)Codec.STRING.fieldOf("display_name").forGetter(listing -> listing.field_37051), (App)MAP_DECORATION_TYPE_CODEC.fieldOf("destination_type").forGetter(listing -> listing.field_7473), (App)Codec.INT.fieldOf("max_uses").forGetter(listing -> listing.field_18590), (App)Codec.INT.fieldOf("villager_xp").forGetter(listing -> listing.field_18591)).apply((Applicative)builder, class_3853.class_1654::new));
    private static final Map<Class<? extends class_3853.class_1652>, Codec<? extends class_3853.class_1652>> ITEM_LISTING_CLASS_BY_CODEC = (Map)class_156.method_654(new HashMap(), map -> {
        map.put(class_3853.class_4161.class, EMERALD_FOR_ITEMS_CODEC);
        map.put(class_3853.class_4165.class, ITEMS_FOR_EMERALDS_CODEC);
        map.put(class_3853.class_4166.class, SUSPICIOUS_STEW_FOR_EMERALD_CODEC);
        map.put(class_3853.class_4164.class, ITEMS_AND_EMERALDS_TO_ITEMS_CODEC);
        map.put(class_3853.class_1654.class, TREASURE_MAP_FOR_EMERALDS_CODEC);
    });
    public static final Codec<class_3853.class_1652> ITEM_LISTING_CODEC = class_5699.method_39240(() -> CorgiLibRegistry.VILLAGER_TRADES_ITEM_LISTING.get().method_39673().dispatchStable(itemListing -> ITEM_LISTING_CLASS_BY_CODEC.get(itemListing.getClass()), codec -> codec.fieldOf("config").codec()));

    public static void register() {
        RegistrationProvider<Codec<? extends class_3853.class_1652>> provider = RegistrationProvider.get(CorgiLibRegistry.VILLAGER_TRADES_ITEM_LISTING_RESOURCE_KEY, "corgilib");
        provider.register("emerald_for_items", () -> EMERALD_FOR_ITEMS_CODEC);
        provider.register("items_for_emeralds", () -> ITEMS_FOR_EMERALDS_CODEC);
        provider.register("suspicious_stew_for_emerald", () -> SUSPICIOUS_STEW_FOR_EMERALD_CODEC);
        provider.register("items_and_emeralds_to_items", () -> ITEMS_AND_EMERALDS_TO_ITEMS_CODEC);
        provider.register("treasure_map_for_emeralds", () -> TREASURE_MAP_FOR_EMERALDS_CODEC);
    }
}

