/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.block.behavior;

import com.lx862.jcm.mod.block.base.DirectionalBlock;
import com.lx862.jcm.mod.data.BlockProperties;
import com.lx862.jcm.mod.util.BlockUtil;
import java.util.List;
import net.minecraft.class_2769;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BooleanProperty;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.ItemPlacementContext;
import org.mtr.mapping.holder.Property;
import org.mtr.mapping.holder.World;
import org.mtr.mapping.holder.WorldAccess;
import org.mtr.mapping.tool.HolderBase;

public interface HorizontalDoubleBlockBehavior {
    public static final BooleanProperty IS_LEFT = BlockProperties.HORIZONTAL_IS_LEFT;

    public static boolean canBePlaced(ItemPlacementContext ctx) {
        return BlockUtil.isReplacable(ctx.getWorld(), ctx.getBlockPos(), ctx.getPlayerFacing().rotateYClockwise(), ctx, 2);
    }

    public static void placeBlock(World world, BlockPos pos, BlockState state, BooleanProperty isLeft, Direction directionToPlace, int length) {
        world.setBlockState(pos.offset(directionToPlace), state.with(new Property((class_2769)isLeft.data), (Comparable)Boolean.valueOf(false)));
    }

    public static boolean blockIsValid(BlockPos pos, BlockState state, WorldAccess world, boolean thisBlockIsLeftPart) {
        Direction dir = BlockUtil.getProperty(state, DirectionalBlock.FACING);
        boolean checkLeft = !thisBlockIsLeftPart;
        BlockPos neighbourPos = checkLeft ? pos.offset(dir.rotateYCounterclockwise()) : pos.offset(dir.rotateYClockwise());
        BlockState neighbourState = world.getBlockState(neighbourPos);
        return neighbourState.isOf(state.getBlock());
    }

    public static void onPlaced(World world, BlockState state, BlockPos placedPos) {
        world.setBlockState(placedPos.offset(BlockUtil.getProperty(state, DirectionalBlock.FACING).rotateYClockwise()), state.with(new Property((class_2769)HorizontalDoubleBlockBehavior.IS_LEFT.data), (Comparable)Boolean.valueOf(false)));
    }

    public static void addProperties(List<HolderBase<?>> properties) {
        properties.add((HolderBase<?>)IS_LEFT);
    }
}

