/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.data.pids.preset.components;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.lx862.jcm.mod.data.JCMClientStats;
import com.lx862.jcm.mod.data.KVPair;
import com.lx862.jcm.mod.data.pids.preset.PIDSContext;
import com.lx862.jcm.mod.data.pids.preset.components.base.PIDSComponent;
import java.util.ArrayList;
import java.util.List;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mapping.mapper.GuiDrawing;

public class CycleComponent
extends PIDSComponent {
    private List<PIDSComponent> components;
    private double cycleTime;
    private int currentComponents = 0;

    public CycleComponent(double x, double y, double width, double height, KVPair additionalParam) {
        super(x, y, width, height);
        this.cycleTime = additionalParam.getDouble("cycleTime", 1.0);
        this.components = new ArrayList<PIDSComponent>();
        JsonArray array = additionalParam.get("components", new JsonArray());
        for (int i = 0; i < array.size(); ++i) {
            this.components.add(PIDSComponent.parse(array.get(i).getAsJsonObject()));
        }
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, GuiDrawing guiDrawing, Direction facing, PIDSContext context) {
        if (this.cycleTime == -1.0) {
            for (PIDSComponent component : this.components) {
                if (!component.canRender(context)) continue;
                component.render(graphicsHolder, guiDrawing, facing, context);
                break;
            }
        } else {
            this.currentComponents = (int)((double)((int)(JCMClientStats.getGameTick() / 20.0 % (this.cycleTime * (double)this.components.size()))) / this.cycleTime);
            if (!this.components.isEmpty()) {
                this.components.get(this.currentComponents).render(graphicsHolder, guiDrawing, facing, context);
            }
        }
    }

    public static PIDSComponent parseComponent(double x, double y, double width, double height, JsonObject jsonObject) {
        return new CycleComponent(x, y, width, height, new KVPair(jsonObject));
    }
}

