/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.network.gui;

import com.lx862.jcm.mod.network.JCMPacketHandlerHelper;
import com.lx862.jcm.mod.network.gui.ClientHelper;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.registry.PacketHandler;
import org.mtr.mapping.tool.PacketBufferReceiver;
import org.mtr.mapping.tool.PacketBufferSender;

public class PIDSGUIPacket
extends PacketHandler {
    private final BlockPos blockPos;
    private final String[] customMessages;
    private final boolean[] rowHidden;
    private final boolean hidePlatformNumber;
    private final String presetId;

    public PIDSGUIPacket(PacketBufferReceiver packetBufferReceiver) {
        this.blockPos = BlockPos.fromLong((long)packetBufferReceiver.readLong());
        int rows = packetBufferReceiver.readInt();
        this.customMessages = new String[rows];
        this.rowHidden = new boolean[rows];
        JCMPacketHandlerHelper.readArray(packetBufferReceiver, i -> {
            this.customMessages[i.intValue()] = packetBufferReceiver.readString();
        });
        JCMPacketHandlerHelper.readArray(packetBufferReceiver, i -> {
            this.rowHidden[i.intValue()] = packetBufferReceiver.readBoolean();
        });
        this.hidePlatformNumber = packetBufferReceiver.readBoolean();
        this.presetId = packetBufferReceiver.readString();
    }

    public PIDSGUIPacket(BlockPos blockPos, String[] customMessages, boolean[] rowHidden, boolean hidePlatformNumber, String presetId) {
        this.blockPos = blockPos;
        this.customMessages = customMessages;
        this.rowHidden = rowHidden;
        this.hidePlatformNumber = hidePlatformNumber;
        this.presetId = presetId;
    }

    public void write(PacketBufferSender packetBufferSender) {
        packetBufferSender.writeLong(this.blockPos.asLong());
        packetBufferSender.writeInt(this.customMessages.length);
        JCMPacketHandlerHelper.writeArray(packetBufferSender, this.customMessages, i -> {
            String str = this.customMessages[i] == null ? "" : this.customMessages[i];
            packetBufferSender.writeString(str);
        });
        JCMPacketHandlerHelper.writeArray(packetBufferSender, this.rowHidden, i -> packetBufferSender.writeBoolean(this.rowHidden[i]));
        packetBufferSender.writeBoolean(this.hidePlatformNumber);
        packetBufferSender.writeString(this.presetId);
    }

    public void runClient() {
        ClientHelper.openPIDSGUIScreen(this.blockPos, this.customMessages, this.rowHidden, this.hidePlatformNumber, this.presetId);
    }
}

