/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.render;

import com.lx862.jcm.mod.data.Pair;
import com.lx862.jcm.mod.resources.mcmeta.McMetaManager;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.mapper.GraphicsHolder;

public interface RenderHelper {
    public static final int MAX_RENDER_LIGHT = 0xF000F0;
    public static final int ARGB_BLACK = -16777216;
    public static final int ARGB_WHITE = -1;
    public static final int ARGB_RED = -16776961;
    public static final int lineHeight = 9;

    public static void drawText(GraphicsHolder graphicsHolder, MutableText text, int x, int y, int textColor) {
        graphicsHolder.drawText(text, x, y, textColor, false, 0xF000F0);
    }

    public static void drawCenteredText(GraphicsHolder graphicsHolder, MutableText text, int x, int y, int textColor) {
        int w = GraphicsHolder.getTextWidth((MutableText)text);
        graphicsHolder.drawText(text, x - w / 2, y, textColor, false, 0xF000F0);
    }

    default public boolean inRectangle(double targetX, double targetY, int rectX, int rectY, int rectW, int rectH) {
        return targetX > (double)rectX && targetX <= (double)(rectX + rectW) && targetY > (double)rectY && targetY <= (double)(rectY + rectH);
    }

    public static void scaleToFit(GraphicsHolder graphicsHolder, int targetW, double maxW, boolean keepAspectRatio) {
        RenderHelper.scaleToFit(graphicsHolder, targetW, maxW, keepAspectRatio, 0.0);
    }

    public static void scaleToFit(GraphicsHolder graphicsHolder, double targetW, double maxW, boolean keepAspectRatio, double height) {
        height /= 2.0;
        double scaleX = Math.min(1.0, maxW / targetW);
        if (scaleX < 1.0) {
            if (keepAspectRatio) {
                graphicsHolder.translate(0.0, height / 2.0, 0.0);
                graphicsHolder.scale((float)scaleX, (float)scaleX, (float)scaleX);
                graphicsHolder.translate(0.0, -height / 2.0, 0.0);
            } else {
                graphicsHolder.scale((float)scaleX, 1.0f, 1.0f);
            }
        }
    }

    public static void drawTexture(GraphicsHolder graphicsHolder, Identifier textureId, float x, float y, float z, float width, float height, Direction facing, int color, int light) {
        Pair<Float, Float> uv = McMetaManager.getUV(textureId);
        RenderHelper.drawTextureRaw(graphicsHolder, x, y, z, x + width, y + height, z, 0.0f, uv.getLeft().floatValue(), 1.0f, uv.getRight().floatValue(), facing, color, light);
    }

    public static void drawTexture(GraphicsHolder graphicsHolder, float x, float y, float z, float width, float height, float u1, float v1, float u2, float v2, Direction facing, int color, int light) {
        RenderHelper.drawTextureRaw(graphicsHolder, x, y, z, x + width, y + height, z, u1, v1, u2, v2, facing, color, light);
    }

    public static void drawTexture(GraphicsHolder graphicsHolder, float x, float y, float z, float width, float height, Direction facing, int color, int light) {
        RenderHelper.drawTextureRaw(graphicsHolder, x, y, z, x + width, y + height, z, 0.0f, 0.0f, 1.0f, 1.0f, facing, color, light);
    }

    public static void drawTextureRaw(GraphicsHolder graphicsHolder, float x1, float y1, float z1, float x2, float y2, float z2, float u1, float v1, float u2, float v2, Direction facing, int color, int light) {
        graphicsHolder.drawTextureInWorld(x1, y2, z1, x2, y2, z2, x2, y1, z2, x1, y1, z1, u1, v1, u2, v2, facing, color, light);
    }
}

