/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.render.gui.screen;

import com.lx862.jcm.mod.data.pids.PIDSManager;
import com.lx862.jcm.mod.data.pids.preset.PIDSPresetBase;
import com.lx862.jcm.mod.render.GuiHelper;
import com.lx862.jcm.mod.render.RenderHelper;
import com.lx862.jcm.mod.render.gui.screen.base.TitledScreen;
import com.lx862.jcm.mod.render.gui.widget.ContentItem;
import com.lx862.jcm.mod.render.gui.widget.HorizontalWidgetSet;
import com.lx862.jcm.mod.render.gui.widget.ListViewWidget;
import com.lx862.jcm.mod.render.gui.widget.MappedWidget;
import com.lx862.jcm.mod.util.TextCategory;
import com.lx862.jcm.mod.util.TextUtil;
import java.util.function.Consumer;
import net.minecraft.class_339;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.Text;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mapping.mapper.GuiDrawing;
import org.mtr.mapping.mapper.TextFieldWidgetExtension;
import org.mtr.mapping.tool.HolderBase;
import org.mtr.mapping.tool.TextCase;

public class PIDSPresetScreen
extends TitledScreen
implements RenderHelper,
GuiHelper {
    private static final Identifier PIDS_PREVIEW_BASE = new Identifier("jsblock:textures/gui/pids_preview.png");
    private final TextFieldWidgetExtension searchBox;
    private final ListViewWidget listViewWidget;
    private final Consumer<String> callback;
    private final String selectedPreset;

    public PIDSPresetScreen(String selectedPreset, Consumer<String> callback) {
        super(false);
        this.callback = callback;
        this.listViewWidget = new ListViewWidget();
        this.searchBox = new TextFieldWidgetExtension(0, 0, 0, 22, 60, TextCase.DEFAULT, null, TextUtil.translatable(TextCategory.GUI, "widget.search", new Object[0]).getString());
        this.selectedPreset = selectedPreset;
    }

    protected void init2() {
        super.init2();
        int contentWidth = (int)Math.min((double)this.field_22789 * 0.75, 400.0);
        int listViewHeight = (int)((double)(this.field_22790 - 60) * 0.76);
        int startX = (this.field_22789 - contentWidth) / 2;
        int searchStartY = 50;
        int startY = searchStartY + 30;
        this.listViewWidget.reset();
        this.addConfigEntries();
        this.searchBox.setX2(startX);
        this.searchBox.setY2(searchStartY);
        this.searchBox.setWidth2(contentWidth);
        this.searchBox.setChangedListener2(string -> this.listViewWidget.setSearchTerm((String)string));
        this.listViewWidget.setXYSize(startX, startY, contentWidth, listViewHeight);
        this.addChild(new ClickableWidget((class_339)this.listViewWidget));
        this.addChild(new ClickableWidget((class_339)this.searchBox));
    }

    @Override
    public MutableText getScreenTitle() {
        return TextUtil.translatable(TextCategory.GUI, "pids_preset.title", new Object[0]);
    }

    @Override
    public MutableText getScreenSubtitle() {
        return TextUtil.translatable(TextCategory.GUI, "pids_preset.subtitle", this.selectedPreset);
    }

    public void addConfigEntries() {
        this.listViewWidget.addCategory(TextUtil.translatable(TextCategory.GUI, "pids_preset.listview.category.builtin", new Object[0]));
        for (PIDSPresetBase preset : PIDSManager.getBuiltInPresets()) {
            this.addPreset(preset);
        }
        if (!PIDSManager.getCustomPresets().isEmpty()) {
            this.listViewWidget.addCategory(TextUtil.translatable(TextCategory.GUI, "pids_preset.listview.category.custom", new Object[0]));
            for (PIDSPresetBase preset : PIDSManager.getCustomPresets()) {
                this.addPreset(preset);
            }
        }
    }

    private void addPreset(PIDSPresetBase preset) {
        ButtonWidgetExtension selectBtn = new ButtonWidgetExtension(0, 0, 60, 20, TextUtil.translatable(TextCategory.GUI, "pids_preset.listview.widget.choose", new Object[0]), btn -> this.choose(preset.getId()));
        ButtonWidgetExtension editBtn = new ButtonWidgetExtension(0, 0, 40, 20, TextUtil.translatable(TextCategory.GUI, "pids_preset.listview.widget.edit", new Object[0]), btn -> {});
        if (preset.getId().equals(this.selectedPreset)) {
            selectBtn.setMessage2(Text.cast((HolderBase)TextUtil.translatable(TextCategory.GUI, "pids_preset.listview.widget.selected", new Object[0])));
            selectBtn.field_22763 = false;
        }
        HorizontalWidgetSet widgetSet = new HorizontalWidgetSet();
        if (!preset.builtin) {
            widgetSet.addWidget(new MappedWidget(editBtn));
        }
        widgetSet.addWidget(new MappedWidget(selectBtn));
        widgetSet.setXYSize(0, 0, 100, 20);
        this.addChild(new ClickableWidget((class_339)selectBtn));
        if (!preset.builtin) {
            this.addChild(new ClickableWidget((class_339)editBtn));
        }
        this.addChild(new ClickableWidget((class_339)widgetSet));
        ContentItem contentItem = new ContentItem(TextUtil.literal(preset.getName()), new MappedWidget(widgetSet), 26);
        contentItem.setIconCallback((guiDrawing, startX, startY, width, height) -> PIDSPresetScreen.drawPIDSPreview(preset, guiDrawing, startX, startY, width, height, false));
        this.listViewWidget.add(contentItem);
    }

    public static void drawPIDSPreview(PIDSPresetBase preset, GuiDrawing guiDrawing, int startX, int startY, int width, int height, boolean backgroundOnly) {
        int offset = 6;
        GuiHelper.drawTexture(guiDrawing, PIDS_PREVIEW_BASE, startX, startY, width, height);
        if (preset == null) {
            return;
        }
        GuiHelper.drawTexture(guiDrawing, preset.getBackground(), (double)startX + 0.5, (double)(startY + 6) + 0.5, width - 1, height - 6 - 4);
        if (!backgroundOnly) {
            double perRow = (double)height / 8.5;
            double rowHeight = Math.max(0.5, (double)height / 24.0);
            for (int i = 0; i < 4; ++i) {
                if (preset.isRowHidden(i)) continue;
                double curY = (double)(startY + 6) + (double)(i + 1) * perRow;
                GuiHelper.drawRectangle(guiDrawing, (double)startX + 1.5, curY, (double)width * 0.55, rowHeight, preset.getTextColor());
                GuiHelper.drawRectangle(guiDrawing, (double)startX + (double)width * 0.65, curY, rowHeight, rowHeight, preset.getTextColor());
                GuiHelper.drawRectangle(guiDrawing, (double)startX + (double)width * 0.75, curY, (double)width * 0.2 - 0.5, rowHeight, preset.getTextColor());
            }
        }
    }

    private void choose(String id) {
        this.callback.accept(id);
        this.onClose2();
    }

    public boolean isPauseScreen2() {
        return false;
    }
}

