/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.render.gui.screen.base;

import com.lx862.jcm.mod.render.GuiHelper;
import com.lx862.jcm.mod.render.gui.screen.base.TitledScreen;
import com.lx862.jcm.mod.render.gui.widget.ListViewWidget;
import com.lx862.jcm.mod.render.gui.widget.WidgetSet;
import com.lx862.jcm.mod.util.TextCategory;
import com.lx862.jcm.mod.util.TextUtil;
import net.minecraft.class_339;
import org.mtr.core.data.Station;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.ClickableWidget;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.mapper.ButtonWidgetExtension;
import org.mtr.mod.InitClient;
import org.mtr.mod.data.IGui;

public abstract class BlockConfigScreen
extends TitledScreen
implements GuiHelper {
    protected final BlockPos blockPos;
    protected final ListViewWidget listViewWidget;
    protected final WidgetSet bottomEntryWidget;
    private final ButtonWidgetExtension saveButton;
    private final ButtonWidgetExtension discardButton;
    private boolean discardConfig = false;

    public BlockConfigScreen(BlockPos blockPos) {
        super(false);
        this.blockPos = blockPos;
        this.saveButton = new ButtonWidgetExtension(0, 0, 0, 20, TextUtil.translatable(TextCategory.GUI, "block_config.save", new Object[0]), btn -> this.onClose2());
        this.discardButton = new ButtonWidgetExtension(0, 0, 0, 20, TextUtil.translatable(TextCategory.GUI, "block_config.discard", new Object[0]), btn -> {
            this.discardConfig = true;
            this.onClose2();
        });
        this.listViewWidget = new ListViewWidget();
        this.bottomEntryWidget = new WidgetSet(20);
    }

    protected void init2() {
        super.init2();
        int contentWidth = (int)Math.min((double)this.field_22789 * 0.75, 400.0);
        int listViewHeight = Math.max(160, (int)((double)(this.field_22790 - 60) * 0.75));
        int startX = (this.field_22789 - contentWidth) / 2;
        int startY = 50;
        int bottomEntryHeight = this.field_22790 - startY - listViewHeight - 12;
        this.listViewWidget.reset();
        this.bottomEntryWidget.reset();
        this.listViewWidget.setXYSize(startX, startY, contentWidth, listViewHeight);
        this.addConfigEntries();
        this.addBottomRowButtons();
        this.addChild(new ClickableWidget((class_339)this.listViewWidget));
        this.addChild(new ClickableWidget((class_339)this.bottomEntryWidget));
        this.listViewWidget.positionWidgets();
        this.bottomEntryWidget.setXYSize(startX, startY + listViewHeight + 6, contentWidth, bottomEntryHeight);
    }

    public abstract void addConfigEntries();

    public abstract void onSave();

    protected void addBottomRowButtons() {
        this.addChild(new ClickableWidget((class_339)this.saveButton));
        this.addChild(new ClickableWidget((class_339)this.discardButton));
        this.bottomEntryWidget.addWidget(this.saveButton);
        this.bottomEntryWidget.addWidget(this.discardButton);
    }

    @Override
    public MutableText getScreenSubtitle() {
        Station atStation = InitClient.findStation((BlockPos)this.blockPos);
        if (atStation != null) {
            return TextUtil.translatable(TextCategory.GUI, "block_config.subtitle_with_station", this.blockPos.getX(), this.blockPos.getY(), this.blockPos.getZ(), IGui.formatStationName((String)atStation.getName()));
        }
        return TextUtil.translatable(TextCategory.GUI, "block_config.subtitle", this.blockPos.getX(), this.blockPos.getY(), this.blockPos.getZ());
    }

    @Override
    public void onClose2() {
        if (!this.discardConfig) {
            this.onSave();
        }
        super.onClose2();
    }

    public boolean isPauseScreen2() {
        return false;
    }
}

