/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.render.gui.screen.base;

import com.lx862.jcm.mod.render.RenderHelper;
import com.lx862.jcm.mod.render.gui.screen.base.AnimatedScreen;
import com.lx862.jcm.mod.util.TextUtil;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.MutableText;
import org.mtr.mapping.holder.TextFormatting;
import org.mtr.mapping.holder.Util;
import org.mtr.mapping.mapper.ClickableWidgetExtension;
import org.mtr.mapping.mapper.GraphicsHolder;

public abstract class TitledScreen
extends AnimatedScreen {
    public static final int TEXT_PADDING = 10;
    public static final int TITLE_SCALE = 2;
    protected double elapsed = 0.0;

    public TitledScreen(boolean animatable) {
        super(animatable);
    }

    @Override
    public void render(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float tickDelta) {
        this.drawBackground(graphicsHolder, mouseX, mouseY, tickDelta);
        this.drawTitle(graphicsHolder);
        this.drawSubtitle(graphicsHolder);
        graphicsHolder.drawText(TextUtil.literal("JCM Beta Release").formatted(TextFormatting.YELLOW), this.field_22789 - GraphicsHolder.getTextWidth((String)"JCM Beta release") - 6, 6, -1, true, GraphicsHolder.getDefaultLight());
        graphicsHolder.drawText(TextUtil.literal("Report issues here!").formatted(TextFormatting.UNDERLINE), this.field_22789 - GraphicsHolder.getTextWidth((String)"Report issues here!") - 6, 18, -1, true, GraphicsHolder.getDefaultLight());
        this.elapsed += (double)(tickDelta / 20.0f);
        super.render(graphicsHolder, mouseX, mouseY, tickDelta);
    }

    public boolean mouseClicked2(double mouseX, double mouseY, int button) {
        int x1 = this.field_22789 - GraphicsHolder.getTextWidth((String)"Report issues here!") - 6;
        int x2 = this.field_22789 - 6;
        int y1 = 18;
        int y2 = 26;
        if (button == 0 && mouseX >= (double)x1 && mouseX <= (double)x2 && mouseY >= (double)y1 && mouseY <= (double)y2) {
            Util.getOperatingSystem().open("https://github.com/DistrictOfJoban/Joban-Client-Mod/issues");
            new ClickableWidgetExtension(0, 0, 0, 0).playDownSound2(MinecraftClient.getInstance().getSoundManager());
        }
        return super.mouseClicked2(mouseX, mouseY, button);
    }

    public abstract MutableText getScreenTitle();

    public abstract MutableText getScreenSubtitle();

    public void drawBackground(GraphicsHolder graphicsHolder, int mouseX, int mouseY, float tickDelta) {
        super.renderBackground(graphicsHolder);
    }

    private void drawTitle(GraphicsHolder graphicsHolder) {
        int titleHeight = 18;
        MutableText titleText = this.getScreenTitle();
        graphicsHolder.push();
        graphicsHolder.translate((double)this.field_22789 / 2.0, 10.0, 0.0);
        graphicsHolder.translate(0.0, -((double)(titleHeight + 10) * (1.0 - this.animationProgress)), 0.0);
        graphicsHolder.scale(2.0f, 2.0f, 2.0f);
        RenderHelper.scaleToFit(graphicsHolder, GraphicsHolder.getTextWidth((MutableText)titleText), this.field_22789 / 2, true);
        graphicsHolder.drawCenteredText(titleText, 0, 0, -1);
        graphicsHolder.pop();
    }

    private void drawSubtitle(GraphicsHolder graphicsHolder) {
        double titleHeight = 18.0;
        MutableText subtitleText = this.getScreenSubtitle();
        graphicsHolder.push();
        graphicsHolder.translate((double)this.field_22789 / 2.0, titleHeight * this.animationProgress, 0.0);
        graphicsHolder.translate(0.0, 15.0, 0.0);
        RenderHelper.scaleToFit(graphicsHolder, GraphicsHolder.getTextWidth((MutableText)subtitleText), this.field_22789, true);
        graphicsHolder.drawCenteredText(subtitleText, 0, 0, -1);
        graphicsHolder.pop();
    }
}

