/*
 * Decompiled with CFR 0.152.
 */
package com.lx862.jcm.mod.render.text.font;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.lx862.jcm.mod.render.text.font.NoTTFFontException;
import com.lx862.jcm.mod.util.JCMLogger;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.geom.RectangularShape;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.mapper.ResourceManagerHelper;

public class FontSet {
    private final List<Font> fontList = new ArrayList<Font>();

    public FontSet(Font ... fonts) {
        for (int i = 0; i < fonts.length; ++i) {
            this.fontList.add(fonts[i]);
        }
    }

    public FontSet(JsonObject vanillaFontJson) throws NoTTFFontException {
        this(new Font[0]);
        JsonArray fonts = vanillaFontJson.getAsJsonArray("providers");
        boolean hasTTFFont = false;
        for (int i = 0; i < fonts.size(); ++i) {
            JsonObject fontJson = fonts.get(i).getAsJsonObject();
            String type = fontJson.get("type").getAsString();
            if (!type.equals("ttf")) continue;
            hasTTFFont = true;
            String fontFile = fontJson.get("file").getAsString();
            Identifier fontFileId = new Identifier(fontFile);
            String fontFilePath = "font/" + fontFileId.getPath();
            this.readFontFile(new Identifier(fontFileId.getNamespace(), fontFilePath), this.fontList::add);
        }
        if (!hasTTFFont) {
            throw new NoTTFFontException();
        }
    }

    private void readFontFile(Identifier path, Consumer<Font> callback) {
        ResourceManagerHelper.readResource((Identifier)path, inputStream -> {
            try {
                Font createdFont = Font.createFont(0, inputStream);
                callback.accept(createdFont);
            }
            catch (Exception e) {
                JCMLogger.warn("Failed to load font from path " + path.getPath(), new Object[0]);
                e.printStackTrace();
            }
        });
    }

    public AttributedString getAttributedString(String string, AttributedString attributedString, int fontResolution) {
        block0: for (int i = 0; i < string.length(); ++i) {
            for (Font font : this.fontList) {
                if (!font.canDisplay(string.charAt(i))) continue;
                attributedString.addAttribute(TextAttribute.FONT, font.deriveFont(0, fontResolution), i, i + 1);
                continue block0;
            }
        }
        return attributedString;
    }

    public GlyphVector getTallestGlyphVector(AttributedCharacterIterator iterator, FontRenderContext frc, int fontSize) {
        Font largestFont = null;
        GlyphVector largestGv = null;
        double largestHeight = 0.0;
        while (iterator.getIndex() < iterator.getEndIndex()) {
            GlyphVector gv;
            Rectangle bound;
            double height;
            Font font = (Font)iterator.getAttribute(TextAttribute.FONT);
            if (font != largestFont && (height = ((RectangularShape)(bound = (gv = font.deriveFont(0, fontSize).createGlyphVector(frc, "a!1b")).getOutline().getBounds())).getHeight()) > largestHeight) {
                largestHeight = height;
                largestGv = gv;
                largestFont = font;
            }
            iterator.next();
        }
        return largestGv;
    }

    public Font getPrimaryFont(int fontSize) {
        return this.fontList.get(0).deriveFont(fontSize);
    }
}

