/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.jsblock.block;

import fabric.com.jsblock.BlockEntityTypes;
import fabric.com.jsblock.packet.PacketServer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import mtr.MTR;
import mtr.block.IBlock;
import mtr.data.DataCache;
import mtr.data.Platform;
import mtr.data.RailwayData;
import mtr.data.ScheduleEntry;
import mtr.mappings.BlockDirectionalMapper;
import mtr.mappings.BlockEntityClientSerializableMapper;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.mappings.TickableMapper;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;

public class ButterflyLight
extends BlockDirectionalMapper
implements EntityBlockMapper {
    public static final class_2746 LIT = class_2746.method_11825((String)"lit");

    public ButterflyLight(class_4970.class_2251 blockProperties) {
        super(blockProperties);
    }

    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)ctx.method_8042())).method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false));
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!world.method_8608()) {
            class_2586 entity = world.method_8321(pos);
            if (!(entity instanceof TileEntityButterFlyLight)) {
                return class_1269.field_5814;
            }
            IBlock.checkHoldingBrush((class_1937)world, (class_1657)player, () -> PacketServer.sendButterflyConfigScreenS2C((class_3222)player, pos, ((TileEntityButterFlyLight)entity).getSecondsToBlink()));
        }
        return class_1269.field_5812;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 facing = (class_2350)IBlock.getStatePropertySafe((class_2680)state, (class_2769)field_11177);
        return IBlock.getVoxelShapeByDirection((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)5.8, (double)10.0, (class_2350)facing);
    }

    public class_2591<? extends BlockEntityMapper> getType() {
        return (class_2591)BlockEntityTypes.BUTTERFLY_LIGHT_TILE_ENTITY.get();
    }

    public <T extends BlockEntityMapper> void tick(class_1937 world, class_2338 pos, T blockEntity) {
        ((TileEntityButterFlyLight)blockEntity).tick(world, pos);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11177, LIT});
    }

    public BlockEntityMapper createBlockEntity(class_2338 pos, class_2680 state) {
        return new TileEntityButterFlyLight(pos, state);
    }

    public static class TileEntityButterFlyLight
    extends BlockEntityClientSerializableMapper
    implements TickableMapper {
        private int secondsToBlink = 10;
        private static final String KEY_SECONDS_TO_BLINK = "seconds_to_blink";

        public TileEntityButterFlyLight(class_2338 pos, class_2680 state) {
            super((class_2591)BlockEntityTypes.BUTTERFLY_LIGHT_TILE_ENTITY.get(), pos, state);
        }

        public void readCompoundTag(class_2487 compoundTag) {
            this.secondsToBlink = compoundTag.method_10550(KEY_SECONDS_TO_BLINK);
            super.readCompoundTag(compoundTag);
        }

        public void writeCompoundTag(class_2487 compoundTag) {
            compoundTag.method_10569(KEY_SECONDS_TO_BLINK, this.secondsToBlink);
            super.writeCompoundTag(compoundTag);
        }

        public void setData(int secondsToBlink) {
            this.secondsToBlink = secondsToBlink;
            this.method_5431();
            this.syncData();
        }

        public int getSecondsToBlink() {
            return this.secondsToBlink;
        }

        public void tick() {
            this.tick(this.field_11863, this.field_11867);
        }

        public <T extends BlockEntityMapper> void tick(class_1937 world, class_2338 pos) {
            if (MTR.isGameTickInterval((int)20) && world != null && !world.field_9236) {
                class_2680 state = world.method_8320(pos);
                RailwayData railwayData = RailwayData.getInstance((class_1937)world);
                boolean lastBlockLit = (Boolean)IBlock.getStatePropertySafe((class_2680)state, (class_2769)LIT);
                if (railwayData != null) {
                    int seconds;
                    long platformId = RailwayData.getClosePlatformId((Set)railwayData.platforms, (DataCache)railwayData.dataCache, (class_2338)pos, (int)5, (int)3, (int)3);
                    if (platformId == 0L) {
                        if (lastBlockLit) {
                            world.method_8501(pos, (class_2680)state.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false)));
                        }
                        return;
                    }
                    List schedules = railwayData.getSchedulesAtPlatform(platformId);
                    if (schedules == null || schedules.isEmpty()) {
                        if (lastBlockLit) {
                            world.method_8501(pos, (class_2680)state.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false)));
                        }
                        return;
                    }
                    ArrayList scheduleList = new ArrayList(schedules);
                    Collections.sort(scheduleList);
                    if (((ScheduleEntry)scheduleList.get((int)0)).arrivalMillis - System.currentTimeMillis() > 0L) {
                        if (lastBlockLit) {
                            world.method_8501(pos, (class_2680)state.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false)));
                        }
                        return;
                    }
                    int remainingSecond = (int)(((ScheduleEntry)scheduleList.get((int)0)).arrivalMillis - System.currentTimeMillis()) / 1000;
                    Platform platform = (Platform)railwayData.dataCache.platformIdMap.get(platformId);
                    int n = seconds = platform == null ? 0 : platform.getDwellTime() / 2 - Math.abs(remainingSecond);
                    if (!lastBlockLit && seconds < this.secondsToBlink) {
                        world.method_8501(pos, (class_2680)state.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(true)));
                    }
                }
            }
        }
    }
}

