/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.jsblock.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import net.minecraft.class_2960;

public class PIDSPreset {
    public class_2960 image;
    public Integer color;
    public String font;
    private Int2IntArrayMap carLengthColorMap;
    public boolean[] visibility;
    public boolean customTextPushArrival;
    public boolean showWeather;
    public boolean showClock;

    public PIDSPreset(class_2960 image, boolean showWeather, boolean showClock, boolean customTextPushArrival, boolean[] visibility, Integer color, String font, Int2IntArrayMap carLengthColorMap) {
        this.image = image;
        this.showWeather = showWeather;
        this.showClock = showClock;
        this.visibility = visibility;
        this.color = color;
        this.font = font;
        this.customTextPushArrival = customTextPushArrival;
        this.carLengthColorMap = carLengthColorMap;
    }

    public static PIDSPreset fromJson(JsonElement element) {
        int i;
        boolean[] hideRowArray = new boolean[4];
        boolean showWeather = element.getAsJsonObject().has("showWeather") ? element.getAsJsonObject().get("showWeather").getAsBoolean() : true;
        boolean showClock = element.getAsJsonObject().has("showClock") ? element.getAsJsonObject().get("showClock").getAsBoolean() : true;
        boolean customTextPushArrival = element.getAsJsonObject().has("customTextPushArrival") && element.getAsJsonObject().get("customTextPushArrival").getAsBoolean();
        String fonts = element.getAsJsonObject().has("fonts") ? element.getAsJsonObject().get("fonts").getAsString() : null;
        String hexColor = element.getAsJsonObject().has("color") ? element.getAsJsonObject().get("color").getAsString() : null;
        JsonArray carLengthColor = element.getAsJsonObject().has("carLengthColor") ? element.getAsJsonObject().get("carLengthColor").getAsJsonArray() : null;
        JsonArray hiddenRowList = element.getAsJsonObject().has("hideRow") ? element.getAsJsonObject().get("hideRow").getAsJsonArray() : null;
        class_2960 background = new class_2960(element.getAsJsonObject().get("background").getAsString());
        Int2IntArrayMap carLengthColorMap = null;
        Integer color = null;
        if (hexColor != null) {
            color = Integer.parseInt(hexColor, 16);
        }
        if (hiddenRowList != null) {
            for (i = 0; i < Math.min(hiddenRowList.size(), hideRowArray.length); ++i) {
                hideRowArray[i] = hiddenRowList.get(i).getAsBoolean();
            }
        } else {
            hideRowArray = null;
        }
        if (carLengthColor != null) {
            carLengthColorMap = new Int2IntArrayMap();
            for (i = 0; i < carLengthColor.size(); ++i) {
                JsonElement colorElement = carLengthColor.get(i);
                if (colorElement.isJsonNull()) continue;
                carLengthColorMap.put(i, Integer.parseInt(colorElement.getAsString(), 16));
            }
        }
        return new PIDSPreset(background, showWeather, showClock, customTextPushArrival, hideRowArray, color, fonts, carLengthColorMap);
    }

    public Integer getCarColor(int car) {
        if (this.carLengthColorMap == null || !this.carLengthColorMap.containsKey(car - 1)) {
            return null;
        }
        return this.carLengthColorMap.get(car - 1);
    }
}

