/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.jsblock.render;

import fabric.com.jsblock.data.PIDSPreset;
import fabric.com.jsblock.render.RenderPIDSBase;
import fabric.com.jsblock.screen.IDrawingJoban;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import mtr.MTRClient;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.data.DataCache;
import mtr.data.IGui;
import mtr.data.Platform;
import mtr.data.RailwayData;
import mtr.data.Route;
import mtr.data.ScheduleEntry;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.render.MoreRenderLayers;
import mtr.render.RenderTrains;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2769;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_824;

public class RenderRVPIDS<T extends BlockEntityMapper>
extends RenderPIDSBase<T>
implements IGui {
    private static final float BACKGROUND_WIDTH = 119.0f;
    private static final float BACKGROUND_HEIGHT = 65.8f;
    private static final float BACKGROUND_Y = -9.5f;
    private static final double OVERLAY_DISTANCE = 0.1;
    private final float scale;
    private final float totalScaledWidth;
    private final float destinationStart;
    private final float destinationMaxWidth;
    private final float platformMaxWidth;
    private final float arrivalMaxWidth;
    private final int maxArrivals;
    private final float maxHeight;
    private final float startX;
    private final float startY;
    private final float startZ;
    private final boolean rotate90;
    private final int defaultTextColor;
    private final float rotation;
    private static final String defaultFont = "mtr:mtr";
    private final PIDSPreset DEFAULT_PRESET = new PIDSPreset(new class_2960("jsblock", "textures/block/pids_rv_screen.png"), true, true, false, SHOW_ALL_ROWS, 0, null, null);

    public RenderRVPIDS(class_824 dispatcher, int maxArrivals, float startX, float startY, float startZ, float maxHeight, float maxWidth, boolean rotate90, boolean renderArrivalNumber, int textColor, float rotation) {
        super(dispatcher, maxArrivals);
        this.scale = (float)(230 * maxArrivals) / maxHeight;
        this.totalScaledWidth = this.scale * maxWidth / 16.0f;
        this.destinationStart = renderArrivalNumber ? this.scale * 2.0f / 16.0f : 0.0f;
        this.destinationMaxWidth = this.totalScaledWidth * 0.3f;
        this.platformMaxWidth = this.scale * 2.0f / 16.0f;
        this.arrivalMaxWidth = this.totalScaledWidth - this.destinationStart - this.destinationMaxWidth - this.platformMaxWidth;
        this.maxArrivals = maxArrivals;
        this.maxHeight = maxHeight;
        this.startX = startX;
        this.startY = startY;
        this.startZ = startZ;
        this.rotate90 = rotate90;
        this.defaultTextColor = textColor;
        this.rotation = rotation;
    }

    @Override
    public void render(T entity, class_1937 world, String[] customMessages, boolean[] hideArrivals, boolean hidePlatforms, PIDSPreset preset, List<Long> filteredPlatformIds, float delta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_2338 pos = entity.method_11016();
        class_2350 facing = (class_2350)IBlock.getStatePropertySafe((class_1922)world, (class_2338)pos, (class_2769)class_2383.field_11177);
        try {
            class_327 textRenderer = class_310.method_1551().field_1772;
            PIDSPreset pidsPreset = preset == null ? this.DEFAULT_PRESET : preset;
            String textFont = pidsPreset.font == null ? defaultFont : pidsPreset.font;
            int textColor = pidsPreset.color == null ? this.defaultTextColor : pidsPreset.color;
            int languageTicks = (int)Math.floor(MTRClient.getGameTick()) / 80;
            ArrayList scheduleList = new ArrayList();
            if (!filteredPlatformIds.isEmpty()) {
                for (long platformId : filteredPlatformIds) {
                    Set schedulesForPlatform = (Set)ClientData.SCHEDULES_FOR_PLATFORM.get(platformId);
                    if (schedulesForPlatform == null) continue;
                    scheduleList.addAll(schedulesForPlatform);
                }
            } else {
                long closestPlatformId = RailwayData.getClosePlatformId((Set)ClientData.PLATFORMS, (DataCache)ClientData.DATA_CACHE, (class_2338)pos);
                Set schedulesForPlatform = (Set)ClientData.SCHEDULES_FOR_PLATFORM.get(closestPlatformId);
                if (schedulesForPlatform != null) {
                    scheduleList.addAll(schedulesForPlatform);
                }
            }
            class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
            Collections.sort(scheduleList);
            int maxCars = 0;
            int minCars = Integer.MAX_VALUE;
            for (ScheduleEntry scheduleEntry : scheduleList) {
                int trainCars = scheduleEntry.trainCars;
                if (trainCars > maxCars) {
                    maxCars = trainCars;
                }
                if (trainCars >= minCars) continue;
                minCars = trainCars;
            }
            boolean showCarLength = minCars != maxCars;
            matrices.method_22903();
            matrices.method_22904(0.5, 0.0, 0.5);
            UtilitiesClient.rotateYDegrees((class_4587)matrices, (float)((float)(this.rotate90 ? 90 : 0) - facing.method_10144()));
            UtilitiesClient.rotateZDegrees((class_4587)matrices, (float)180.0f);
            UtilitiesClient.rotateXDegrees((class_4587)matrices, (float)this.rotation);
            matrices.method_46416((this.startX - 8.0f) / 16.0f, -this.startY / 16.0f, (this.startZ - 8.0f) / 16.0f - 0.00625f);
            matrices.method_22905(1.0f / this.scale, 1.0f / this.scale, 1.0f / this.scale);
            class_4588 vertexConsumerBackground = vertexConsumers.getBuffer(MoreRenderLayers.getLight((class_2960)pidsPreset.image, (boolean)false));
            matrices.method_22904(0.0, -9.5, 0.01);
            RenderRVPIDS.drawTexture(matrices, vertexConsumerBackground, this.startX - 13.0f, -1.5f, 119.0f, 65.8f, facing, -1, 0xF000F0);
            if (RenderTrains.shouldNotRender((class_2338)pos, (int)Math.min(16, RenderTrains.maxTrainRenderDistance), (class_2350)(this.rotate90 ? null : facing))) {
                matrices.method_22909();
                return;
            }
            if (pidsPreset.showClock) {
                this.renderClock(matrices, textRenderer, immediate, world, textFont);
            }
            if (pidsPreset.showWeather) {
                this.renderWeather(matrices, vertexConsumers, world, facing);
            }
            matrices.method_22909();
            int entryIndex = 0;
            for (int i = 0; i < this.maxArrivals; ++i) {
                boolean useCustomMessage;
                Object destinationString;
                Route route;
                ScheduleEntry currentSchedule = entryIndex < scheduleList.size() ? (ScheduleEntry)scheduleList.get(entryIndex) : null;
                Route route2 = route = currentSchedule == null ? null : (Route)ClientData.DATA_CACHE.routeIdMap.get(currentSchedule.routeId);
                if (entryIndex < scheduleList.size() && !hideArrivals[i] && route != null) {
                    destinationSplit = ClientData.DATA_CACHE.getFormattedRouteDestination(route, currentSchedule.currentStationIndex, "").split("\\|");
                    boolean isLightRailRoute = route.isLightRailRoute;
                    String[] routeNumberSplit = route.lightRailRouteNumber.split("\\|");
                    if (customMessages[i].isEmpty()) {
                        destinationString = (String)(isLightRailRoute ? routeNumberSplit[languageTicks % routeNumberSplit.length] + " " : "") + IGui.textOrUntitled((String)destinationSplit[languageTicks % destinationSplit.length]);
                        useCustomMessage = false;
                    } else {
                        String[] customMessageSplit = customMessages[i].split("\\|");
                        int destinationMaxIndex = Math.max(routeNumberSplit.length, destinationSplit.length);
                        int indexToUse = languageTicks % (destinationMaxIndex + customMessageSplit.length);
                        if (indexToUse < destinationMaxIndex) {
                            destinationString = (String)(isLightRailRoute ? routeNumberSplit[languageTicks % routeNumberSplit.length] + " " : "") + IGui.textOrUntitled((String)destinationSplit[languageTicks % destinationSplit.length]);
                            useCustomMessage = false;
                        } else {
                            destinationString = customMessageSplit[indexToUse - destinationMaxIndex];
                            useCustomMessage = true;
                        }
                    }
                } else {
                    destinationSplit = customMessages[i].split("\\|");
                    destinationString = destinationSplit[languageTicks % destinationSplit.length];
                    useCustomMessage = true;
                }
                matrices.method_22903();
                matrices.method_22904(0.5, 0.0, 0.5);
                UtilitiesClient.rotateYDegrees((class_4587)matrices, (float)((float)(this.rotate90 ? 90 : 0) - facing.method_10144()));
                UtilitiesClient.rotateZDegrees((class_4587)matrices, (float)180.0f);
                UtilitiesClient.rotateXDegrees((class_4587)matrices, (float)this.rotation);
                matrices.method_46416((this.startX - 8.0f) / 16.0f, -this.startY / 16.0f + (float)i * this.maxHeight / (float)this.maxArrivals / 16.0f, (this.startZ - 8.0f) / 16.0f - 0.0125f);
                matrices.method_22905(1.0f / (this.scale / 2.0f), 1.0f / (this.scale / 2.0f), 1.0f / (this.scale / 2.0f));
                if (useCustomMessage) {
                    IDrawingJoban.renderTextWithOffset(matrices, textRenderer, immediate, (String)destinationString, 0.0f, 0.0f, this.arrivalMaxWidth - this.platformMaxWidth, 4.0f, textColor, 0xF000F0, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.TOP, false, textFont);
                } else {
                    class_5250 arrivalText;
                    int seconds = (int)Math.round((double)(currentSchedule.arrivalMillis - System.currentTimeMillis()) / 1000.0);
                    boolean isCJK = IGui.isCjk((String)destinationString);
                    if (seconds >= 60) {
                        arrivalText = Text.translatable((String)(isCJK ? "gui.mtr.arrival_min_cjk" : "gui.mtr.arrival_min"), (Object[])new Object[]{seconds / 60});
                    } else {
                        class_5250 class_52502 = seconds > 0 ? Text.translatable((String)(isCJK ? "gui.mtr.arrival_sec_cjk" : "gui.mtr.arrival_sec"), (Object[])new Object[]{seconds}) : (arrivalText = null);
                    }
                    if (!hidePlatforms) {
                        class_4588 vertexConsumerStationCircle = vertexConsumers.getBuffer(MoreRenderLayers.getLight((class_2960)new class_2960("mtr:textures/block/sign/circle.png"), (boolean)true));
                        long platformId = currentSchedule.currentStationIndex < route.platformIds.size() ? ((Route.RoutePlatform)route.platformIds.get((int)currentSchedule.currentStationIndex)).platformId : 0L;
                        Platform platform = (Platform)ClientData.DATA_CACHE.platformIdMap.get(platformId);
                        if (platform != null) {
                            float x = this.destinationStart + this.destinationMaxWidth;
                            RenderRVPIDS.drawTexture(matrices, vertexConsumerStationCircle, x, 0.0f, 4.0f, 4.0f, facing, route.color + -16777216, 0xF000F0);
                            matrices.method_22903();
                            matrices.method_22904((double)(x + 1.95f), (double)2.2f, -0.05);
                            matrices.method_22905(0.7f, 0.7f, 0.7f);
                            IDrawingJoban.renderTextWithOffset(matrices, textRenderer, immediate, platform.name, 0.0f, 0.0f, 4.0f, 3.0f, -1, 0xF000F0, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, true, textFont);
                            matrices.method_22909();
                        }
                    }
                    matrices.method_22903();
                    matrices.method_46416(this.destinationStart, 0.0f, 0.0f);
                    IDrawingJoban.renderTextWithOffset(matrices, textRenderer, immediate, (String)destinationString, 0.0f, 0.0f, 30.0f, 5.0f, textColor, 0xF000F0, IGui.HorizontalAlignment.LEFT, IGui.VerticalAlignment.TOP, false, textFont);
                    matrices.method_22909();
                    if (arrivalText != null) {
                        boolean isShowCar = showCarLength && (languageTicks % 6 == 0 || languageTicks % 6 == 1);
                        matrices.method_22903();
                        matrices.method_46416(this.arrivalMaxWidth - this.platformMaxWidth, 0.0f, 0.0f);
                        if (isShowCar) {
                            class_5250 carText = Text.translatable((String)(isCJK ? "gui.mtr.arrival_car_cjk" : "gui.mtr.arrival_car"), (Object[])new Object[]{currentSchedule.trainCars});
                            Integer carColor = pidsPreset.getCarColor(currentSchedule.trainCars);
                            IDrawingJoban.renderTextWithOffset(matrices, textRenderer, immediate, carText.getString(), 0.0f, -0.025f, 15.0f, 5.0f, carColor == null ? textColor : carColor, 0xF000F0, IGui.HorizontalAlignment.RIGHT, IGui.VerticalAlignment.TOP, false, textFont);
                        } else {
                            IDrawingJoban.renderTextWithOffset(matrices, textRenderer, immediate, arrivalText.getString(), 0.0f, -0.025f, 15.0f, 5.0f, textColor, 0xF000F0, IGui.HorizontalAlignment.RIGHT, IGui.VerticalAlignment.TOP, false, textFont);
                        }
                        matrices.method_22909();
                    }
                }
                matrices.method_22909();
                if (hideArrivals[i] || useCustomMessage && pidsPreset.customTextPushArrival) continue;
                ++entryIndex;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void renderWeather(class_4587 matrices, class_4597 vertexConsumers, class_1937 world, class_2350 blockFacing) {
        class_2960 weatherTexture = world.method_8546() ? new class_2960("jsblock:textures/block/weather_thunder.png") : (world.method_8419() ? new class_2960("jsblock:textures/block/weather_rainy.png") : new class_2960("jsblock:textures/block/weather_sunny.png"));
        class_4588 vertexConsumerWeather = vertexConsumers.getBuffer(MoreRenderLayers.getLight((class_2960)weatherTexture, (boolean)false));
        matrices.method_22903();
        matrices.method_22904((double)(this.startX - 9.0f), (double)(-this.startY / 16.0f), -0.1);
        RenderRVPIDS.drawTexture(matrices, vertexConsumerWeather, 0.0f, -0.5f, 8.0f, 8.0f, blockFacing, -1, 0xF000F0);
        matrices.method_22909();
    }

    private void renderClock(class_4587 matrices, class_327 textRenderer, class_4597.class_4598 immediate, class_1937 world, String font) {
        long time = world.method_8532() + 6000L;
        long hours = time / 1000L;
        long minutes = Math.round((double)(time - hours * 1000L) / 16.8);
        String timeString = String.format("%02d:%02d", hours % 24L, minutes % 60L);
        matrices.method_22903();
        matrices.method_22904(119.0, 0.0, -0.1);
        matrices.method_46416((this.startX - 26.0f) / 2.0f, -this.startY / 16.0f, 0.0f);
        matrices.method_22905(1.6f, 1.6f, 1.6f);
        IDrawingJoban.renderTextWithOffset(matrices, textRenderer, immediate, timeString, 0.0f, 0.0f, 12.0f, 2.0f, -1, 0xF000F0, IGui.HorizontalAlignment.RIGHT, IGui.VerticalAlignment.TOP, false, font);
        matrices.method_22909();
    }
}

