/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.jsblock.screen;

import fabric.com.jsblock.Joban;
import fabric.com.jsblock.client.ClientConfig;
import fabric.com.jsblock.data.InlineComponentEntry;
import fabric.com.jsblock.data.ScreenAlignment;
import fabric.com.jsblock.data.ScreenRoot;
import fabric.com.jsblock.data.TextLabel;
import fabric.com.jsblock.screen.ConfigScreenBase;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import mtr.data.IGui;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_4185;

public class ConfigScreen
extends ConfigScreenBase
implements IGui {
    private boolean enableRendering;
    private boolean ignoreVerCheck;
    private boolean debugMode;
    private boolean initalized;
    private static final class_2561 TITLE_TEXT = Text.translatable((String)"gui.jsblock.brand", (Object[])new Object[0]);
    private static final class_2561 VERSION_TEXT = Text.translatable((String)"gui.jsblock.version", (Object[])new Object[]{Joban.getVersion()});

    public ConfigScreen() {
        super(new ScreenRoot(ScreenAlignment.HORZ_CENTER, 1.25f, 1.0f), new TextLabel(TITLE_TEXT, 2.0f, ScreenAlignment.HORZ_CENTER, 6), new TextLabel(VERSION_TEXT, 1.0f, ScreenAlignment.HORZ_CENTER, 6));
    }

    @Override
    protected void method_25426() {
        if (!this.initalized) {
            this.initalized = true;
            this.enableRendering = ClientConfig.getRenderDisabled();
            this.ignoreVerCheck = ClientConfig.getVersionCheckDisabled();
            this.debugMode = ClientConfig.getDebugModeEnabled();
            this.registerConfigRowButton(Text.translatable((String)"gui.jsblock.config.enable_render", (Object[])new Object[0]), ConfigScreen.getBooleanButtonText(this.enableRendering), button -> {
                this.enableRendering = ClientConfig.setRenderDisabled(!this.enableRendering);
                button.method_25355(ConfigScreen.getBooleanButtonText(this.enableRendering));
            });
            this.registerConfigRowButton(Text.translatable((String)"gui.jsblock.config.ignore_ver_check", (Object[])new Object[0]), ConfigScreen.getBooleanButtonText(this.ignoreVerCheck), button -> {
                this.ignoreVerCheck = ClientConfig.setVersionCheckDisabled(!this.ignoreVerCheck);
                button.method_25355(ConfigScreen.getBooleanButtonText(this.ignoreVerCheck));
            });
            this.registerConfigRowButton(Text.translatable((String)"gui.jsblock.config.debug_mode", (Object[])new Object[0]), ConfigScreen.getBooleanButtonText(this.debugMode), button -> {
                this.debugMode = ClientConfig.setDebugMode(!this.debugMode);
                button.method_25355(ConfigScreen.getBooleanButtonText(this.debugMode));
            });
            class_4185 saveButton = UtilitiesClient.newButton((class_2561)Text.translatable((String)"gui.jsblock.config.save", (Object[])new Object[0]), button1 -> this.closeScreen(true));
            class_4185 discardButton = UtilitiesClient.newButton((class_2561)Text.translatable((String)"gui.jsblock.config.discard", (Object[])new Object[0]), button1 -> this.closeScreen(false));
            class_4185 resetButton = UtilitiesClient.newButton((class_2561)Text.translatable((String)"gui.jsblock.config.reset", (Object[])new Object[0]), button1 -> {
                ClientConfig.setRenderDisabled(false);
                ClientConfig.setVersionCheckDisabled(false);
                ClientConfig.setDebugMode(false);
                this.closeScreen(true);
            });
            class_4185 latestLogButton = UtilitiesClient.newButton((class_2561)Text.translatable((String)"gui.jsblock.config.openlog", (Object[])new Object[0]), button1 -> this.showLog());
            class_4185 crashLogButton = UtilitiesClient.newButton((class_2561)Text.translatable((String)"gui.jsblock.config.opencrashlog", (Object[])new Object[0]), button1 -> this.showCrashLog());
            InlineComponentEntry inlineRowConfig = new InlineComponentEntry(ScreenAlignment.HORZ_CENTER, ScreenAlignment.VERT_BOTTOM, new class_339[]{saveButton, discardButton, resetButton});
            InlineComponentEntry inlineRowLogs = new InlineComponentEntry(ScreenAlignment.HORZ_CENTER, ScreenAlignment.VERT_BOTTOM, new class_339[]{latestLogButton, crashLogButton});
            this.registerInlineRow(inlineRowLogs, inlineRowConfig);
        }
        super.method_25426();
    }

    private void showLog() {
        File latestLog = Paths.get(this.field_22787.field_1697.toString(), "logs", "latest.log").toFile();
        if (latestLog.exists()) {
            class_156.method_668().method_672(latestLog);
        }
    }

    private void showCrashLog() {
        Path logDir = Paths.get(this.field_22787.field_1697.toString(), "crash-reports");
        if (Files.exists(logDir, new LinkOption[0])) {
            File[] crashLogList = logDir.toFile().listFiles();
            if (crashLogList != null && crashLogList.length > 0) {
                Arrays.sort(crashLogList, Comparator.comparingLong(File::lastModified));
                class_156.method_668().method_672(crashLogList[0]);
            } else {
                class_370 errorToast = class_370.method_29047((class_310)this.field_22787, (class_370.class_371)class_370.class_371.field_2218, (class_2561)Text.translatable((String)"gui.jsblock.brand", (Object[])new Object[0]), (class_2561)Text.translatable((String)"gui.jsblock.config.nocrashlogfound", (Object[])new Object[0]));
                this.field_22787.method_1566().method_1999((class_368)errorToast);
            }
        }
    }

    @Override
    public void onSave() {
        try {
            ClientConfig.writeConfig();
        }
        catch (Exception e) {
            class_370 errorToast = class_370.method_29047((class_310)this.field_22787, (class_370.class_371)class_370.class_371.field_2218, (class_2561)Text.translatable((String)"gui.jsblock.brand", (Object[])new Object[0]), (class_2561)Text.translatable((String)"gui.jsblock.config.savefailed", (Object[])new Object[0]));
            this.field_22787.method_1566().method_1999((class_368)errorToast);
        }
        super.method_25419();
    }
}

