/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.jsblock.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import fabric.com.jsblock.data.ConfigGuiEntry;
import fabric.com.jsblock.data.InlineComponentEntry;
import fabric.com.jsblock.data.ScreenAlignment;
import fabric.com.jsblock.data.ScreenRoot;
import fabric.com.jsblock.data.TextLabel;
import fabric.com.jsblock.vermappings.render.RenderHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.data.RailwayData;
import mtr.mappings.ScreenMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.joml.Quaternionf;

public class ConfigScreenBase
extends ScreenMapper
implements IGui {
    private double elapsedTime;
    private final List<InlineComponentEntry> inlineComponentList;
    private final List<ConfigGuiEntry> configList;
    private final List<TextLabel> customText;
    private final ScreenRoot screenRoot;
    private boolean initalized;
    public static final int BUTTON_HEIGHT = 20;
    private static final int TRANSITION_DURATION = 20;
    private static final int TEXT_PADDING = 12;
    private static final int CONFIG_BUTTON_WIDTH = 60;
    private static final int TEXT_FIELD_WIDTH = 100;
    private static final int FINAL_TEXT_HEIGHT = 20;
    private static final int MAX_TEXT_LENGTH = 128;
    private static final class_2960 BACKGROUND = new class_2960("jsblock:textures/gui/background/bg.png");
    private static final class_2960 STAR_BACKGROUND = new class_2960("jsblock:textures/gui/background/stars.png");
    private static final class_2960 TERRAIN_BACKGROUND = new class_2960("jsblock:textures/gui/background/terrain.png");

    public ConfigScreenBase(ScreenRoot root, TextLabel ... customText) {
        super((class_2561)Text.literal((String)""));
        this.screenRoot = root;
        this.inlineComponentList = new ArrayList<InlineComponentEntry>();
        this.customText = new ArrayList<TextLabel>();
        this.configList = new ArrayList<ConfigGuiEntry>();
        this.customText.addAll(Arrays.asList(customText));
    }

    public class_339 registerConfigRowButton(class_5250 description, class_2561 defaultMessage, Consumer<class_339> onClick) {
        class_4185 button = UtilitiesClient.newButton((class_2561)Text.literal((String)""), onClick::accept);
        button.method_25355(defaultMessage);
        this.configList.add(new ConfigGuiEntry(description, (class_339)button, 60, 20));
        return button;
    }

    public void registerInlineRow(InlineComponentEntry ... entries) {
        this.inlineComponentList.addAll(Arrays.asList(entries));
    }

    /*
     * WARNING - void declaration
     */
    protected void method_25426() {
        void var4_7;
        super.method_25426();
        int i = 0;
        int startY = 0;
        for (TextLabel textLabel : this.customText) {
            startY += (int)(textLabel.y * (double)textLabel.scale);
        }
        this.screenRoot.init(this.field_22789, this.field_22790);
        ArrayList<ConfigGuiEntry> originalList = new ArrayList<ConfigGuiEntry>(this.configList);
        this.configList.clear();
        for (ConfigGuiEntry configGuiEntry : originalList) {
            configGuiEntry.y = startY + 12 + (20 * i++ + 20);
            this.configList.add(configGuiEntry);
            IDrawing.setPositionAndWidth((class_339)configGuiEntry.widget, (int)(this.field_22789 - this.screenRoot.startX - 60), (int)configGuiEntry.y, (int)configGuiEntry.widgetWidth);
            this.addDrawableChild(configGuiEntry.widget);
        }
        boolean bl = false;
        while (var4_7 < this.inlineComponentList.size()) {
            InlineComponentEntry inlineComponentEntry = this.inlineComponentList.get((int)var4_7);
            inlineComponentEntry.setAvailableWidth(this.screenRoot.width);
            for (int j = 0; j < inlineComponentEntry.widgetList.size(); ++j) {
                class_339 widget = inlineComponentEntry.widgetList.get(j);
                UtilitiesClient.setWidgetX((class_339)widget, (int)(inlineComponentEntry.calculateWidth() * j));
                this.addDrawableChild(widget);
            }
            this.inlineComponentList.set((int)var4_7, inlineComponentEntry);
            ++var4_7;
        }
        if (!this.initalized) {
            this.initalized = true;
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        try {
            this.elapsedTime += (double)delta;
            int startY = 0;
            this.renderBG(matrices);
            for (TextLabel component : this.customText) {
                int textWidth = (int)((float)this.field_22793.method_27525((class_5348)component.text) * component.scale);
                int componentX = this.screenRoot.startX + ScreenAlignment.getX(component.horizontalAlignment, this.screenRoot.width, textWidth);
                int componentY = (int)((double)startY + component.y);
                matrices.method_22903();
                matrices.method_46416((float)componentX, (float)componentY, 0.0f);
                matrices.method_22905(component.scale, component.scale, component.scale);
                this.field_22793.method_30881(matrices, component.text, 0.0f, 0.0f, -1);
                startY = (int)((float)startY + 12.0f * component.scale);
                matrices.method_22909();
            }
            for (ConfigGuiEntry entry : this.configList) {
                boolean mouseXInScreenRoot = RailwayData.isBetween((double)mouseX, (double)this.screenRoot.startX, (double)(this.screenRoot.startX + this.screenRoot.width));
                boolean mouseYInThisEntry = RailwayData.isBetween((double)mouseY, (double)entry.y, (double)(entry.y + entry.widgetHeight));
                if (mouseXInScreenRoot && mouseYInThisEntry) {
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    RenderHelper.disableTexture();
                    RenderHelper.setShaderColor(1.0f, 1.0f, 1.0f, 0.3f);
                    RenderHelper.fill(matrices, this.screenRoot.startX, entry.y, this.screenRoot.width, entry.widgetHeight, -1);
                    RenderHelper.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
                    RenderHelper.enableTexture();
                }
                ConfigScreenBase.method_27535((class_4587)matrices, (class_327)this.field_22793, (class_2561)entry.text, (int)this.screenRoot.startX, (int)(entry.y + entry.widgetHeight / 4), (int)-1);
            }
            int inlineRow = 1;
            int bottomPadding = 20;
            for (InlineComponentEntry entry : this.inlineComponentList) {
                int startInlineY = ScreenAlignment.getY(entry.verticalAlignment, this.field_22790, 20) - 20 * this.inlineComponentList.size() - bottomPadding;
                int y = startInlineY + 20 * inlineRow;
                int totalWidth = entry.calculateWidth() * entry.widgetList.size() + 10 * entry.widgetList.size();
                int startX = ScreenAlignment.getX(entry.horizontalAlignment, this.field_22789, totalWidth);
                for (int i = 0; i < entry.widgetList.size(); ++i) {
                    class_339 widget = entry.widgetList.get(i);
                    int buttonX = startX + entry.calculateWidth() * i + 10 * i;
                    IDrawing.setPositionAndWidth((class_339)widget, (int)buttonX, (int)y, (int)entry.calculateWidth());
                }
                ++inlineRow;
            }
            super.method_25394(matrices, mouseX, mouseY, delta);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifier) {
        if (keyCode == 256) {
            this.closeScreen(true);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifier);
    }

    private void renderBG(class_4587 matrices) {
        class_289 tesselator = class_289.method_1348();
        class_287 bufferBuilder = tesselator.method_1349();
        double easing = this.easeOutAnimation(Math.min(1.0, this.elapsedTime / 20.0));
        this.renderTexture(matrices, bufferBuilder, BACKGROUND, this.field_22789, this.field_22790, 1.0f, 1.0f);
        tesselator.method_1350();
        int starBackgroundSize = Math.max(this.field_22789, this.field_22790) * 4;
        float starUVSize = (float)starBackgroundSize / 384.0f;
        matrices.method_22903();
        matrices.method_22904(0.0, (1.0 - easing) * ((double)this.field_22790 * 0.2), 0.0);
        matrices.method_22904((double)this.field_22789 / 2.0, (double)this.field_22790 / 2.0, 0.0);
        float rotationAngle = (float)this.elapsedTime * -0.075f % 360.0f;
        matrices.method_22907(new Quaternionf(0.0f, 0.0f, 1.0f, rotationAngle / 360.0f));
        matrices.method_22904((double)(-this.field_22789) / 2.0, (double)(-this.field_22790) / 2.0, 0.0);
        this.renderTexture(matrices, bufferBuilder, STAR_BACKGROUND, starBackgroundSize, starBackgroundSize, starUVSize, starUVSize);
        matrices.method_22909();
        tesselator.method_1350();
        int terrainHeight = this.field_22789 / 4;
        matrices.method_22903();
        matrices.method_22904(0.0, (double)this.field_22790 - (double)terrainHeight * easing, 0.0);
        this.renderTexture(matrices, bufferBuilder, TERRAIN_BACKGROUND, this.field_22789, terrainHeight, 1.0f, 1.0f);
        matrices.method_22909();
        tesselator.method_1350();
    }

    private void renderTexture(class_4587 matrices, class_287 bufferBuilder, class_2960 identifier, float width, float height, float u, float v) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderHelper.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderHelper.setTexture(this.field_22787, identifier);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        class_4587.class_4665 pose = matrices.method_23760();
        bufferBuilder.method_22918(pose.method_23761(), 0.0f, height, 0.0f).method_22913(0.0f, v).method_1336(255, 255, 255, 255).method_1344();
        bufferBuilder.method_22918(pose.method_23761(), width, height, 0.0f).method_22913(u, v).method_1336(255, 255, 255, 255).method_1344();
        bufferBuilder.method_22918(pose.method_23761(), width, 0.0f, 0.0f).method_22913(u, 0.0f).method_1336(255, 255, 255, 255).method_1344();
        bufferBuilder.method_22918(pose.method_23761(), 0.0f, 0.0f, 0.0f).method_22913(0.0f, 0.0f).method_1336(255, 255, 255, 255).method_1344();
    }

    public void closeScreen(boolean save) {
        if (save) {
            this.onSave();
        }
        super.method_25419();
    }

    public void onSave() {
    }

    protected static class_2561 getBooleanButtonText(boolean state) {
        return Text.translatable((String)(state ? "options.mtr.on" : "options.mtr.off"), (Object[])new Object[0]);
    }

    private double easeOutAnimation(double x) {
        return x == 1.0 ? 1.0 : 1.0 - Math.pow(1.0 - x, 5.0);
    }
}

