/*
 * Decompiled with CFR 0.152.
 */
package forge.com.jsblock;

import forge.com.jsblock.Joban;
import forge.com.jsblock.JobanClient;
import forge.com.jsblock.Particles;
import forge.com.jsblock.client.JobanCustomResources;
import forge.com.jsblock.mappings.ForgeConfig;
import forge.com.jsblock.mappings.ForgeUtilities;
import mtr.CreativeModeTabs;
import mtr.Registry;
import mtr.RegistryObject;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.DeferredRegisterHolder;
import mtr.mappings.RegistryUtilities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="jsblock")
public class JobanForge {
    private static final DeferredRegisterHolder<Item> ITEMS = new DeferredRegisterHolder("jsblock", ForgeUtilities.registryGetItem());
    private static final DeferredRegisterHolder<Block> BLOCKS = new DeferredRegisterHolder("jsblock", ForgeUtilities.registryGetBlock());
    private static final DeferredRegisterHolder<BlockEntityType<?>> BLOCK_ENTITY_TYPES = new DeferredRegisterHolder("jsblock", ForgeUtilities.registryGetBlockEntityType());
    private static final DeferredRegisterHolder<ParticleType<?>> PARTICLE_TYPES = new DeferredRegisterHolder("jsblock", ForgeUtilities.registryGetParticleType());

    public JobanForge() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ForgeUtilities.registerModEventBus("jsblock", eventBus);
        ITEMS.register();
        BLOCKS.register();
        BLOCK_ENTITY_TYPES.register();
        PARTICLE_TYPES.register();
        eventBus.register(MTRForgeRegistry.class);
    }

    private static void registerBlock(String path, RegistryObject<Block> block) {
        BLOCKS.register(path, () -> block.get());
    }

    private static void registerItem(String path, RegistryObject<Item> item) {
        ITEMS.register(path, () -> item.get());
    }

    private static void registerParticle(String resourceLocation, SimpleParticleType particle) {
        PARTICLE_TYPES.register(resourceLocation, () -> Particles.LIGHT_BLOCK.get());
    }

    private static void registerBlockAndItems(String path, RegistryObject<Block> block, CreativeModeTabs.Wrapper creativeModeTabWrapper) {
        JobanForge.registerBlock(path, block);
        ITEMS.register(path, () -> {
            BlockItem blockItem = new BlockItem((Block)block.get(), RegistryUtilities.createItemProperties(() -> ((CreativeModeTabs.Wrapper)creativeModeTabWrapper).get()));
            Registry.registerCreativeModeTab((ResourceLocation)creativeModeTabWrapper.resourceLocation, (Item)blockItem);
            return blockItem;
        });
    }

    private static <T extends BlockEntityMapper> void registerBlockEntityType(String path, RegistryObject<? extends BlockEntityType<? extends BlockEntityMapper>> blockEntityType) {
        BLOCK_ENTITY_TYPES.register(path, () -> blockEntityType.get());
    }

    static {
        Joban.init(JobanForge::registerBlock, JobanForge::registerItem, JobanForge::registerBlockAndItems, JobanForge::registerBlockEntityType, JobanForge::registerParticle);
    }

    private static class MTRForgeRegistry {
        private MTRForgeRegistry() {
        }

        @SubscribeEvent
        public static void onClientSetupEvent(FMLClientSetupEvent event) {
            JobanClient.init();
            ForgeConfig.registerConfig();
            ForgeUtilities.registerTextureStitchEvent(textureAtlas -> {
                if (((TextureAtlas)textureAtlas).m_118330_().m_135815_().equals("textures/atlas/blocks.png")) {
                    JobanCustomResources.reload(Minecraft.m_91087_().m_91098_());
                }
            });
        }
    }
}

