/*
 * Decompiled with CFR 0.152.
 */
package forge.com.jsblock.block;

import java.util.List;
import mtr.block.IBlock;
import mtr.data.IPIDS;
import mtr.mappings.BlockDirectionalMapper;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.mappings.Text;
import mtr.packet.PacketTrainDataGuiServer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;

public abstract class BlockPIDSBaseHorizontal
extends BlockDirectionalMapper
implements EntityBlockMapper,
IPIDS {
    public BlockPIDSBaseHorizontal() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76419_).m_60999_().m_60978_(2.0f).m_60953_(state -> 5));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        return IBlock.checkHoldingBrush((Level)world, (Player)player, () -> {
            BlockPos otherPos = pos.m_121945_((Direction)IBlock.getStatePropertySafe((BlockState)state, (Property)f_54117_));
            BlockEntity entity1 = world.m_7702_(pos);
            BlockEntity entity2 = world.m_7702_(otherPos);
            if (entity1 instanceof TileEntityBlockPIDSBaseHorizontal && entity2 instanceof TileEntityBlockPIDSBaseHorizontal) {
                ((TileEntityBlockPIDSBaseHorizontal)entity1).syncData();
                ((TileEntityBlockPIDSBaseHorizontal)entity2).syncData();
                PacketTrainDataGuiServer.openPIDSConfigScreenS2C((ServerPlayer)((ServerPlayer)player), (BlockPos)pos, (BlockPos)otherPos, (int)((TileEntityBlockPIDSBaseHorizontal)entity1).getMaxArrivals(), (int)((TileEntityBlockPIDSBaseHorizontal)entity1).getLinesPerArrival());
            }
        });
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor world, BlockPos pos, BlockPos posFrom) {
        if (IBlock.getStatePropertySafe((BlockState)state, (Property)f_54117_) == direction && !newState.m_60713_((Block)this)) {
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction direction = ctx.m_8125_().m_122424_();
        return IBlock.isReplaceable((BlockPlaceContext)ctx, (Direction)direction, (int)2) ? (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction) : null;
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        Direction facing = (Direction)IBlock.getStatePropertySafe((BlockState)state, (Property)f_54117_);
        if (facing == Direction.SOUTH || facing == Direction.WEST) {
            IBlock.onBreakCreative((Level)world, (Player)player, (BlockPos)pos.m_121945_(facing));
        }
        super.m_5707_(world, pos, state, player);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        if (!world.f_46443_) {
            Direction direction = (Direction)IBlock.getStatePropertySafe((BlockState)state, (Property)f_54117_);
            world.m_7731_(pos.m_121945_(direction), (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction.m_122424_()), 3);
            world.m_46672_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)world, pos, 3);
            BlockEntity entity1 = world.m_7702_(pos);
            BlockEntity entity2 = world.m_7702_(pos.m_121945_(direction));
            if (entity1 instanceof TileEntityBlockPIDSBaseHorizontal && entity2 instanceof TileEntityBlockPIDSBaseHorizontal) {
                System.arraycopy(((TileEntityBlockPIDSBaseHorizontal)entity1).messages, 0, ((TileEntityBlockPIDSBaseHorizontal)entity2).messages, 0, Math.min(((TileEntityBlockPIDSBaseHorizontal)entity1).messages.length, ((TileEntityBlockPIDSBaseHorizontal)entity2).messages.length));
            }
        }
    }

    public void m_5871_(ItemStack stack, BlockGetter blockGetter, List<Component> tooltip, TooltipFlag tooltipFlag) {
        BlockEntityMapper blockEntity = this.createBlockEntity(new BlockPos(0, 0, 0), null);
        if (blockEntity instanceof IPIDS.TileEntityPIDS) {
            tooltip.add((Component)Text.translatable((String)"tooltip.mtr.arrivals", (Object[])new Object[]{((IPIDS.TileEntityPIDS)blockEntity).getMaxArrivals()}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
        }
    }

    public PushReaction m_5537_(BlockState blockState) {
        return PushReaction.BLOCK;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    public static abstract class TileEntityBlockPIDSBaseHorizontal
    extends IPIDS.TileEntityPIDS {
        public TileEntityBlockPIDSBaseHorizontal(BlockEntityType<?> type, BlockPos pos, BlockState state) {
            super(type, pos, state);
        }

        public int getLinesPerArrival() {
            return 1;
        }
    }
}

