/*
 * Decompiled with CFR 0.152.
 */
package forge.com.jsblock.block;

import forge.com.jsblock.BlockEntityTypes;
import forge.com.jsblock.packet.PacketServer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import mtr.MTR;
import mtr.block.IBlock;
import mtr.data.DataCache;
import mtr.data.Platform;
import mtr.data.RailwayData;
import mtr.data.ScheduleEntry;
import mtr.mappings.BlockDirectionalMapper;
import mtr.mappings.BlockEntityClientSerializableMapper;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.mappings.TickableMapper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ButterflyLight
extends BlockDirectionalMapper
implements EntityBlockMapper {
    public static final BooleanProperty LIT = BooleanProperty.m_61465_((String)"lit");

    public ButterflyLight(BlockBehaviour.Properties blockProperties) {
        super(blockProperties);
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)ctx.m_8125_())).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.m_5776_()) {
            BlockEntity entity = world.m_7702_(pos);
            if (!(entity instanceof TileEntityButterFlyLight)) {
                return InteractionResult.FAIL;
            }
            IBlock.checkHoldingBrush((Level)world, (Player)player, () -> PacketServer.sendButterflyConfigScreenS2C((ServerPlayer)player, pos, ((TileEntityButterFlyLight)entity).getSecondsToBlink()));
        }
        return InteractionResult.SUCCESS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)IBlock.getStatePropertySafe((BlockState)state, (Property)f_54117_);
        return IBlock.getVoxelShapeByDirection((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)5.8, (double)10.0, (Direction)facing);
    }

    public BlockEntityType<? extends BlockEntityMapper> getType() {
        return (BlockEntityType)BlockEntityTypes.BUTTERFLY_LIGHT_TILE_ENTITY.get();
    }

    public <T extends BlockEntityMapper> void tick(Level world, BlockPos pos, T blockEntity) {
        ((TileEntityButterFlyLight)blockEntity).tick(world, pos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, LIT});
    }

    public BlockEntityMapper createBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityButterFlyLight(pos, state);
    }

    public static class TileEntityButterFlyLight
    extends BlockEntityClientSerializableMapper
    implements TickableMapper {
        private int secondsToBlink = 10;
        private static final String KEY_SECONDS_TO_BLINK = "seconds_to_blink";

        public TileEntityButterFlyLight(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityTypes.BUTTERFLY_LIGHT_TILE_ENTITY.get(), pos, state);
        }

        public void readCompoundTag(CompoundTag compoundTag) {
            this.secondsToBlink = compoundTag.m_128451_(KEY_SECONDS_TO_BLINK);
            super.readCompoundTag(compoundTag);
        }

        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.m_128405_(KEY_SECONDS_TO_BLINK, this.secondsToBlink);
            super.writeCompoundTag(compoundTag);
        }

        public void setData(int secondsToBlink) {
            this.secondsToBlink = secondsToBlink;
            this.m_6596_();
            this.syncData();
        }

        public int getSecondsToBlink() {
            return this.secondsToBlink;
        }

        public void tick() {
            this.tick(this.f_58857_, this.f_58858_);
        }

        public <T extends BlockEntityMapper> void tick(Level world, BlockPos pos) {
            if (MTR.isGameTickInterval((int)20) && world != null && !world.f_46443_) {
                BlockState state = world.m_8055_(pos);
                RailwayData railwayData = RailwayData.getInstance((Level)world);
                boolean lastBlockLit = (Boolean)IBlock.getStatePropertySafe((BlockState)state, (Property)LIT);
                if (railwayData != null) {
                    int seconds;
                    long platformId = RailwayData.getClosePlatformId((Set)railwayData.platforms, (DataCache)railwayData.dataCache, (BlockPos)pos, (int)5, (int)3, (int)3);
                    if (platformId == 0L) {
                        if (lastBlockLit) {
                            world.m_46597_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
                        }
                        return;
                    }
                    List schedules = railwayData.getSchedulesAtPlatform(platformId);
                    if (schedules == null || schedules.isEmpty()) {
                        if (lastBlockLit) {
                            world.m_46597_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
                        }
                        return;
                    }
                    ArrayList scheduleList = new ArrayList(schedules);
                    Collections.sort(scheduleList);
                    if (((ScheduleEntry)scheduleList.get((int)0)).arrivalMillis - System.currentTimeMillis() > 0L) {
                        if (lastBlockLit) {
                            world.m_46597_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
                        }
                        return;
                    }
                    int remainingSecond = (int)(((ScheduleEntry)scheduleList.get((int)0)).arrivalMillis - System.currentTimeMillis()) / 1000;
                    Platform platform = (Platform)railwayData.dataCache.platformIdMap.get(platformId);
                    int n = seconds = platform == null ? 0 : platform.getDwellTime() / 2 - Math.abs(remainingSecond);
                    if (!lastBlockLit && seconds < this.secondsToBlink) {
                        world.m_46597_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)));
                    }
                }
            }
        }
    }
}

