/*
 * Decompiled with CFR 0.152.
 */
package forge.com.jsblock.block;

import forge.com.jsblock.BlockEntityTypes;
import forge.com.jsblock.Joban;
import forge.com.jsblock.block.ThirdBlockBase;
import forge.com.jsblock.packet.PacketServer;
import java.util.UUID;
import mtr.block.IBlock;
import mtr.mappings.BlockEntityClientSerializableMapper;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.EntityBlockMapper;
import mtr.mappings.Text;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FareSaver1
extends ThirdBlockBase
implements EntityBlockMapper {
    public FareSaver1(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        Direction facing = (Direction)IBlock.getStatePropertySafe((BlockState)state, (Property)f_54117_);
        return IBlock.getVoxelShapeByDirection((double)3.0, (double)0.0, (double)6.0, (double)13.0, (double)16.0, (double)9.0, (Direction)facing);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.m_5776_()) {
            UUID playerUUID = player.m_20148_();
            BlockEntity entity = world.m_7702_(pos);
            if (!(entity instanceof TileEntityFareSaver)) {
                return InteractionResult.FAIL;
            }
            IBlock.checkHoldingBrush((Level)world, (Player)player, () -> PacketServer.sendFaresaverConfigScreenS2C((ServerPlayer)player, pos, ((TileEntityFareSaver)entity).getDiscount()), () -> {
                int discount = ((TileEntityFareSaver)entity).getDiscount();
                if (discount > 0) {
                    player.m_5661_((Component)Text.translatable((String)"gui.jsblock.faresaver.done", (Object[])new Object[]{discount}), true);
                } else {
                    player.m_5661_((Component)Text.translatable((String)"gui.jsblock.faresaver.done_sarcasm", (Object[])new Object[]{discount}), true);
                }
                Joban.discountMap.put((Object)playerUUID, discount);
            });
        }
        return InteractionResult.SUCCESS;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, THIRD});
    }

    public BlockEntityType<? extends BlockEntityMapper> getType() {
        return (BlockEntityType)BlockEntityTypes.FARESAVER_1_TILE_ENTITY.get();
    }

    public BlockEntityMapper createBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityFareSaver(pos, state);
    }

    public static class TileEntityFareSaver
    extends BlockEntityClientSerializableMapper {
        private int discount = 2;
        private static final String KEY_DISCOUNT = "discount";

        public TileEntityFareSaver(BlockPos pos, BlockState state) {
            super((BlockEntityType)BlockEntityTypes.FARESAVER_1_TILE_ENTITY.get(), pos, state);
        }

        public void readCompoundTag(CompoundTag compoundTag) {
            this.discount = compoundTag.m_128451_(KEY_DISCOUNT);
            super.readCompoundTag(compoundTag);
        }

        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.m_128405_(KEY_DISCOUNT, this.discount);
        }

        public void setAllData(int discount) {
            IBlock.EnumThird thisPart = (IBlock.EnumThird)IBlock.getStatePropertySafe((BlockState)this.m_58900_(), (Property)IBlock.THIRD);
            if (thisPart == IBlock.EnumThird.LOWER) {
                this.setData(this.f_58858_.m_7494_(), discount);
                this.setData(this.f_58858_.m_6630_(2), discount);
            } else if (thisPart == IBlock.EnumThird.MIDDLE) {
                this.setData(this.f_58858_.m_7495_(), discount);
                this.setData(this.f_58858_.m_7494_(), discount);
            } else {
                this.setData(this.f_58858_.m_7495_(), discount);
                this.setData(this.f_58858_.m_6625_(2), discount);
            }
            this.setData(discount);
        }

        public void setData(BlockPos pos, int discount) {
            if (this.f_58857_ == null) {
                return;
            }
            BlockEntity entity = this.f_58857_.m_7702_(pos);
            if (entity instanceof TileEntityFareSaver) {
                ((TileEntityFareSaver)entity).setData(discount);
            }
        }

        public void setData(int discount) {
            this.discount = discount;
            this.m_6596_();
            this.syncData();
        }

        public int getDiscount() {
            return this.discount;
        }
    }
}

